<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

// Layout class
if ( FinbuzzTheme::$layout == 'full-width' ) {
	$finbuzz_layout_class = 'col-sm-12 col-12';
}
else{
	$finbuzz_layout_class = FinbuzzTheme_Helper::has_active_widget();
}

$iso						= 'no-equal-gallery';

if ( FinbuzzTheme::$options['team_archive_style'] == 'style1' ){
	$team_archive_layout 		= "team-default team-multi-layout-1 team-grid-style1";
	$template 				 	= 'team-1';
	$team_col_class				="col-lg-4 col-md-6 col-sm-6 col-xs-12";
}elseif( FinbuzzTheme::$options['team_archive_style'] == 'style2' ){
	$team_archive_layout 		= "team-default team-multi-layout-2 team-grid-style1";
	$template 				 	= 'team-2';
	$team_col_class				="col-lg-6 col-md-6 col-sm-6 col-xs-12";
}
else{
	$team_archive_layout 		= "team-default team-multi-layout-1 team-grid-style1";
	$template 				 	= 'team-1';
}

?>
<?php get_header(); ?>
<div id="primary" class="content-area">
	<div class="container">	
		<div class="row">
			<?php
				if ( FinbuzzTheme::$layout == 'left-sidebar' ) {
					get_sidebar();
				}
			?>
			<div class="<?php echo esc_attr( $team_archive_layout );?> <?php echo esc_attr( $finbuzz_layout_class );?>">
				<main id="main" class="site-main">
					<div class="rt-sidebar-sapcer">	
						<?php if(category_description(  )){ ?>
							<div class="category-description">
								<?php echo category_description(); ?>
							</div>
						<?php } ?>				
						<?php 
						$delay = 100;
						if ( have_posts() ) :?>
							<div class="row <?php echo esc_attr( $iso );?>">
								<?php while ( have_posts() ) : the_post(); ?>
									<div class="<?php echo esc_attr($team_col_class); ?> wow fadeInUp"  data-wow-delay="<?php echo esc_attr( $delay."ms" ); ?>" data-wow-duration="800ms">
										<?php get_template_part( 'template-parts/content', $template ); ?>
									</div>
								<?php 
								$delay+=100 ;
								endwhile; ?>
							</div>
						<?php FinbuzzTheme_Helper::pagination(); ?>	
						<?php else:?>
							<?php get_template_part( 'template-parts/content', 'none' );?>
						<?php endif;?>
					</div>
				</main>
			</div>
			<?php
				if( FinbuzzTheme::$layout == 'right-sidebar' ){				
					get_sidebar();
				}
			?>
		</div>
	</div>
</div>
<?php get_footer(); ?>
