<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */
$ul_class = $post_classes = '';

$thumb_size = 'finbuzz-size2';

$finbuzz_has_entry_meta  = ( FinbuzzTheme::$options['blog_date'] || FinbuzzTheme::$options['blog_author_name'] || FinbuzzTheme::$options['blog_cats']  ) ? true : false;

$finbuzz_time_html = sprintf( '<span>%s</span> <span>%s</span>', get_the_time( 'd' ), get_the_time( 'M' ), get_the_time( 'Y' ) );

$thumbnail = false;

if (  FinbuzzTheme::$layout == 'right-sidebar' || FinbuzzTheme::$layout == 'right-sidebar' ){
	$post_classes = array( 'col-lg-6 col-md-6 col-sm-6 col-12 blog-layout-1' );
	$ul_class = 'side_bar';
} else {
	$post_classes = array( 'col-lg-4 col-md-4 col-sm-4 col-12  blog-layout-1' );
	$ul_class = '';
}

if ( empty(has_post_thumbnail() ) ) {
	$img_class ='no_image';
}else {
	$img_class ='show_image';
}

$id = get_the_ID();
$content = get_the_content();
$content = wp_trim_words( get_the_excerpt(), FinbuzzTheme::$options['post_content_limit'], '' );	
?>
<div id="post-<?php the_ID(); ?>" <?php post_class( $post_classes ); ?>>
	<div class="blog-box <?php echo esc_attr($img_class); ?>">
		<?php if ( has_post_thumbnail() || FinbuzzTheme::$options['display_no_preview_image'] == '1'  ) { ?>
		<div class="blog-img-holder">
			<div class="blog-img">
				<a href="<?php the_permalink(); ?>" class="img-opacity-hover"><?php if ( has_post_thumbnail() ) { ?>
					<?php the_post_thumbnail( $thumb_size, ['class' => 'img-responsive'] ); ?>
						<?php } else {
						if ( FinbuzzTheme::$options['display_no_preview_image'] == '1' ) {
							if ( !empty( FinbuzzTheme::$options['no_preview_image']['id'] ) ) {
								$thumbnail = wp_get_attachment_image( FinbuzzTheme::$options['no_preview_image']['id'], $thumb_size );						
							}
							elseif ( empty( FinbuzzTheme::$options['no_preview_image']['id'] ) ) {
								$thumbnail = '<img class="wp-post-image" src="'.FINBUZZ_IMG_URL.'noimage_420X435.jpg" alt="'. the_title_attribute( array( 'echo'=> false ) ) .'">';
							}
							echo wp_kses( $thumbnail , 'alltext_allow' );
						}
					}
					?>
				</a>
			</div>
		</div>
		<?php } ?>
		<div class="entry-content">
			<?php if ( $finbuzz_has_entry_meta ) { ?>
				<ul class="entry-meta">
					<?php if ( FinbuzzTheme::$options['blog_author_name'] ) { ?>
						<li class="item-author"><i class="far fa-user"></i><?php esc_html_e( 'by ', 'finbuzz' );?><?php the_author_posts_link(); ?>
						</li>
					<?php } ?>
					<?php  if ( FinbuzzTheme::$options['blog_cats'] ) { ?>
						<li class="blog-cat"><i class="far fa-folder-open"></i><?php echo the_category( ', ' );?></li>
					<?php } ?>
				</ul>
			<?php } ?>
			<h3 class="entry-title"><a href="<?php the_permalink();?>"><?php the_title();?></a></h3>
			<?php if ( FinbuzzTheme::$options['blog_date'] ) { ?>			
				<div class="blog-date">
					<span class="day"><?php echo the_time('d') ?></span>
					<span class="month"><?php echo the_time('M') ?></span>	
				</div>	
			<?php } ?>
		</div>
	</div>
</div>