<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */
$thumb_size = 'full';

$service_video_link  	= get_post_meta( $post->ID, 'service_video_link', true );

?>
<div id="post-<?php the_ID(); ?>" <?php post_class( 'service-single' ); ?>>
	<div class="single-service-inner">
		<div class="post-thumb">
			<?php
				if ( has_post_thumbnail() ){
					the_post_thumbnail( $thumb_size );
				} else {
					if ( !empty( FinbuzzTheme::$options['no_preview_image']['id'] ) ) {
						echo wp_get_attachment_image( FinbuzzTheme::$options['no_preview_image']['id'], $thumb_size );
					} else {
						echo '<img class="wp-post-image" src="' . FinbuzzTheme_Helper::get_img( 'noimage_1210X584.jpg' ) . '" alt="'. the_title_attribute( array( 'echo'=> false ) ) .'">';
					}
				}
			?>
			<?php if($service_video_link ){ ?>
				<div class="video-icon">
					<a class="rtin-play  rt-video-popup" href="<?php echo esc_url( $service_video_link ); ?>"><span class="play-icon"><i class="fas fa-play"></i></span></a>
				</div>
			<?php } ?>
		</div>
		<?php the_content(); ?>
		<?php  if( FinbuzzTheme::$options['show_related_service'] == '1' && is_single() && !empty ( finbuzz_related_service() ) ) { ?>	
		<div class="related-service">
			<?php  finbuzz_related_service(); ?>
		</div>
		<?php } ?>
	</div>
</div>