<?php
/**
 * 
 * 
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Finbuzz_Core;
use Elementor\Utils;
use Elementor\Group_Control_Background;
extract( $data );

?>


<div class="pricing-wrapper">
    <div class="price-switch-box price-switch-box--active price-switch-box--style-1">
        <span class="pack-name"><?php echo esc_html($data['yearly_label'] ); ?></span>
            <div class="pricing-switch-container">
                <div class="pricing-switch"></div>
                <div class="pricing-switch pricing-switch-active"></div>
                <div class="switch-button"></div>
            </div>
        <span class="pack-name"><?php echo esc_html($data['monthly_label'] ); ?></span>
    </div>
    <div class="pricing-plan-wrapper">
        <?php if(!empty($data['prices_infos'])){ 
            foreach($data['prices_infos'] as $index=>$price_info){
            ?>
            <div class="pricing pricing--style-2">
                <div class="pricing__content">
                    <?php if($price_info['title']){ ?>
                        <div class="item-content">
                            <h3 class="pricing__title"><?php echo wp_kses_post($price_info['title']); ?></h3>
                        </div>
                    <?php } ?>
                    <div class="pricing__price-heading">
                        <?php if($price_info['monthly_price']){ ?>
                            <div class="price-box price-box-show">
                                <span class="pricing__price"><?php echo wp_kses_post($price_info['monthly_price']); ?></span><span class="pack-duration">/ Month</span>
                            </div>
                        <?php } ?>
                        <?php if($price_info['yearly_price']){ ?>
                            <div class="price-box price-box-hide">
                                <span class="pricing__price"><?php echo wp_kses_post($price_info['yearly_price']); ?></span><span class="pack-duration">/ Year</span>
                            </div>
                        <?php } ?>
                    </div>
                    <?php if($price_info['content']){ ?>
                        <p>
                        <?php echo wp_kses_post($price_info['content']); ?>
                        </p>
                    <?php } ?>
                    <?php if($price_info['list_item']){ ?>
                        <?php echo wp_kses_post($price_info['list_item']); ?>
                    <?php } ?>
                    <div class="pricing-button">
                        <a href="<?php if($price_info['btn_link']['url']){ echo $price_info['btn_link']['url']; } ?>" class="pricing-btn">Purchase Now</a>
                    </div>
                </div>
                <div class="item-svg"><img src="<?php echo FINBUZZ_ASSETS_URL . 'element/shape43.png'; ?>" alt="svg"></div>
            </div>
        <?php }
        } ?> 
    </div>
</div>


