<?php
get_header();
$sidebar_configs = findgo_get_blog_layout_configs();

findgo_render_breadcrumbs();
global $apus_author;
$apus_author = (isset($_GET['author_name'])) ? get_user_by('slug', $author_name) : get_userdata(intval($author));
?>
<section id="main-container" class="main-content content-space container inner">

	<a href="javascript:void(0)" class="mobile-sidebar-btn hidden-lg hidden-md"> <i class="fa fa-bars"></i> <?php echo esc_html__('Show Sidebar', 'findgo'); ?></a>
	<div class="mobile-sidebar-panel-overlay"></div>
		
	<div class="row">
		<div class="col-md-3">
		  	<aside class="sidebar sidebar-left" itemscope="itemscope" itemtype="http://schema.org/WPSideBar">
		  		<?php if ( is_active_sidebar( 'view-profile-sidebar' ) ): ?>
		   			<?php dynamic_sidebar( 'view-profile-sidebar' ); ?>
		   		<?php endif; ?>
		  	</aside>
		</div>

		<div id="main-content" class="col-md-9">
			<main id="main" class="site-main layout-user" role="main">
				<?php
					$action = isset($_GET['action']) ? $_GET['action'] : '';
					switch ($action) {
						case 'following':
							$user_ids = get_user_meta( $apus_author->ID, '_apus_following', true );
							get_job_manager_template( 'job_manager/profile/users.php', array('user_ids' => $user_ids) );
							break;
						case 'follower':
							$user_ids = get_user_meta( $apus_author->ID, '_apus_followers', true );
							get_job_manager_template( 'job_manager/profile/users.php', array('user_ids' => $user_ids) );
							break;
						case 'listings':
							get_template_part( 'job_manager/profile/listings' );
							break;
						case 'bookmarks':
							get_template_part( 'job_manager/profile/favorites' );
							break;
						case 'reviews':
							get_template_part( 'job_manager/profile/reviews' );
							break;
						default:
							get_template_part( 'job_manager/profile/user-profile' );
							break;
					}
				?>

			</main><!-- .site-main -->
		</div><!-- .content-area -->

		
	</div>
</section>
<?php get_footer(); ?>