<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the "site-content" div and all content after.
 *
 * @package WordPress
 * @subpackage Findgo
 * @since Findgo 1.0
 */
$footer = apply_filters( 'findgo_get_footer_layout', 'default' );
?>

	</div><!-- .site-content -->

	<footer id="apus-footer" class="apus-footer" role="contentinfo">
		<?php if ( !empty($footer) ): ?>
			<?php findgo_display_footer_builder($footer); ?>
		<?php else: ?>
			
			<div class="apus-copyright">
				<div class="container">
					<div class="copyright-content">
						<div class="text-copyright pull-left">
						<?php
							$allowed_html_array = array('strong' => array(),'a' => array('href' => array()));
							echo wp_kses( __('Copyright &copy; 2018 - Findgo. All Rights Reserved. <br/> Powered by <a href="//findgos.com">ApusThemes</a>', 'findgo'), $allowed_html_array);
						?>

						</div>
						
					</div>
				</div>
			</div>
		<?php endif; ?>
		
	</footer><!-- .site-footer -->

	<?php if ( findgo_get_config('back_to_top') ) { ?>
		<a href="#" id="back-to-top">
			<i class="fa fa-angle-up" aria-hidden="true"></i>
		</a>
	<?php } ?>
</div><!-- .site -->
<?php wp_footer(); ?>
</body>
</html>