<?php 

class Findgo_Apus_Userinfo{

	/**
	 * Constructor 
	 */
	public function __construct() {
		
		add_action( 'init', array($this, 'setup'), 1000 );
		add_action( 'wp_ajax_nopriv_apus_ajax_login',  array($this, 'processLogin') );
		add_action( 'wp_ajax_nopriv_apus_ajax_forgotpass',  array($this, 'processForgotPassword') );
		add_action( 'wp_ajax_nopriv_apus_ajax_register',  array($this, 'processRegister') );

		add_action( 'wp_ajax_findgo_process_change_profile_form', array($this, 'process_change_profile_form') );
		add_action( 'wp_ajax_nopriv_findgo_process_change_profile_form',  array($this, 'process_change_profile_form') );

		add_action( 'wp_ajax_findgo_process_change_password', array($this, 'process_change_password') );
		add_action( 'wp_ajax_nopriv_findgo_process_change_password',  array($this, 'process_change_password') );


		// backend user profile
		add_action( 'show_user_profile', array($this, 'user_profile_fields') );
		add_action( 'edit_user_profile', array($this, 'user_profile_fields') );
		// backend save user profile
		add_action( 'personal_options_update', array( $this, 'save_user_profile_fields' ) );
		add_action( 'edit_user_profile_update', array( $this, 'save_user_profile_fields' ) );

		// get avatar
		add_filter('get_avatar', array($this, 'get_avatar'), 10, 100);

		// permission
		add_action('init', array($this, 'set_user_permissions'));
		add_action( 'pre_get_posts', array( $this, 'media_files' ) );

		add_action( 'admin_enqueue_scripts', array($this, 'admin_script') );
	}

	public function processLogin() {
		// First check the nonce, if it fails the function will break
   		check_ajax_referer( 'ajax-apus-login-nonce', 'security_login' );

   		$info = array();
   		
   		$info['user_login'] = isset($_POST['username']) ? $_POST['username'] : '';
	    $info['user_password'] = isset($_POST['password']) ? $_POST['password'] : '';
	    $info['remember'] = isset($_POST['remember']) ? true : false;

		$user_signon = wp_signon( $info, false );
	    if ( is_wp_error($user_signon) ){
			$result = json_encode(array('loggedin' => false, 'msg' => esc_html__('Wrong username or password. Please try again!!!', 'findgo')));
	    } else {
			wp_set_current_user($user_signon->ID); 
	        $result = json_encode(array('loggedin' => true, 'msg' => esc_html__('Signin successful, redirecting...', 'findgo')));
	    }

   		echo trim($result);
   		die();
	}

	public function processForgotPassword() {
	 
		// First check the nonce, if it fails the function will break
	    check_ajax_referer( 'ajax-apus-lostpassword-nonce', 'security_lostpassword' );
		
		global $wpdb;
		
		$account = isset($_POST['user_login']) ? $_POST['user_login'] : '';
		
		if( empty( $account ) ) {
			$error = esc_html__( 'Enter an username or e-mail address.', 'findgo' );
		} else {
			if(is_email( $account )) {
				if( email_exists($account) ) {
					$get_by = 'email';
				} else {
					$error = esc_html__( 'There is no user registered with that email address.', 'findgo' );			
				}
			} else if (validate_username( $account )) {
				if( username_exists($account) ) {
					$get_by = 'login';
				} else {
					$error = esc_html__( 'There is no user registered with that username.', 'findgo' );				
				}
			} else {
				$error = esc_html__(  'Invalid username or e-mail address.', 'findgo' );		
			}
		}	
		
		if (empty ($error)) {
			$random_password = wp_generate_password();

			$user = get_user_by( $get_by, $account );
				
			$update_user = wp_update_user( array ( 'ID' => $user->ID, 'user_pass' => $random_password ) );
				
			if( $update_user ) {
				
				$from = get_option('admin_email');
				
				
				$to = $user->user_email;
				$subject = esc_html__( 'Your new password', 'findgo' );
				$sender = 'From: '.get_option('name').' <'.$from.'>' . "\r\n";
				
				$message = esc_html__( 'Your new password is: ', 'findgo' ) .$random_password;
					
				$headers[] = 'MIME-Version: 1.0' . "\r\n";
				$headers[] = 'Content-type: text/html; charset=iso-8859-1' . "\r\n";
				$headers[] = "X-Mailer: PHP \r\n";
				$headers[] = $sender;
					
				$mail = wp_mail( $to, $subject, $message, $headers );
				
				if( $mail ) {
					$success = esc_html__( 'Check your email address for you new password.', 'findgo' );
				} else {
					$error = esc_html__( 'System is unable to send you mail containg your new password.', 'findgo' );						
				}
			} else {
				$error =  esc_html__( 'Oops! Something went wrong while updating your account.', 'findgo' );
			}
		}
	
		if ( ! empty( $error ) ) {
			echo json_encode(array('loggedin'=> false, 'msg'=> ($error)));
		}
				
		if ( ! empty( $success ) ) {
			echo json_encode(array('loggedin' => true, 'msg'=> $success ));	
		}
		die();
	}


	/**
	 * add all actions will be called when user login.
	 */
	public function setup() {
		add_action('wp_footer', array( $this, 'popupForm' ) );
		add_action( 'apus-account-buttons', array( $this, 'button' ) );
	}

	/**
	 * render link login or show greeting when user logined in
	 *
	 * @return String.
	 */
	public function button(){
		if ( !is_user_logged_in() ) {
			?>
			<div class="setting-account">
				<span class="accountbt-hover"><i class="flaticon-avatar"></i></span>
				<ul class="user-account list-line">
					<li><a href="#apus_login_forgot_tab" class="apus-user-login wel-user"><?php esc_html_e( 'Login','findgo' ); ?></a> </li>
					<li><a href="#apus_register_tab" class="apus-user-register wel-user"><?php esc_html_e( 'Register','findgo' ); ?></a></li>
				</ul>
			</div>
			<?php
		} else {
			$user_id = get_current_user_id();
            $user = get_userdata( $user_id );
			?>
			<div class="pull-right">
                <div class="setting-account">
                   	<div class="accountbt-hover log-in">
                        <div class="profile-menus clearfix">
                            <div class="profile-avarta pull-left"><?php echo get_avatar($user_id, 32); ?></div>
                            <div class="profile-info pull-left">
                                <strong><?php echo esc_html($user->data->display_name); ?></strong>
                                <span class="caret"></span>
                            </div>
                        </div>
                        <span class="mobile-icon hidden"><i class="flaticon-avatar"></i></span>
                    </div>
                    <ul class="user-account user-log list-line">
                        
                        <?php
                        	if ( has_nav_menu( 'topmenu' ) ) {
                        		?>
                        		<li>
	                        		<?php
			                            $args = array(
			                                'theme_location'  => 'topmenu',
			                                'menu_class'      => 'list-line',
			                                'fallback_cb'     => '',
			                            );
			                            wp_nav_menu($args);
		                            ?>
	                            </li>
	                            <?php
	                        } 
                        ?>
                        <li><a href="<?php echo wp_logout_url(home_url()); ?>"><?php esc_html_e('Log out ','findgo'); ?></a></li>
                    </ul>
                </div>
            </div>
			<?php
		}
	}

	/**
	 * check if user not login that showing the form
	 */
	public function popupForm() {
		if ( !is_user_logged_in() ) {
 			get_template_part( 'template-parts/login-register' );
		}	
	}

	public function registration_validation( $username, $email, $password, $confirmpassword ) {
		global $reg_errors;
		$reg_errors = new WP_Error;
		if ( empty( $username ) || empty( $password ) || empty( $email ) || empty( $confirmpassword ) ) {
		    $reg_errors->add('field', esc_html__( 'Required form field is missing', 'findgo' ) );
		}

		if ( 4 > strlen( $username ) ) {
		    $reg_errors->add( 'username_length', esc_html__( 'Username too short. At least 4 characters is required', 'findgo' ) );
		}

		if ( username_exists( $username ) ) {
	    	$reg_errors->add('user_name', esc_html__( 'Sorry, that username already exists!', 'findgo' ) );
		}

		if ( ! validate_username( $username ) ) {
		    $reg_errors->add( 'username_invalid', esc_html__( 'Sorry, the username you entered is not valid', 'findgo' ) );
		}

		if ( 5 > strlen( $password ) ) {
	        $reg_errors->add( 'password', esc_html__( 'Password length must be greater than 5', 'findgo' ) );
	    }

	    if ( $password != $confirmpassword ) {
	        $reg_errors->add( 'password', esc_html__( 'Password must be equal Confirm Password', 'findgo' ) );
	    }

	    if ( !is_email( $email ) ) {
		    $reg_errors->add( 'email_invalid', esc_html__( 'Email is not valid', 'findgo' ) );
		}

		if ( email_exists( $email ) ) {
		    $reg_errors->add( 'email', esc_html__( 'Email Already in use', 'findgo' ) );
		}
	}

	public function complete_registration($username, $password, $email) {
        $userdata = array(
	        'user_login' => $username,
	        'user_email' => $email,
	        'user_pass' => $password,
        );
        return wp_insert_user( $userdata );
	}

	public function processRegister() {
		global $reg_errors;
		check_ajax_referer( 'ajax-apus-register-nonce', 'security_register' );
        $this->registration_validation( $_POST['username'], $_POST['email'], $_POST['password'], $_POST['confirmpassword'] );
        if ( 1 > count( $reg_errors->get_error_messages() ) ) {
	        $username = sanitize_user( $_POST['username'] );
	        $email = sanitize_email( $_POST['email'] );
	        $password = esc_attr( $_POST['password'] );
	 		
	        $res = $this->complete_registration($username, $password, $email);
	        if ( ! is_wp_error( $res ) ) {
	        	$jsondata = array('loggedin' => true, 'msg' => esc_html__( 'You have registered, redirecting ...', 'findgo' ) );
	        	$info['user_login'] = $username;
			    $info['user_password'] = $password;
			    $info['remember'] = 1;
				
				wp_signon( $info, false );
	        } else {
		        $jsondata = array('loggedin' => false, 'msg' => esc_html__( 'Register user error!', 'findgo' ) );
		    }
	    } else {
	    	$jsondata = array('loggedin' => false, 'msg' => implode(', <br>', $reg_errors->get_error_messages()) );
	    }
	    echo json_encode($jsondata);
	    exit;
	}

	public function process_change_profile_form() {

		check_ajax_referer( 'ajax-nonce', 'nonce' );

		$return = array();
		$user = wp_get_current_user();

		$nickname = isset($_POST['nickname']) ? sanitize_user( $_POST['nickname'] ) : '';
		$email = isset($_POST['email']) ? sanitize_email( $_POST['email'] ) : '';

		$general_keys = array( 'first_name', 'last_name', 'phone', 'description', 'url' );
		$keys = array(
			'current_user_avatar', 'address', 'birthday', 'marital_status', 'sex', 'socials'
		);

		if ( empty( $nickname ) ) {
			$return['msg'] = '<div class="text-danger">'.esc_html__( 'Nickname is required.', 'findgo' ).'</div>';
			echo json_encode($return); exit;
		}

		if ( empty( $email ) ) {
			$return['msg'] = '<div class="text-danger">'.esc_html__( 'E-mail is required.', 'findgo' ).'</div>';
			echo json_encode($return); exit;
		}

		update_user_meta( $user->ID, 'nickname', $nickname );

		update_user_meta( $user->ID, 'user_email', $email );
		wp_update_user( array(
			'ID'            => $user->ID,
			'user_email'    => $email,
		) );
		foreach ($general_keys as $key) {
			$value = isset($_POST[$key]) ? sanitize_text_field( $_POST[$key] ) : '';
			update_user_meta( $user->ID, $key, $value );
		}
		foreach ($keys as $key) {
			if ( $key !== 'socials' ) {
				$value = isset($_POST[$key]) ? sanitize_text_field( $_POST[$key] ) : '';
				if ( $key == 'current_user_avatar' ) {
					$attachment_id = findgo_create_attachment($value);
					update_user_meta( $user->ID, 'apus_user_avatar', $attachment_id );
				} else {
					update_user_meta( $user->ID, 'apus_'.$key, $value );
				}
			} else {
				$value = isset($_POST[$key]) ? $_POST[$key] : '';
				update_user_meta( $user->ID, 'apus_'.$key, $value );
			}
		}
		$return['msg'] = '<div class="text-success">'.esc_html__( 'Profile has been successfully updated.', 'findgo' ).'</div>';
		echo json_encode($return); exit;
	}

	public function process_change_password() {

		check_ajax_referer( 'ajax-nonce', 'nonce' );
		
		if ( !is_user_logged_in() ) {
			return;
		}

		$old_password = sanitize_text_field( $_POST['old_password'] );
		$new_password = sanitize_text_field( $_POST['new_password'] );
		$retype_password = sanitize_text_field( $_POST['retype_password'] );

		if ( empty( $old_password ) || empty( $new_password ) || empty( $retype_password ) ) {
			$return['msg'] = '<div class="text-danger">'.esc_html__( 'All fields are required.', 'findgo' ).'</div>';
			echo json_encode($return); exit;
		}

		if ( $new_password != $retype_password ) {
			$return['msg'] = '<div class="text-danger">'.esc_html__( 'New and retyped password are not same.', 'findgo' ).'</div>';
			echo json_encode($return); exit;
		}

		$user = wp_get_current_user();

		if ( ! wp_check_password( $old_password, $user->data->user_pass, $user->ID ) ) {
			$return['msg'] = '<div class="text-danger">'.esc_html__( 'Your old password is not correct.', 'findgo' ).'</div>';
			echo json_encode($return); exit;
		}

		wp_set_password( $new_password, $user->ID );
		
    	$info['user_login'] = $user->nickname;
	    $info['user_password'] = $new_password;
	    $info['remember'] = 1;
		wp_signon( $info, false );

		$return['msg'] = '<div class="text-success">'.esc_html__( 'Your password has been successfully changed.', 'findgo' ).'</div>';
		echo json_encode($return); exit;
	}

	public function get_avatar($avatar, $id_or_email='', $size='', $default='', $alt='') {
	    if (is_object($id_or_email)) {
	        
	        $avatar_id = get_the_author_meta( 'apus_user_avatar', $id_or_email->ID );
	        if ( !empty($avatar_id) ) {
	            $avatar_url = wp_get_attachment_image_src($avatar_id, 'full');
	            if ( !empty($avatar_url[0]) ) {
	                $avatar = '<img src="'.esc_url($avatar_url[0]).'" width="'.esc_attr($size).'" height="'.esc_attr($size).'" alt="'.esc_attr($alt).'" class="avatar avatar-'.esc_attr($size).' wp-user-avatar wp-user-avatar-'.esc_attr($size).' photo avatar-default" />';
	            }
	        }
	    } else {
	        $avatar_id = get_the_author_meta( 'apus_user_avatar', $id_or_email );
	        if ( !empty($avatar_id) ) {
	            $avatar_url = wp_get_attachment_image_src($avatar_id, 'full');
	            if ( !empty($avatar_url[0]) ) {
	                $avatar = '<img src="'.esc_url($avatar_url[0]).'" width="'.esc_attr($size).'" height="'.esc_attr($size).'" alt="'.esc_attr($alt).'" class="avatar avatar-'.esc_attr($size).' wp-user-avatar wp-user-avatar-'.esc_attr($size).' photo avatar-default" />';
	            }
	        }
	    }
	    return $avatar;
	}

	public function set_user_permissions() {
        $role = get_role( 'subscriber' );
        if ( is_object($role) ) {
	        $role->add_cap('upload_files');
	    }

        $role = get_role( 'customer' );
        if ( is_object($role) ) {
	        $role->add_cap('upload_files');
	    }
	}

	public function media_files( $wp_query ) {
		global $current_user;

		if ( ! current_user_can( 'manage_options' ) && ( is_admin() && $wp_query->query['post_type'] === 'attachment' ) ) {
			$wp_query->set( 'author', $current_user->ID );
		}
	}

	public function admin_script() {
		wp_enqueue_media();
		wp_enqueue_script( 'findgo-upload', get_template_directory_uri() . '/js/upload.js', array( 'jquery' ), '20150330', true );
	}
	/*
	 * back/end settings
	 *
	 */
	function user_profile_fields( $user ) {
		$data = get_userdata( $user->ID );
		$avatar = get_the_author_meta( 'apus_user_avatar', $user->ID );
		$avatar_url = wp_get_attachment_image_src($avatar, 'full');
		
		$address = get_the_author_meta( 'apus_address', $user->ID );
		$birthday = get_the_author_meta( 'apus_birthday', $user->ID );
		$marital_status = get_the_author_meta( 'apus_marital_status', $user->ID );
		$sex = get_the_author_meta( 'apus_sex', $user->ID );
		?>
		<h3><?php esc_html_e( 'User Profile', 'findgo' ); ?></h3>

		<table class="form-table">
			<tbody>
			
			<tr>
				<th>
					<label for="lecturer_job"><?php esc_html_e( 'Avatar', 'findgo' ); ?></label>
				</th>
				<td>
					<div class="screenshot-user avatar-screenshot">
			            <?php if ( !empty($avatar_url[0]) ) { ?>
			                <img src="<?php echo esc_url($avatar_url[0]); ?>" alt="<?php esc_attr_e( 'Avatar', 'findgo' ); ?>" />
			            <?php } ?>
			        </div>
			        <input class="widefat upload_image" name="user_avatar" type="hidden" value="<?php echo esc_attr($avatar); ?>" />
			        <div class="upload_image_action">
			            <input type="button" class="button radius-3x btn btn-theme user-add-image" value="<?php esc_attr_e( 'Add Avatar', 'findgo' ); ?>">
			            <input type="button" class="button radius-3x btn btn-theme-second user-remove-image" value="<?php esc_attr_e( 'Remove Avatar', 'findgo' ); ?>">
			        </div>
				</td>
			</tr>
			<tr>
				<th>
					<label for="lecturer_mobile"><?php esc_html_e( 'Address', 'findgo' ); ?></label>
				</th>
				<td>
					<input id="change-profile-form-address" type="text" name="address" class="form-control" value="<?php echo ! empty( $address ) ? esc_attr( $address ) : ''; ?>">
				</td>
			</tr>
			<tr>
				<th>
					<label for="lecturer_facebook"><?php esc_html_e( 'Birthday', 'findgo' ); ?></label>
				</th>
				<td>
					<input id="change-profile-form-birthday" type="text" name="birthday" class="form-control" value="<?php echo ! empty( $birthday ) ? esc_attr( $birthday ) : ''; ?>">
				</td>
			</tr>
			<tr>
				<th>
					<label for="lecturer_twitter"><?php esc_html_e( 'Marital status', 'findgo' ); ?></label>
				</th>
				<td>
					<select name="marital_status" class="form-control">
						<?php $options = findgo_marital_status_defaults(); foreach ($options as $key => $label) { ?>
							<option value="<?php echo esc_attr($key); ?>" <?php echo trim($key == $marital_status ? 'selected="selected"' : ''); ?>><?php echo esc_attr($label); ?></option>
						<?php } ?>
					</select>
				</td>
			</tr>
			<tr>
				<th>
					<label for="lecturer_google"><?php esc_html_e( 'Sex', 'findgo' ); ?></label>
				</th>
				<td>
					<div class="visible-inline-block">
					<?php $options = findgo_sex_defaults(); foreach ($options as $key => $label) { ?>
						<div class="sex-options">
							<input type="radio" name="sex" id="<?php echo esc_attr($key); ?>" value="<?php echo esc_attr($key); ?>" <?php echo trim($key == $sex ? 'checked="checked"' : ''); ?>> <label for="<?php echo esc_attr($key); ?>"><?php echo esc_attr($label); ?></label>
						</div>
					<?php } ?>
					</div>
				</td>
			</tr>
			<?php
				$options = findgo_user_social_defaults();
				$socials = get_user_meta( $user->ID, 'apus_socials', true );
				foreach ($options as $key => $label) {
					$value = isset($socials[$key]) ? $socials[$key] : '';
					?>
					<tr>
						<th>
							<label class="col-sm-2 control-label <?php echo esc_attr($key); ?>" for="change-profile-form-<?php echo esc_attr($key); ?>"> <i class="icon-<?php echo esc_attr($key); ?>"></i> <?php echo esc_attr($label); ?></label>
						</th>
						<td>
							<input id="change-profile-form-<?php echo esc_attr($key); ?>" type="text" name="socials[<?php echo esc_attr($key); ?>]" class="form-control" value="<?php echo esc_attr( $value ); ?>">
						</td>
					</tr><!-- /.form-group -->
					<?php
				}
			?>
			</tbody>
		</table>
		<?php
	}

	public function save_user_profile_fields( $user_id ) {
		if ( !current_user_can( 'edit_user', $user_id ) ) {
			return false;
		}

		$keys = array(
			'user_avatar', 'address', 'birthday', 'marital_status', 'sex', 'socials'
		);

		foreach ($keys as $key) {
			if ( $key !== 'socials' ) {
				$value = isset($_POST[$key]) ? sanitize_text_field( $_POST[$key] ) : '';
				update_user_meta( $user_id, 'apus_'.$key, $value );
			} else {
				$value = isset($_POST[$key]) ? $_POST[$key] : '';
				update_user_meta( $user_id, 'apus_'.$key, $value );
			}
		}
	}

}

new Findgo_Apus_Userinfo();
?>