<?php
require_once vc_path_dir('SHORTCODES_DIR', 'vc-posts-grid.php');

if ( !function_exists('findgo_load_post_element')) {
	function findgo_load_post_element() {
		$layouts = array(
			esc_html__('Grid', 'findgo') => 'grid',
			esc_html__('List', 'findgo') => 'list',
			esc_html__('Carousel', 'findgo') => 'carousel',
		);
		$columns = array(1,2,3,4,6);
		vc_map( array(
			'name' => esc_html__( 'Apus Grid Posts', 'findgo' ),
			'base' => 'apus_gridposts',
			'icon' => 'icon-wpb-news-12',
			"category" => esc_html__('Apus Post', 'findgo'),
			'description' => esc_html__( 'Create Post having blog styles', 'findgo' ),
			 
			'params' => array(
				array(
					'type' => 'loop',
					'heading' => esc_html__( 'Grids content', 'findgo' ),
					'param_name' => 'loop',
					'settings' => array(
						'size' => array( 'hidden' => false, 'value' => 4 ),
						'order_by' => array( 'value' => 'date' ),
					),
					'description' => esc_html__( 'Create WordPress loop, to populate content from your site.', 'findgo' )
				),
				array(
					'type' => 'checkbox',
					'heading' => esc_html__( 'Show Pagination?', 'findgo' ),
					'param_name' => 'show_pagination',
					'description' => esc_html__( 'Enables to show paginations to next new page.', 'findgo' ),
					'value' => array( esc_html__( 'Yes, to show pagination', 'findgo' ) => 'yes' )
				),
				array(
	                "type" => "dropdown",
	                "heading" => esc_html__('Grid Columns','findgo'),
	                "param_name" => 'grid_columns',
	                "value" => $columns
	            ),
				array(
					"type" => "dropdown",
					"heading" => esc_html__("Layout Type", 'findgo'),
					"param_name" => "layout_type",
					"value" => $layouts
				),
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Items', 'findgo' ),
					'param_name' => 'item',
					'value' 	=> array(
						esc_html__('Grid 1', 'findgo') => '', 
						esc_html__('Grid 2', 'findgo') => 'grid-carousel2', 
						esc_html__('Grid 3', 'findgo') => 'grid-item-v3', 
					),
					'dependency' => array(
						'element' => 'layout_type',
						'value' => array('carousel'),
					),
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Thumbnail size', 'findgo' ),
					'param_name' => 'thumbsize',
					'description' => esc_html__( 'Enter thumbnail size. Example: thumbnail, medium, large, full or other sizes defined by current theme. Alternatively enter image size in pixels: 200x100 (Width x Height) . ', 'findgo' )
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Extra class name', 'findgo' ),
					'param_name' => 'el_class',
					'description' => esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'findgo' )
				)
			)
		) );
	}
}
add_action( 'vc_after_set_mode', 'findgo_load_post_element', 99 );

class WPBakeryShortCode_apus_gridposts extends WPBakeryShortCode_VC_Posts_Grid {}