<?php

// Shop Archive settings
function findgo_woo_redux_config($sections, $sidebars, $columns) {
    
    // Woocommerce
    $sections[] = array(
        'icon' => 'el el-shopping-cart',
        'title' => esc_html__('Woocommerce', 'findgo'),
        'fields' => array(
            array(
                'id' => 'show_product_breadcrumbs',
                'type' => 'switch',
                'title' => esc_html__('Breadcrumbs', 'findgo'),
                'default' => 1
            ),
            array (
                'title' => esc_html__('Breadcrumbs Background Color', 'findgo'),
                'subtitle' => '<em>'.esc_html__('The breadcrumbs background color of the site.', 'findgo').'</em>',
                'id' => 'woo_breadcrumb_color',
                'type' => 'color',
                'transparent' => false,
            ),
            array(
                'id' => 'woo_breadcrumb_image',
                'type' => 'media',
                'title' => esc_html__('Breadcrumbs Background', 'findgo'),
                'subtitle' => esc_html__('Upload a .jpg or .png image that will be your breadcrumbs.', 'findgo'),
            ),
        )
    );
    // Archive settings
    $sections[] = array(
        'subsection' => true,
        'title' => esc_html__('Product Archives', 'findgo'),
        'fields' => array(
            array(
                'id' => 'product_archive_layout',
                'type' => 'image_select',
                'compiler' => true,
                'title' => esc_html__('Archive Product Layout', 'findgo'),
                'subtitle' => esc_html__('Select the layout you want to apply on your archive product page.', 'findgo'),
                'options' => array(
                    'main' => array(
                        'title' => esc_html__('Main Content', 'findgo'),
                        'alt' => esc_html__('Main Content', 'findgo'),
                        'img' => get_template_directory_uri() . '/inc/assets/images/screen1.png'
                    ),
                    'left-main' => array(
                        'title' => esc_html__('Left Sidebar - Main Content', 'findgo'),
                        'alt' => esc_html__('Left Sidebar - Main Content', 'findgo'),
                        'img' => get_template_directory_uri() . '/inc/assets/images/screen2.png'
                    ),
                    'main-right' => array(
                        'title' => esc_html__('Main Content - Right Sidebar', 'findgo'),
                        'alt' => esc_html__('Main Content - Right Sidebar', 'findgo'),
                        'img' => get_template_directory_uri() . '/inc/assets/images/screen3.png'
                    ),
                ),
                'default' => 'left-main'
            ),
            array(
                'id' => 'product_archive_fullwidth',
                'type' => 'switch',
                'title' => esc_html__('Is Full Width?', 'findgo'),
                'default' => false
            ),
            array(
                'id' => 'product_archive_filter_sidebar',
                'type' => 'select',
                'title' => esc_html__('Filter Sidebar', 'findgo'),
                'subtitle' => esc_html__('Show filter sidebar when shop only show Main Content.', 'findgo'),
                'options' => array(
                    'none' => esc_html__('Do not show', 'findgo'),
                    'right' => esc_html__('Right', 'findgo'),
                    'top' => esc_html__('Categories + Sidebar in Top', 'findgo'),
                ),
                'required' => array('product_archive_layout', '=', 'main'),
                'default' => 'none'
            ),
            array(
                'id' => 'product_archive_left_sidebar',
                'type' => 'select',
                'title' => esc_html__('Archive Left Sidebar', 'findgo'),
                'subtitle' => esc_html__('Choose a sidebar for left sidebar.', 'findgo'),
                'options' => $sidebars
            ),
            array(
                'id' => 'product_archive_right_sidebar',
                'type' => 'select',
                'title' => esc_html__('Archive Right Sidebar', 'findgo'),
                'subtitle' => esc_html__('Choose a sidebar for right sidebar.', 'findgo'),
                'options' => $sidebars
            ),
            array(
                'id' => 'product_display_mode',
                'type' => 'select',
                'title' => esc_html__('Display Mode', 'findgo'),
                'subtitle' => esc_html__('Choose a default layout archive product.', 'findgo'),
                'options' => array('grid' => esc_html__('Grid', 'findgo'), 'list' => esc_html__('List', 'findgo')),
                'default' => 'grid'
            ),
            array(
                'id' => 'number_products_per_page',
                'type' => 'text',
                'title' => esc_html__('Number of Products Per Page', 'findgo'),
                'default' => 12,
                'min' => '1',
                'step' => '1',
                'max' => '100',
                'type' => 'slider'
            ),
            array(
                'id' => 'product_columns',
                'type' => 'select',
                'title' => esc_html__('Product Columns', 'findgo'),
                'options' => $columns,
                'default' => 4
            ),
            array(
                'id' => 'show_quickview',
                'type' => 'switch',
                'title' => esc_html__('Show Quick View', 'findgo'),
                'default' => 1
            ),
            array(
                'id' => 'show_swap_image',
                'type' => 'switch',
                'title' => esc_html__('Show Second Image (Hover)', 'findgo'),
                'default' => 1
            ),
        )
    );
    // Product Page
    $sections[] = array(
        'subsection' => true,
        'title' => esc_html__('Single Product', 'findgo'),
        'fields' => array(
            array(
                'id' => 'product_single_layout',
                'type' => 'image_select',
                'compiler' => true,
                'title' => esc_html__('Single Product Layout', 'findgo'),
                'subtitle' => esc_html__('Select the layout you want to apply on your Single Product Page.', 'findgo'),
                'options' => array(
                    'main' => array(
                        'title' => esc_html__('Main Only', 'findgo'),
                        'alt' => esc_html__('Main Only', 'findgo'),
                        'img' => get_template_directory_uri() . '/inc/assets/images/screen1.png'
                    ),
                    'left-main' => array(
                        'title' => esc_html__('Left - Main Sidebar', 'findgo'),
                        'alt' => esc_html__('Left - Main Sidebar', 'findgo'),
                        'img' => get_template_directory_uri() . '/inc/assets/images/screen2.png'
                    ),
                    'main-right' => array(
                        'title' => esc_html__('Main - Right Sidebar', 'findgo'),
                        'alt' => esc_html__('Main - Right Sidebar', 'findgo'),
                        'img' => get_template_directory_uri() . '/inc/assets/images/screen3.png'
                    ),
                ),
                'default' => 'left-main'
            ),
            array(
                'id' => 'product_single_fullwidth',
                'type' => 'switch',
                'title' => esc_html__('Is Full Width?', 'findgo'),
                'default' => false
            ),
            array(
                'id' => 'product_single_left_sidebar',
                'type' => 'select',
                'title' => esc_html__('Single Product Left Sidebar', 'findgo'),
                'subtitle' => esc_html__('Choose a sidebar for left sidebar.', 'findgo'),
                'options' => $sidebars
            ),
            array(
                'id' => 'product_single_right_sidebar',
                'type' => 'select',
                'title' => esc_html__('Single Product Right Sidebar', 'findgo'),
                'subtitle' => esc_html__('Choose a sidebar for right sidebar.', 'findgo'),
                'options' => $sidebars
            ),
            array(
                'id' => 'show_product_social_share',
                'type' => 'switch',
                'title' => esc_html__('Show Social Share', 'findgo'),
                'default' => 1
            ),
            array(
                'id' => 'show_product_review_tab',
                'type' => 'switch',
                'title' => esc_html__('Show Product Review Tab', 'findgo'),
                'default' => 1
            ),
            array(
                'id' => 'show_product_releated',
                'type' => 'switch',
                'title' => esc_html__('Show Products Releated', 'findgo'),
                'default' => 1
            ),
            array(
                'id' => 'show_product_upsells',
                'type' => 'switch',
                'title' => esc_html__('Show Products upsells', 'findgo'),
                'default' => 1
            ),
            array(
                'id' => 'number_product_releated',
                'title' => esc_html__('Number of related/upsells products to show', 'findgo'),
                'default' => 4,
                'min' => '1',
                'step' => '1',
                'max' => '20',
                'type' => 'slider'
            ),
            array(
                'id' => 'releated_product_columns',
                'type' => 'select',
                'title' => esc_html__('Releated Products Columns', 'findgo'),
                'options' => $columns,
                'default' => 4
            ),

        )
    );
    
    return $sections;
}
add_filter( 'findgo_redux_framwork_configs', 'findgo_woo_redux_config', 10, 3 );