<?php

function findgo_wrap_the_listings( $html ) {
	$output = '';

	$layout_version = findgo_get_listing_archive_version();
	ob_start();
		set_query_var( 'html_content', $html );
		get_template_part( 'job_manager/loop-layout/'.$layout_version );
		$output = ob_get_contents();
	ob_end_clean();

	return $output;
}

add_filter( 'job_manager_job_listings_output', 'findgo_wrap_the_listings', 10, 1 );


remove_action( 'single_job_listing_start', 'job_listing_company_display', 30 );



function findgo_listing_template( $template ) {
	global $wp_query;
	$post_type = get_query_var( 'post_type' );
	if ( $wp_query->is_search && $post_type == 'job_listing' ) {
		return get_template_directory() . '/search-job_listing.php';  //  redirect to archive-search.php
	} elseif (isset($wp_query->post)) {
		if ( $wp_query->post->ID == get_option('job_manager_submit_job_form_page_id') ) {
			return get_template_directory() . '/page-submit-job_listing.php';
		}
	}

	return $template;
}

add_filter( 'template_include', 'findgo_listing_template' );

function findgo_get_job_listings_query_args($query_args, $args) {
	global $wpdb, $wp_query;

	if (isset($_REQUEST['form_data']) || isset($_REQUEST['$form_data'])) {
		if ( isset($_REQUEST['form_data']) ) {
			$form_data = urldecode($_REQUEST['form_data']);
		} else {
			$form_data = urldecode($_REQUEST['$form_data']);
		}
		parse_str($form_data, $datas);

		// order by
		if ( isset( $datas['filter_order'] ) ) {
			if ( 'default' === $datas['filter_order'] ) { // Default show featured.
				$query_args['orderby'] = array(
					'menu_order' => 'ASC',
					'date'       => 'DESC',
				);
				$query_args['order'] = 'DESC';
			} else {
				$query_args['findgo_proximity_filter'] = false;
				$query_args = findgo_sort_listings_query( $query_args, $datas['filter_order'] );
			}
		}

		$tax_querys = array();
		if (isset($datas['job_region_select']) && $datas['job_region_select']) {
			$tax_querys[] = array(
				'taxonomy'         => 'job_listing_region',
				'field'            => 'term_id',
				'terms'            => $datas['job_region_select'],
				'operator'         => 'IN'
			);
		}
		if (isset($datas['filter_job_amenity']) && $datas['filter_job_amenity']) {
			$tax_querys[] = array(
				'taxonomy'         => 'job_listing_amenity',
				'field'            => 'slug',
				'terms'            => $datas['filter_job_amenity'],
				'operator'         => 'IN'
			);
		}
		if (isset($datas['filter_job_tag']) && $datas['filter_job_tag']) {
			$tax_querys[] = array(
				'taxonomy'         => 'job_listing_tag',
				'field'            => 'slug',
				'terms'            => $datas['filter_job_tag'],
				'operator'         => 'IN'
			);
		}
		if (!empty($tax_querys)) {
			if ( isset($query_args['tax_query']) ) {
				$query_args['tax_query'] = array_merge($query_args['tax_query'], $tax_querys);
			} else {
				$query_args['tax_query'] = $tax_querys;
			}
		}
		
		if (isset($datas['filter_price_range']) && $datas['filter_price_range']) {
			$meta_query = array(
		       	array(
		           'key' => '_company_price_range',
		           'value' => $datas['filter_price_range'],
		           'compare' => 'IN',
		       	)
		   	);
			if ( isset($query_args['meta_query']) ) {
				$query_args['meta_query'] = array_merge($query_args['meta_query'], $meta_query);
			} else {
				$query_args['meta_query'] = $meta_query;
			}
		}

		// location
		$use_distance = isset( $datas[ 'use_search_distance' ] ) && 'on' == $datas[ 'use_search_distance' ];
		$lat = isset( $datas[ 'search_lat' ] ) ? (float) $datas[ 'search_lat' ] : false;
		$lng = isset( $datas[ 'search_lng' ] ) ? (float) $datas[ 'search_lng' ] : false;
		$distance = isset( $datas[ 'search_distance' ] ) ? (int) $datas[ 'search_distance' ] : false;
		$location = isset( $datas[ 'search_location' ] ) ? esc_attr( $datas[ 'search_location' ] ) : false;

		if ( !( $use_distance && $lat && $lng && $distance ) || !$location ) {
			return $query_args;
		}

		$earth_distance = findgo_get_config('listing_filter_distance_type', 'km') == 'miles' ? 3959 : 6371;

		$sql = $wpdb->prepare( "
			SELECT $wpdb->posts.ID, 
				( %s * acos( 
					cos( radians(%s) ) * 
					cos( radians( latitude.meta_value ) ) * 
					cos( radians( longitude.meta_value ) - radians(%s) ) + 
					sin( radians(%s) ) * 
					sin( radians( latitude.meta_value ) ) 
				) ) 
				AS distance, latitude.meta_value AS latitude, longitude.meta_value AS longitude
				FROM $wpdb->posts
				INNER JOIN $wpdb->postmeta AS latitude ON $wpdb->posts.ID = latitude.post_id
				INNER JOIN $wpdb->postmeta AS longitude ON $wpdb->posts.ID = longitude.post_id
				WHERE 1=1 AND ($wpdb->posts.post_status = 'publish' ) AND latitude.meta_key='geolocation_lat' AND longitude.meta_key='geolocation_long'
				HAVING distance < %s
				ORDER BY $wpdb->posts.menu_order ASC, distance ASC",
			$earth_distance,
			$lat,
			$lng,
			$lat,
			$distance
		);

		$post_ids = $wpdb->get_results( $sql, OBJECT_K );

		if ( empty( $post_ids ) || ! $post_ids ) {
            $post_ids = array(0);
		}

		if ( $wp_query ) {
			$wp_query->locations = $post_ids;
		}

		$query_args[ 'post__in' ] = array_keys( (array) $post_ids );
		$query_args = findgo_remove_location_meta_query( $query_args );
	}
	
	return $query_args;
}
add_filter( 'get_job_listings_query_args', 'findgo_get_job_listings_query_args', 10, 2 );

function findgo_sort_listings_query( $query_args, $sort_option ) {
	if ( 'date-desc' === $sort_option ) { // Newest First (default).
		$query_args['orderby'] = 'date';
		$query_args['order'] = 'DESC';
	} elseif ( 'date-asc' === $sort_option ) { // Oldest First.
		$query_args['orderby'] = 'date';
		$query_args['order'] = 'ASC';
	} elseif ( 'rating-desc' === $sort_option ) { // Highest Rating.
		$query_args['meta_key'] = '_average_rating';
		$query_args['orderby'] = 'meta_value_num';
		$query_args['order'] = 'DESC';
	} elseif ( 'rating-asc' === $sort_option ) { // Lowest Rating.
		$query_args['meta_key'] = '_average_rating';
		$query_args['orderby'] = 'meta_value_num';
		$query_args['order'] = 'ASC';
	} elseif ( 'random' === $sort_option ) { // Random.
		$query_args['orderby'] = 'rand';
	}

	return $query_args;
}

function findgo_job_listings_cache_results( $return ) {
	if (isset($_REQUEST['form_data'])) {
		$form_data = urldecode($_REQUEST['form_data']);
		parse_str($form_data, $datas);

		// order by
		if ( isset( $datas['filter_order'] ) ) {
			if ( 'random' === $datas['filter_order'] ) { // Default show featured.
				return false;
			}
		}
	}
	return $return;
}
add_filter('get_job_listings_cache_results', 'findgo_job_listings_cache_results', 100);

function findgo_remove_location_meta_query( $query_args ) {
	$found = false;
	if ( ! isset( $query_args[ 'meta_query' ] ) ) {
		return $query_args;
	}
	foreach ( $query_args[ 'meta_query' ] as $query_key => $meta ) {

		foreach ( $meta as $key => $args ) {
			if ( ! is_int( $key ) ) {
				continue;
			}

			if ( 'geolocation_formatted_address' == $args[ 'key' ] ) {
				$found = true;
				unset( $query_args[ 'meta_query' ][ $query_key ] );
				break;
			}

			foreach ( $args as $k => $args_ ) {
				if ( ! is_int( $k ) ) {
					continue;
				}
				
				if ( 'geolocation_formatted_address' == $args_[ 'key' ] ) {
					$found = true;
					unset( $query_args[ 'meta_query' ][ $query_key ] );
					break;
				}
			}

			if ( $found ) {
				break;
			}

		}

		if ( $found ) {
			break;
		}
	}

	return $query_args;
}

function findgo_job_manager_get_listings_args( $args ) {
	if ( ! isset( $_REQUEST[ 'form_data' ] ) ) {
		return $args;
	}
	parse_str( $_REQUEST[ 'form_data' ], $params );
	$use_distance = isset( $params[ 'use_search_distance' ] ) && 'on' == $params[ 'use_search_distance' ];
	$lat = isset( $params[ 'search_lat' ] ) && 0 != $params[ 'search_lat' ];

	if ( !( $use_distance && $lat ) || '' == $params[ 'search_location' ] ) {
		return $args;
	}

	$args[ 'orderby' ] = 'distance';
	$args[ 'order' ] = 'asc';

	return $args;
}
add_filter( 'job_manager_get_listings_args', 'findgo_job_manager_get_listings_args' );

function findgo_submit_form_preview() {
	global $post, $job_preview;

	$instance = WP_Job_Manager_Form_Submit_Job::instance();
	if ( $instance->get_job_id() ) {
		$job_preview = true;
		$action      = $instance->get_action();
		$post        = get_post( $instance->get_job_id() );
		setup_postdata( $post );
		$post->post_status = 'preview';
		
		?>
		<form method="post" id="job_preview" action="<?php echo esc_url( $action ); ?>">
			<?php
			/**
			 * Fires at the top of the preview job form.
			 *
			 * @since 1.32.2
			 */
			do_action( 'preview_job_form_start' );
			?>
			<div class="job_listing_preview_title">
				<input type="submit" name="continue" id="job_preview_submit_button" class="button job-manager-button-submit-listing btn btn-theme-second radius-3x" value="<?php echo apply_filters( 'submit_job_step_preview_submit_text', esc_html__( 'Submit Listing', 'findgo' ) ); ?>"/>
				<input type="submit" name="edit_job" class="button job-manager-button-edit-listing btn btn-theme radius-3x" value="<?php esc_html_e( 'Edit listing', 'findgo' ); ?>"/>
				<input type="hidden" name="job_id" value="<?php echo esc_attr( $instance->get_job_id() ); ?>"/>
				<input type="hidden" name="step" value="<?php echo esc_attr( $instance->get_step() ); ?>"/>
				<input type="hidden" name="job_manager_form" value="<?php echo esc_attr($instance->form_name); ?>"/>
				
				<h2>
					<?php esc_html_e( 'Preview', 'findgo' ); ?>
				</h2>
			</div>
			<?php
			/**
			 * Fires at the bottom of the preview job form.
			 *
			 * @since 1.32.2
			 */
			do_action( 'preview_job_form_end' );
			?>
		</form>
		<?php
			global $findgo_preview;
			$findgo_preview = 'preview';
			$version = findgo_get_listing_single_version();
			get_template_part( 'job_manager/single/layouts/'.$version );
		
		wp_reset_postdata();
	}
}

/**
 * Change the preview step view handler of the WP Job Manager Submit Form
 *
 * @param $settings
 *
 * @return mixed
 */
function findgo_change_submit_preview_function( $settings ) {
	$settings['preview']['view'] = 'findgo_submit_form_preview';
	return $settings;
}
add_filter( 'submit_job_steps', 'findgo_change_submit_preview_function', 10, 1 );

function findgo_get_listings_custom_filter_text($text) {
	$after_text = array();
	if (isset($_REQUEST['form_data'])) {
		$form_data = urldecode($_REQUEST['form_data']);
		parse_str($form_data, $datas);

		if (isset($datas['search_categories']) && $datas['search_categories']) {
			$categories = array();
			foreach ($datas['search_categories'] as $job_category) {
				$term = get_term_by( 'id', $job_category, 'job_listing_category' );
				if (!empty($term)) {
					$categories[] = '<span class="highlight">'.$term->name.'</span>';
				}
			}
			if ( !empty($categories) ) {
				$after_text[] = sprintf( _n('<span class="text-strong">Category</span>: %s', '<span class="text-strong">Categories</span>: %s', count($categories), 'findgo'), implode(', ', $categories) );
			}
		}
		if (isset($datas['job_region_select']) && $datas['job_region_select']) {
			$term = get_term_by( 'id', $datas['job_region_select'], 'job_listing_region' );
			if (!empty($term)) {
				$after_text[] = sprintf(__( '<span class="text-strong">Region</span>: %s', 'findgo' ), '<span class="highlight">'.$term->name.'</span>' );
			}
		}
		if (isset($datas['filter_job_amenity']) && $datas['filter_job_amenity']) {
			$amenities = array();
			foreach ($datas['filter_job_amenity'] as $job_amenity) {
				$term = get_term_by( 'slug', $job_amenity, 'job_listing_amenity' );
				if (!empty($term)) {
					$amenities[] = '<span class="highlight">'.$term->name.'</span>';
				}
			}
			$after_text[] = sprintf( _n('<span class="text-strong">Tag</span>: %s', '<span class="text-strong">Tags</span>: %s', count($amenities), 'findgo'), implode(', ', $amenities) );
		}

		$use_distance = isset( $datas[ 'use_search_distance' ] ) && 'on' == $datas[ 'use_search_distance' ];
		$lat = isset( $datas[ 'search_lat' ] ) ? (float) $datas[ 'search_lat' ] : false;
		$lng = isset( $datas[ 'search_lng' ] ) ? (float) $datas[ 'search_lng' ] : false;
		$distance = isset( $datas[ 'search_distance' ] ) ? (int) $datas[ 'search_distance' ] : false;
		$location = isset( $datas[ 'search_location' ] ) ? esc_attr( $datas[ 'search_location' ] ) : false;

		if ( $use_distance && $lat && $lng && $distance && $location ) {
			$after_text[] = sprintf( __('<span class="text-strong">Location</span>: <span class="highlight">%s</span>', 'findgo'), $location );
		}

		if (isset($datas['filter_price_range']) && $datas['filter_price_range']) {
			$prices_default = findgo_job_manager_price_range_icons();
			$prices = array();
			foreach ($datas['filter_price_range'] as $value) {
				if ( !empty($prices_default[$value]) ) {
					$prices[] = '<span class="highlight">'.$prices_default[$value]['label'].'</span>';
				}
			}
			$after_text[] = sprintf( __('<span class="text-strong">Price Range</span>: %s', 'findgo'), implode(', ', $prices) );

		}
	}
	if ( !empty($after_text) ) {
		return esc_html__('Showing results for ', 'findgo').' '.implode('; ', $after_text);
	} else {
		return '';
	}
}
add_filter( 'job_manager_get_listings_custom_filter_text', 'findgo_get_listings_custom_filter_text' );

function findgo_listings_custom_filter() {
	if (isset($_REQUEST['form_data'])) {
		$form_data = urldecode($_REQUEST['form_data']);
		parse_str($form_data, $datas);

		if (isset($datas['job_region_select']) && $datas['job_region_select']) {
			return true;
		}
		if (isset($datas['filter_job_amenity']) && $datas['filter_job_amenity']) {
			return true;
		}
		if (isset($datas['filter_job_tag']) && $datas['filter_job_tag']) {
			return true;
		}
		if (isset($datas['filter_price_range']) && $datas['filter_price_range']) {
			return true;
		}
	}
}
add_filter( 'job_manager_get_listings_custom_filter', 'findgo_listings_custom_filter' );

function findgo_listings_remove_rss_link($links) {
	if ( isset($links['rss_link']) ) {
		unset($links['rss_link']);
	}
	return $links;
}
add_filter( 'job_manager_job_filters_showing_jobs_links', 'findgo_listings_remove_rss_link' );


function findgo_listings_json_results( $result, $jobs ) {

	$result[ 'page' ]   = isset( $jobs->query_vars[ 'paged' ] ) ? $jobs->query_vars[ 'paged' ] : 1;
	$result[ 'offset' ] = intval($jobs->query_vars[ 'offset' ]) + 1;
	$result[ 'found' ] = $jobs->found_posts == 0 ? 0 : $jobs->found_posts;

	$total_found = $jobs->query_vars[ 'offset' ] + $jobs->post_count;
	if ( findgo_get_config('listing_show_loadmore') ) {
		$result[ 'str_found' ] = esc_html__(' (Showing ', 'findgo'). ($total_found > 0 ? ' 1' : ' 0') . ' - ' . $total_found . ')';
	} else {
		$result[ 'str_found' ] = esc_html__(' (Showing ', 'findgo'). ($total_found > 0 ? intval($jobs->query_vars[ 'offset' ]) + 1 : ' 0') . ' - '. $total_found .')';
	}

	return $result;
}
add_filter( 'job_manager_get_listings_result', 'findgo_listings_json_results', 10, 2 );


function findgo_map_pin_icon() {
	get_template_part( 'images/icon/pin' );
	get_template_part( 'images/icon/pin-default' );
}
add_action('wp_footer', 'findgo_map_pin_icon');


function findgo_job_manager_output_jobs_defaults($args) {
	$args['regions'] = '';
	return $args;
}
add_filter('job_manager_output_jobs_defaults', 'findgo_job_manager_output_jobs_defaults');


function findgo_job_manager_price_range_icons() {
	return apply_filters( 'findgo_job_manager_price_range_icons', array(
		'inexpensive' => array(
						'icon' => esc_html__('$', 'findgo'),
						'label' => esc_html__('Inexpensive', 'findgo')
					),
		'moderate' => array(
						'icon' => esc_html__('$$', 'findgo'),
						'label' => esc_html__('Moderate', 'findgo')
					),
		'pricey' => array(
						'icon' => esc_html__('$$$', 'findgo'),
						'label' => esc_html__('Pricey', 'findgo')
					),
		'ultra_high_end' =>array(
						'icon' => esc_html__('$$$$', 'findgo'),
						'label' => esc_html__('Ultra High', 'findgo')
					),
	));
}

function findgo_job_manager_price_range_label($labels) {
	$labels = findgo_job_manager_price_range_icons();
	$return = array( 'notsay' => esc_html__('Prefer not to say', 'findgo') );
	foreach ($labels as $key => $label) {
		$return[$key] = $label['icon'] .' - '.$label['label'];
	}
	return $return;
}
add_filter( 'apus_findgo_price_ranges', 'findgo_job_manager_price_range_label' );

function findgo_job_manager_display_price_range($post_id) {
	$price_range = get_post_meta($post_id, '_company_price_range', true);
	$price_range_labels = findgo_job_manager_price_range_icons();
	if ( $price_range && isset($price_range_labels[$price_range])) {
		$labels = $price_range_labels[$price_range];
		?>
		<div class="listing-price-range" data-placement="top" data-toggle="tooltip" title="<?php echo esc_attr($labels['label']); ?>">
			<?php echo esc_attr($labels['icon']); ?>
		</div>
		<?php
	}
}