<?php

// Shop Archive settings
function findgo_wp_job_manager_redux_config($sections, $sidebars, $columns) {
    
    $pages = array();
    if (is_admin()) {
        $args = array(
            'posts_per_page'   => -1,
            'offset'           => 0,
            'orderby'          => 'date',
            'order'            => 'DESC',
            'post_type'        => 'page',
            'post_status'      => 'publish',
            'suppress_filters' => true 
        );
        $posts = get_posts( $args );
        foreach ( $posts as $post ) {
            $pages[$post->post_name] = $post->post_title;
        }
    }
    // Archive Listings settings
    $sections[] = array(
        'title' => esc_html__('Listing Archives', 'findgo'),
        'fields' => array(
            array(
                'id' => 'listing_archive_layout_version',
                'type' => 'image_select',
                'compiler' => true,
                'title' => esc_html__('Layout Style', 'findgo'),
                'options' => array(
                    'half-map-v1' => array(
                        'title' => esc_html__('Half Map - Layout 1', 'findgo'),
                        'img' => get_template_directory_uri() . '/images/archive-layouts/half_map_v1.jpg'
                    ),
                    'half-map-v2' => array(
                        'title' => esc_html__('Half Map - Layout 2', 'findgo'),
                        'img' => get_template_directory_uri() . '/images/archive-layouts/half_map_v2.jpg'
                    ),
                    'half-map-v3' => array(
                        'title' => esc_html__('Half Map - Layout 3', 'findgo'),
                        'img' => get_template_directory_uri() . '/images/archive-layouts/half_map_v3.jpg'
                    ),
                    'half-map-v4' => array(
                        'title' => esc_html__('Half Map - Layout 4', 'findgo'),
                        'img' => get_template_directory_uri() . '/images/archive-layouts/half_map_v4.jpg'
                    ),
                    'default' => array(
                        'title' => esc_html__('Fullwidth - Sidebar', 'findgo'),
                        'img' => get_template_directory_uri() . '/images/archive-layouts/sidebar.jpg'
                    ),
                ),
                'default' => 'half-map-v1',
            ),

            array(
                'id' => 'listing_archive_display_mode',
                'type' => 'select',
                'title' => esc_html__('Default Display Mode', 'findgo'),
                'options' => array(
                    'grid' => esc_html__('Grid', 'findgo'),
                    'list' => esc_html__('List', 'findgo'),
                ),
                'default' => 'grid',
            ),
            array(
                'id' => 'listing_columns',
                'type' => 'select',
                'title' => esc_html__('Grid Listing Columns', 'findgo'),
                'options' => $columns,
                'default' => 2,
                'required' => array('listing_archive_display_mode', '=', 'grid'),
            ),
            array(
                'id' => 'listing_show_loadmore',
                'type' => 'switch',
                'title' => esc_html__('Show Load More Button ?', 'findgo'),
                'default' => 1,
            ),
            array(
                'id' => 'listing_show_cat_title',
                'type' => 'switch',
                'title' => esc_html__('Show Category Title ?', 'findgo'),
                'default' => 0,
            ),
            array(
                'id' => 'listing_show_cat_description',
                'type' => 'switch',
                'title' => esc_html__('Show Category Description ?', 'findgo'),
                'default' => 0,
            ),
            array (
                'id' => 'archive_breadcrumbs_settings',
                'icon' => true,
                'type' => 'info',
                'raw' => '<h3> '.esc_html__('Breadcrumbs Settings', 'findgo').'</h3>',
                'required' => array('listing_archive_layout_version', '=', array('default' )),
            ),
            array(
                'id' => 'show_listing_breadcrumbs',
                'type' => 'switch',
                'title' => esc_html__('Breadcrumbs', 'findgo'),
                'default' => 1,
                'description' => esc_html__('Breadcrumb is only apply for Listing Archives version (List, Grid)', 'findgo'),
                'required' => array('listing_archive_layout_version', '=', array('default' )),
            ),
            array (
                'title' => esc_html__('Breadcrumbs Background Color', 'findgo'),
                'subtitle' => '<em>'.esc_html__('The breadcrumbs background color of the site.', 'findgo').'</em>',
                'id' => 'listing_breadcrumb_color',
                'type' => 'color',
                'transparent' => false,
                'required' => array('listing_archive_layout_version', '=', array('default' )),
            ),
            array(
                'id' => 'listing_breadcrumb_image',
                'type' => 'media',
                'title' => esc_html__('Breadcrumbs Background', 'findgo'),
                'subtitle' => esc_html__('Upload a .jpg or .png image that will be your breadcrumbs.', 'findgo'),
                'required' => array('listing_archive_layout_version', '=', array('default' )),
            ),
            
            array (
                'id' => 'sidebar_position',
                'icon' => true,
                'type' => 'info',
                'raw' => '<h3> '.esc_html__('Sidebar Position', 'findgo').'</h3>',
                'required' => array('listing_archive_layout_version', '=', array('default')),
            ),
            array(
                'id' => 'listing_archive_layout',
                'type' => 'image_select',
                'compiler' => true,
                'title' => esc_html__('Sidebar Layout', 'findgo'),
                'subtitle' => esc_html__('Select a sidebar layout', 'findgo'),
                'options' => array(
                    'main' => array(
                        'title' => esc_html__('Main Content', 'findgo'),
                        'alt' => esc_html__('Main Content', 'findgo'),
                        'img' => get_template_directory_uri() . '/inc/assets/images/screen1.png'
                    ),
                    'left-main' => array(
                        'title' => esc_html__('Left - Main Sidebar', 'findgo'),
                        'alt' => esc_html__('Left - Main Sidebar', 'findgo'),
                        'img' => get_template_directory_uri() . '/inc/assets/images/screen2.png'
                    ),
                    'main-right' => array(
                        'title' => esc_html__('Main - Right Sidebar', 'findgo'),
                        'alt' => esc_html__('Main - Right Sidebar', 'findgo'),
                        'img' => get_template_directory_uri() . '/inc/assets/images/screen3.png'
                    ),
                ),
                'default' => 'left-main',
                'required' => array('listing_archive_layout_version', '=', array('default')),
            ),
            array(
                'id' => 'listing_archive_sidebar',
                'type' => 'select',
                'title' => esc_html__('Listings Sidebar', 'findgo'),
                'subtitle' => esc_html__('Choose a sidebar for listings sidebar.', 'findgo'),
                'options' => $sidebars,
                'default' => 'listing-archive-sidebar',
                'required' => array('listing_archive_layout_version', '=', array('default')),
            ),
        )
    );
    $sections[] = array(
        'subsection' => true,
        'title' => esc_html__('Filter Settings', 'findgo'),
        'fields' => array(
            array(
                'id' => 'listing_filter_type',
                'type' => 'select',
                'title' => esc_html__('Filter Type', 'findgo'),
                'options' => array(
                    'location' => esc_html__('Filter By Location', 'findgo'),
                    'region' => esc_html__('Filter By Region', 'findgo'),
                )
            ),
            array(
                'id' => 'listing_filter_show_keyword',
                'type' => 'switch',
                'title' => esc_html__('Show keyword field', 'findgo'),
                'default' => 1,
            ),
            array(
                'id' => 'listing_filter_show_price',
                'type' => 'switch',
                'title' => esc_html__('Show price field', 'findgo'),
                'default' => 1,
            ),
            array(
                'id' => 'listing_filter_show_sortby',
                'type' => 'switch',
                'title' => esc_html__('Show Sort By', 'findgo'),
                'default' => 1,
            ),
            array(
                'id' => 'listing_filter_sortby_default',
                'type' => 'select',
                'title' => esc_html__('Default Sortby', 'findgo'),
                'options' => array(
                    'default' => esc_html__( 'Default Order', 'findgo' ),
                    'date-desc' => esc_html__( 'Newest First', 'findgo' ),
                    'date-asc' => esc_html__( 'Oldest First', 'findgo' ),
                    'rating-desc' => esc_html__( 'Highest Rating', 'findgo' ),
                    'rating-asc' => esc_html__( 'Lowest Rating', 'findgo' ),
                    'random' => esc_html__( 'Random', 'findgo' ),
                ),
                'default' => 'default'
            ),
            array(
                'id' => 'listing_filter_show_categories',
                'type' => 'switch',
                'title' => esc_html__('Show categories field', 'findgo'),
                'default' => 1,
            ),
            array(
                'id' => 'listing_filter_show_regions',
                'type' => 'switch',
                'title' => esc_html__('Show regions field', 'findgo'),
                'default' => 1,
                'required' => array('listing_filter_type', '=', array('region')),
            ),
            array(
                'id' => 'listing_filter_show_location',
                'type' => 'switch',
                'title' => esc_html__('Show location field', 'findgo'),
                'default' => 1,
                'required' => array('listing_filter_type', '=', array('location')),
            ),
            array(
                'id' => 'listing_filter_show_distance',
                'type' => 'switch',
                'title' => esc_html__('Show distance field', 'findgo'),
                'default' => 1,
                'required' => array('listing_filter_type', '=', array('location')),
            ),
            array(
                'id' => 'listing_filter_distance_default',
                'type' => 'text',
                'title' => esc_html__('Distance default', 'findgo'),
                'default' => 50,
                'required' => array('listing_filter_type', '=', array('location')),
            ),
            array(
                'id' => 'listing_filter_distance_type',
                'type' => 'select',
                'title' => esc_html__('Show distance field', 'findgo'),
                'options' => array(
                    'km' => esc_html__('Kilometre', 'findgo'),
                    'miles' => esc_html__('Miles', 'findgo'),
                ),
                'default' => 'km',
                'required' => array('listing_filter_type', '=', array('location')),
            ),
            array(
                'id' => 'listing_filter_show_tags',
                'type' => 'select',
                'title' => esc_html__('Show tags fields', 'findgo'),
                'options' => array(
                    '' => esc_html__('Hidden', 'findgo'),
                    'show' => esc_html__('Show', 'findgo'),
                    'more-filter' => esc_html__('Show when click more filter button', 'findgo'),
                ),
                'default' => 'more-filter'
            ),
        )
    );
    // Single Listing settings

    $layout_options = array();
    $default_options = findgo_get_listing_layout_style();
    foreach ($default_options as $key => $value) {
        $layout_options[$key] = array(
            'title' => $value['title'],
            'alt' => $value['title'],
            'img' => $value['img'],
        );
    }
    $sections[] = array(
        'title' => esc_html__('Listing Detail', 'findgo'),
        'fields' => array(
            
            array(
                'id' => 'listing_single_layout_version',
                'type' => 'image_select',
                'compiler' => true,
                'title' => esc_html__('Layout Style', 'findgo'),
                'options' => $layout_options,
                'default' => 'v1',
            ),
            array(
                'id'        => 'listing_single_sort_content',
                'type'      => 'sorter',
                'title'     => esc_html__( 'Listing Content', 'findgo' ),
                'subtitle'  => esc_html__( 'Please drag and arrange the block', 'findgo' ),
                'options'   => array(
                    'enabled' => findgo_listing_single_sort_content(),
                    'disabled' => array()
                )
            ),
            array(
                'id'        => 'listing_single_sort_sidebar',
                'type'      => 'sorter',
                'title'     => esc_html__( 'Listing Sidebar', 'findgo' ),
                'subtitle'  => esc_html__( 'Please drag and arrange the block', 'findgo' ),
                'options'   => array(
                    'enabled' => findgo_listing_single_sort_sidebar(),
                    'disabled' => array()
                )
            ),
            array(
                'id' => 'show_listing_social_share',
                'type' => 'switch',
                'title' => esc_html__('Show Social Share', 'findgo'),
                'default' => 1
            ),
            array (
                'id' => 'single_breadcrumbs_settings',
                'icon' => true,
                'type' => 'info',
                'raw' => '<h3> '.esc_html__('Breadcrumbs Settings', 'findgo').'</h3>',
            ),
            array(
                'id' => 'show_single_listing_breadcrumbs',
                'type' => 'switch',
                'title' => esc_html__('Breadcrumbs', 'findgo'),
                'default' => 1
            ),
            array (
                'id' => 'single_sidebar_position',
                'icon' => true,
                'type' => 'info',
                'raw' => '<h3> '.esc_html__('Sidebar Position', 'findgo').'</h3>',
            ),
            array(
                'id' => 'listing_single_layout',
                'type' => 'image_select',
                'compiler' => true,
                'title' => esc_html__('Sidebar Layout', 'findgo'),
                'subtitle' => esc_html__('Select a sidebar layout', 'findgo'),
                'options' => array(
                    'left-main' => array(
                        'title' => esc_html__('Left - Main Sidebar', 'findgo'),
                        'alt' => esc_html__('Left - Main Sidebar', 'findgo'),
                        'img' => get_template_directory_uri() . '/inc/assets/images/screen2.png'
                    ),
                    'main-right' => array(
                        'title' => esc_html__('Main - Right Sidebar', 'findgo'),
                        'alt' => esc_html__('Main - Right Sidebar', 'findgo'),
                        'img' => get_template_directory_uri() . '/inc/assets/images/screen3.png'
                    ),
                ),
                'default' => 'left-main',
            ),
            array(
                'id' => 'listing_single_sidebar',
                'type' => 'select',
                'title' => esc_html__('Listings Sidebar', 'findgo'),
                'subtitle' => esc_html__('Choose a sidebar for listings sidebar.', 'findgo'),
                'options' => $sidebars,
            )

        )
    );
    // Listing Map Settings
    $sections[] = array(
        'subsection' => true,
        'title' => esc_html__('Listing Review Settings', 'findgo'),
        'fields' => array(
            array(
                'id' => 'listing_review_enable_upload_photos',
                'type' => 'switch',
                'title' => esc_html__('Enable upload photos', 'findgo'),
                'default' => 1
            ),
            array(
                'id' => 'listing_review_enable_like',
                'type' => 'switch',
                'title' => esc_html__('Enable like review', 'findgo'),
                'default' => 1
            ),
            array(
                'id' => 'listing_review_enable_dislike',
                'type' => 'switch',
                'title' => esc_html__('Enable dislike review', 'findgo'),
                'default' => 1,
            ),
            array(
                'id' => 'listing_review_enable_love',
                'type' => 'switch',
                'title' => esc_html__('Enable love review', 'findgo'),
                'default' => 1,
            ),

            array(
                'id' => 'listing_review_enable_reply',
                'type' => 'switch',
                'title' => esc_html__('Enable reply review', 'findgo'),
                'default' => 1
            ),
            
        )
    );

    $sections[] = array(
        'subsection' => false,
        'title' => esc_html__('Submit Listing Settings', 'findgo'),
        'fields' => array(
            array(
                'id' => 'submit_listing_enable_listing_style',
                'type' => 'switch',
                'title' => esc_html__('Enable Listing Style Field', 'findgo'),
                'default' => 1
            ),
            array(
                'id' => 'submit_listing_image',
                'type' => 'media',
                'title' => esc_html__('Submit Listing Image Description', 'findgo'),
                'subtitle' => esc_html__('Upload a .jpg or .png image that will be your breadcrumbs.', 'findgo'),
            ),
        )
    );

    // sections after listings
    $lsections = apply_filters( 'findgo_redux_config_sections_after_listing', array() );
    if ( !empty($lsections) ) {
        foreach ($lsections as $section) {
            $sections[] = $section;
        }
    }
    
    // Listing Map Settings
    $sections[] = array(
        'title' => esc_html__('Listing Map Settings', 'findgo'),
        'fields' => array(
            // google map style
            array(
                'id' => 'listing_map_style_type',
                'type' => 'select',
                'title' => esc_html__('Map Service Type', 'findgo'),
                'options' => array(
                    'default' => esc_html__('Google Maps', 'findgo'),
                    'mapbox' => esc_html__('MapBox', 'findgo')
                ),
                'default' => 'default'
            ),
            array(
                'id' => 'listing_map_custom_style',
                'type' => 'textarea',
                'title' => esc_html__('Custom Style', 'findgo'),
                'description' => wp_kses( __('<a href="//snazzymaps.com/">Get custom style</a> and paste it below. If there is nothing added, we will fallback to the Google Maps service.', 'findgo'), array('a' => array('href' => array()))),
                'required' => array('listing_map_style_type', '=', 'default'),
            ),
            array(
                'id' => 'listing_mapbox_token',
                'type' => 'text',
                'title' => esc_html__('Mapbox Token', 'findgo'),
                'description' => wp_kses( __('<a href="//www.mapbox.com/help/create-api-access-token/">Get a FREE token</a> and paste it below. If there is nothing added, we will fallback to the Google Maps service.', 'findgo'), array('a' => array('href' => array()))),
                'required' => array('listing_map_style_type', '=', 'mapbox'),
            ),
            array(
                'id' => 'listing_mapbox_style',
                'type' => 'image_select',
                'compiler' => true,
                'title' => esc_html__('MapBox Style', 'findgo'),
                'description' => esc_html__('Custom map styles works only if you have set a valid Mapbox API token in the field above.', 'findgo'),
                'options' => array(
                    'streets-v11' => array(
                        'alt' => esc_html__('streets', 'findgo'),
                        'img' => get_template_directory_uri() . '/inc/assets/images/streets.png'
                    ),
                    'light-v10' => array(
                        'alt' => esc_html__('light', 'findgo'),
                        'img' => get_template_directory_uri() . '/inc/assets/images/light.png'
                    ),
                    'dark-v10' => array(
                        'alt' => esc_html__('dark', 'findgo'),
                        'img' => get_template_directory_uri() . '/inc/assets/images/dark.png'
                    ),
                    'outdoors-v11' => array(
                        'alt' => esc_html__('outdoors', 'findgo'),
                        'img' => get_template_directory_uri() . '/inc/assets/images/outdoors.png'
                    ),
                    'satellite-v9' => array(
                        'alt' => esc_html__('satellite', 'findgo'),
                        'img' => get_template_directory_uri() . '/inc/assets/images/satellite.png'
                    ),
                ),
                'required' => array('listing_map_style_type', '=', 'mapbox'),
            ),
            array(
                'id' => 'listing_map_latitude',
                'type' => 'text',
                'title' => esc_html__('Default Latitude', 'findgo'),
                'default' => '54.800685'
            ),
            array(
                'id' => 'listing_map_longitude',
                'type' => 'text',
                'title' => esc_html__('Default Longitude', 'findgo'),
                'default' => '-4.130859'
            ),
        )
    );
    $sections[] = array(
        'title' => esc_html__('User Profile', 'findgo'),
        'fields' => array(
            array (
                'id' => 'profile_breadcrumb_setting',
                'icon' => true,
                'type' => 'info',
                'raw' => '<h3> '.esc_html__('Breadcrumbs Settings', 'findgo').'</h3>',
            ),
            array(
                'id' => 'show_profile_breadcrumbs',
                'type' => 'switch',
                'title' => esc_html__('Breadcrumbs', 'findgo'),
                'default' => 1
            ),
            array (
                'title' => esc_html__('Breadcrumbs Background Color', 'findgo'),
                'subtitle' => '<em>'.esc_html__('The breadcrumbs background color of the site.', 'findgo').'</em>',
                'id' => 'profile_breadcrumb_color',
                'type' => 'color',
                'transparent' => false,
            ),
            array(
                'id' => 'profile_breadcrumb_image',
                'type' => 'media',
                'title' => esc_html__('Breadcrumbs Background', 'findgo'),
                'subtitle' => esc_html__('Upload a .jpg or .png image that will be your breadcrumbs.', 'findgo'),
            ),
            array (
                'id' => 'profile_setting',
                'icon' => true,
                'type' => 'info',
                'raw' => '<h3> '.esc_html__('General Settings', 'findgo').'</h3>',
            ),
            array(
                'id' => 'user_profile_listing_number',
                'type' => 'text',
                'title' => esc_html__('Number of Listings Per Page', 'findgo'),
                'default' => 25,
                'min' => '1',
                'step' => '1',
                'max' => '100',
                'type' => 'slider'
            ),
            array(
                'id' => 'user_profile_bookmark_number',
                'type' => 'text',
                'title' => esc_html__('Number of Bookmarks Per Page', 'findgo'),
                'default' => 25,
                'min' => '1',
                'step' => '1',
                'max' => '100',
                'type' => 'slider'
            ),
            array(
                'id' => 'user_profile_reviews_number',
                'type' => 'text',
                'title' => esc_html__('Number of Reviews Per Page', 'findgo'),
                'default' => 25,
                'min' => '1',
                'step' => '1',
                'max' => '100',
                'type' => 'slider'
            ),
            array(
                'id' => 'user_profile_follow_number',
                'type' => 'text',
                'title' => esc_html__('Number of Following/Follower Per Page', 'findgo'),
                'default' => 25,
                'min' => '1',
                'step' => '1',
                'max' => '100',
                'type' => 'slider'
            ),
        )
    );
    // Email Template
    $email_template_fields = apply_filters( 'findgo_email_template_fields', array(
        array(
            'id' => 'comment_report_email',
            'icon' => true,
            'type' => 'info',
            'raw' => '<h3> '.esc_html__('Comment Report Email Templates', 'findgo').'</h3>',
        ),
        array(
            'id' => 'comment_report_email_subject',
            'type' => 'textarea',
            'title' => esc_html__('Email Subject', 'findgo'),
            'default' => 'Report Comment'
        ),
        array(
            'id' => 'comment_report_email_message',
            'type' => 'editor',
            'title' => esc_html__('Email Body', 'findgo'),
            'description' => esc_html__('Variables: ', 'findgo').'{comment_link}, {comment_msg}',
        )
    ));
    $sections[] = array(
        'title' => esc_html__('Email Templates', 'findgo'),
        'fields' => $email_template_fields
    );
    
    return $sections;
}
add_filter( 'findgo_redux_framwork_configs', 'findgo_wp_job_manager_redux_config', 10, 3 );