<?php

// comment template
function findgo_listing_comments_template_loader($template) {
    if ( get_post_type() !== 'job_listing' ) {
        return $template;
    }
    return get_template_directory() . '/job_manager/single/parts/reviews.php';
}
add_filter( 'comments_template', 'findgo_listing_comments_template_loader' );

// comment list
function findgo_listing_comments( $comment, $args, $depth ) {
    
    require get_template_directory().'/job_manager/single/parts/review.php';
}
function findgo_my_review( $comment, $args, $depth ) {
    $GLOBALS['comment'] = $comment;
    set_query_var( 'comment', $comment );
    set_query_var( 'args', $args );
    set_query_var( 'depth', $depth );
    get_template_part( 'job_manager/my-review' );
}
// add comment meta
function findgo_add_custom_comment_field( $comment_id, $comment_approved, $commentdata ) {
    $post_id = $commentdata['comment_post_ID'];
    $post = get_post($post_id);
    if ( $post->post_type == 'job_listing' ) {
        add_comment_meta( $comment_id, '_apus_rating', $_POST['rating'] );
    }
}
add_action( 'comment_post', 'findgo_add_custom_comment_field', 10, 3 );

function findgo_add_listing_avg() {
    $query_args = array(
        'post_type' => 'job_listing',
        'post_status' => 'publish',
        'posts_per_page' => -1,
        'ignore_sticky_posts' => true,
    );
    $loop = new WP_Query( $query_args );
    if ( $loop->posts ) {
        foreach ($loop->posts as $post) {
            $average_rating = findgo_get_total_rating( $post->ID );
            update_post_meta( $post->ID, '_average_rating', $average_rating );
        }
    }
}
//add_action( 'init', 'findgo_add_listing_avg' );

function findgo_add_custom_comment_average_rating($comment) {
    
    $post_id = $comment->comment_post_ID;
    $post = get_post($post_id);
    if ( $post->post_type == 'job_listing' ) {
        $average_rating = findgo_get_total_rating( $post_id );
        update_post_meta( $post_id, '_average_rating', $average_rating );
    }
}
add_action( 'comment_unapproved_to_approved', 'findgo_add_custom_comment_average_rating', 10 );
add_action( 'comment_approved_to_unapproved', 'findgo_add_custom_comment_average_rating', 10 );

function findgo_get_review_comments( $args = array() ) {
    $args = wp_parse_args( $args, array(
        'status' => 'approve',
        'post_id' => '',
        'user_id' => '',
        'post_type' => 'job_listing',
        'number' => 0
    ));
    $cargs = array(
        'status' => 'approve',
        'post_type' => 'job_listing',
        'number' => $args['number'],
        'meta_query' => array(
            array(
               'key' => '_apus_rating',
               'value' => 0,
               'compare' => '>',
            )
        )
    );
    if ( !empty($args['post_id']) ) {
        $cargs['post_id'] = $args['post_id'];
    }
    if ( !empty($args['user_id']) ) {
        $cargs['user_id'] = $args['user_id'];
    }

    $comments = get_comments( $cargs );
    
    return $comments;
}

function findgo_get_total_reviews( $post_id ) {
    $args = array( 'post_id' => $post_id );
    $comments = findgo_get_review_comments($args);

    if (empty($comments)) {
        return 0;
    }
    
    return count($comments);
}

function findgo_get_total_rating( $post_id ) {
    $args = array( 'post_id' => $post_id );
    $comments = findgo_get_review_comments($args);
    if (empty($comments)) {
        return 0;
    }
    $total_review = 0;
    foreach ($comments as $comment) {
        $rating = intval( get_comment_meta( $comment->comment_ID, '_apus_rating', true ) );
        if ($rating) {
            $total_review += (int)$rating;
        }
    }
    return round($total_review/count($comments),2);
}

function findgo_get_total_rating_by_user( $user_id ) {
    $args = array( 'user_id' => $user_id );
    $comments = findgo_get_review_comments($args);

    if (empty($comments)) {
        return 0;
    }
    $total_review = 0;
    foreach ($comments as $comment) {
        $rating = intval( get_comment_meta( $comment->comment_ID, '_apus_rating', true ) );
        if ($rating) {
            $total_review += (int)$rating;
        }
    }
    return $total_review/count($comments);
}

function findgo_print_review( $rate, $type = '', $nb = 0 ) {
    ?>
    <div class="review-stars-rated-wrapper">
        <div class="review-stars-rated">
            <ul class="review-stars">
                <li><span class="fa fa-star-o"></span></li>
                <li><span class="fa fa-star-o"></span></li>
                <li><span class="fa fa-star-o"></span></li>
                <li><span class="fa fa-star-o"></span></li>
                <li><span class="fa fa-star-o"></span></li>
            </ul>
            
            <ul class="review-stars filled"  style="<?php echo esc_attr( 'width: ' . ( $rate * 20 ) . '%' ) ?>" >
                <li><span class="fa fa-star"></span></li>
                <li><span class="fa fa-star"></span></li>
                <li><span class="fa fa-star"></span></li>
                <li><span class="fa fa-star"></span></li>
                <li><span class="fa fa-star"></span></li>
            </ul>
        </div>
        <?php if ($type == 'detail') { ?>
            <span class="nb-review"><?php echo sprintf(_n('%d Review', '%d Reviews', $nb, 'findgo'), $nb); ?></span>
        <?php } elseif ($type == 'list') { ?>
            <span class="nb-review"><?php echo sprintf(_n('(%d Review)', '(%d Reviews)', $nb, 'findgo'), $nb); ?></span>
        <?php } ?>
    </div>
    <?php
}


function findgo_get_detail_ratings( $post_id ) {
    global $wpdb;
    $comment_ratings = $wpdb->get_results( $wpdb->prepare(
        "
            SELECT cm2.meta_value AS rating, COUNT(*) AS quantity FROM $wpdb->posts AS p
            INNER JOIN $wpdb->comments AS c ON (p.ID = c.comment_post_ID AND c.comment_approved=1)
            INNER JOIN $wpdb->commentmeta AS cm2 ON cm2.comment_id = c.comment_ID AND cm2.meta_key=%s
            WHERE p.ID=%d
            GROUP BY cm2.meta_value",
            '_apus_rating',
            $post_id
        ), OBJECT_K
    );
    return $comment_ratings;
}



// comment like
function findgo_check_comment_like_user($comment_id) {
    $meta_key = '_apus_like';
    $return = false;
    if ( is_user_logged_in() ) {
        $user_id = get_current_user_id();
        $data = get_user_meta( $user_id, $meta_key, true );
        
        if ( !empty($data) && is_array($data) && !empty($data[$comment_id]) ) {
            $return = true;
        }
    } else {
        $data = isset($_COOKIE[$meta_key]) ? $_COOKIE[$meta_key] : '';
        if ( !empty($data) ) {
            $data = explode(',', $data);
            if ( in_array($comment_id, $data) ) {
                $return = true;
            }
        }
    }
    return $return;
}

function findgo_comment_like_user($comment_id) {
    $meta_key = '_apus_like';
    $return = true;
    if ( is_user_logged_in() ) {
        $user_id = get_current_user_id();
        $data = get_user_meta( $user_id, $meta_key, true );
        
        if ( !empty($data) && is_array($data) && !empty($data[$comment_id]) ) {
            unset($data[$comment_id]);
            $return = false;
        } else {
            $data[$comment_id] = $comment_id;
        }
        update_user_meta( $user_id, $meta_key, $data );
    } else {
        $data = isset($_COOKIE[$meta_key]) ? $_COOKIE[$meta_key] : '';

        if ( !empty($data) ) {
            $data = explode(',', $data);
            
            if ( in_array($comment_id, $data) ) {
                $fdata = array_flip($data);
                unset($data[$fdata[$comment_id]]);
                $return = false;
            } else {
                $data[] = $comment_id;
            }
        } else {
            $data[] = $comment_id;
        }

        setcookie( $meta_key, implode(',', $data), time() + 30*24*60*60, '/' );
        $_COOKIE[$meta_key] = implode(',', $data);
    }
    return $return;
}

function findgo_comment_like() {
    
    check_ajax_referer( 'ajax-nonce', 'nonce' );

    $comment_id = !empty($_POST['comment_id']) ? $_POST['comment_id'] : 0;
    $count_key = '_apus_like';
    $count = 0;
    if ( !empty($comment_id) ) {
        $user_like = findgo_comment_like_user($comment_id);
        $tract = -1;
        if ( $user_like ) {
            $tract = 1;
        }
        $count = intval(get_comment_meta( $comment_id, $count_key, true ));
        if ( empty($count) ) {
            $count = 0 + $tract;
            delete_comment_meta($comment_id, $count_key);
            add_comment_meta($comment_id, $count_key, 1);
        } else {
            $count = $count + $tract;
            $count = sanitize_text_field($count);
            update_comment_meta($comment_id, $count_key, $count);
        }
    }
    $return = array();
    if ( $tract == -1) {
        $return = array(
            'icon' => '<i class="fa fa-thumbs-o-up"></i>',
            'dtitle' => sprintf(esc_html__('Like %d', 'findgo'), $count),
        );
    } else {
        $return = array(
            'icon' => '<i class="fa fa-thumbs-up"></i>',
            'dtitle' => sprintf(esc_html__('Like %d', 'findgo'), $count),
        );
    }
    echo json_encode($return);
    die();
}
add_action( 'wp_ajax_findgo_comment_like', 'findgo_comment_like' );
add_action( 'wp_ajax_nopriv_findgo_comment_like', 'findgo_comment_like' );


// comment dislike
function findgo_check_comment_dislike_user($comment_id) {
    $meta_key = '_apus_dislike';
    $return = false;
    if ( is_user_logged_in() ) {
        $user_id = get_current_user_id();
        $data = get_user_meta( $user_id, $meta_key, true );
        
        if ( !empty($data) && is_array($data) && !empty($data[$comment_id]) ) {
            $return = true;
        }
    } else {
        $data = isset($_COOKIE[$meta_key]) ? $_COOKIE[$meta_key] : '';
        if ( !empty($data) ) {
            $data = explode(',', $data);
            if ( in_array($comment_id, $data) ) {
                $return = true;
            }
        }
    }
    return $return;
}

function findgo_comment_dislike_user($comment_id) {
    $meta_key = '_apus_dislike';
    $return = true;
    if ( is_user_logged_in() ) {
        $user_id = get_current_user_id();
        $data = get_user_meta( $user_id, $meta_key, true );
        
        if ( !empty($data) && is_array($data) && !empty($data[$comment_id]) ) {
            unset($data[$comment_id]);
            $return = false;
        } else {
            $data[$comment_id] = $comment_id;
        }
        update_user_meta( $user_id, $meta_key, $data );
    } else {
        $data = isset($_COOKIE[$meta_key]) ? $_COOKIE[$meta_key] : '';

        if ( !empty($data) ) {
            $data = explode(',', $data);
            
            if ( in_array($comment_id, $data) ) {
                $fdata = array_flip($data);
                unset($data[$fdata[$comment_id]]);
                $return = false;
            } else {
                $data[] = $comment_id;
            }
        } else {
            $data[] = $comment_id;
        }

        setcookie( $meta_key, implode(',', $data), time() + 30*24*60*60, '/' );
        $_COOKIE[$meta_key] = implode(',', $data);
    }
    return $return;
}

function findgo_comment_dislike() {

    check_ajax_referer( 'ajax-nonce', 'nonce' );

    $comment_id = !empty($_POST['comment_id']) ? $_POST['comment_id'] : 0;
    $count_key = '_apus_dislike';
    $count = 0;
    if ( !empty($comment_id) ) {
        $user_dislike = findgo_comment_dislike_user($comment_id);
        $tract = -1;
        if ( $user_dislike ) {
            $tract = 1;
        }
        $count = intval(get_comment_meta( $comment_id, $count_key, true ));
        if ( empty($count) ) {
            $count = 0 + $tract;
            delete_comment_meta($comment_id, $count_key);
            add_comment_meta($comment_id, $count_key, 1);
        } else {
            $count = $count + $tract;
            $count = sanitize_text_field($count);
            update_comment_meta($comment_id, $count_key, $count);
        }
    }
    $return = array();
    if ( $tract == -1) {
        $return = array(
            'icon' => '<i class="fa fa-thumbs-o-down"></i>',
            'dtitle' => sprintf(esc_html__('Dislike %d', 'findgo'), $count),
        );
    } else {
        $return = array(
            'icon' => '<i class="fa fa-thumbs-down"></i>',
            'dtitle' => sprintf(esc_html__('Dislike %d', 'findgo'), $count),
        );
    }
    echo json_encode($return);
    die();
}
add_action( 'wp_ajax_findgo_comment_dislike', 'findgo_comment_dislike' );
add_action( 'wp_ajax_nopriv_findgo_comment_dislike', 'findgo_comment_dislike' );


// comment love
function findgo_check_comment_love_user($comment_id) {
    $meta_key = '_apus_love';
    $return = false;
    if ( is_user_logged_in() ) {
        $user_id = get_current_user_id();
        $data = get_user_meta( $user_id, $meta_key, true );
        
        if ( !empty($data) && is_array($data) && !empty($data[$comment_id]) ) {
            $return = true;
        }
    } else {
        $data = isset($_COOKIE[$meta_key]) ? $_COOKIE[$meta_key] : '';
        if ( !empty($data) ) {
            $data = explode(',', $data);
            if ( in_array($comment_id, $data) ) {
                $return = true;
            }
        }
    }
    return $return;
}

function findgo_comment_love_user($comment_id) {
    $meta_key = '_apus_love';
    $return = true;
    if ( is_user_logged_in() ) {
        $user_id = get_current_user_id();
        $data = get_user_meta( $user_id, $meta_key, true );
        
        if ( !empty($data) && is_array($data) && !empty($data[$comment_id]) ) {
            unset($data[$comment_id]);
            $return = false;
        } else {
            $data[$comment_id] = $comment_id;
        }
        update_user_meta( $user_id, $meta_key, $data );
    } else {
        $data = isset($_COOKIE[$meta_key]) ? $_COOKIE[$meta_key] : '';

        if ( !empty($data) ) {
            $data = explode(',', $data);
            
            if ( in_array($comment_id, $data) ) {
                $fdata = array_flip($data);
                unset($data[$fdata[$comment_id]]);
                $return = false;
            } else {
                $data[] = $comment_id;
            }
        } else {
            $data[] = $comment_id;
        }

        setcookie( $meta_key, implode(',', $data), time() + 30*24*60*60, '/' );
        $_COOKIE[$meta_key] = implode(',', $data);
    }
    return $return;
}

function findgo_comment_love() {

    check_ajax_referer( 'ajax-nonce', 'nonce' );
    
    $comment_id = !empty($_POST['comment_id']) ? $_POST['comment_id'] : 0;
    $count_key = '_apus_love';
    $count = 0;
    if ( !empty($comment_id) ) {
        $user_love = findgo_comment_love_user($comment_id);
        $tract = -1;
        if ( $user_love ) {
            $tract = 1;
        }
        $count = intval(get_comment_meta( $comment_id, $count_key, true ));
        if ( empty($count) ) {
            $count = 0 + $tract;
            delete_comment_meta($comment_id, $count_key);
            add_comment_meta($comment_id, $count_key, 1);
        } else {
            $count = $count + $tract;
            $count = sanitize_text_field($count);
            update_comment_meta($comment_id, $count_key, $count);
        }
    }
    $return = array();
    if ( $tract == -1) {
        $return = array(
            'icon' => '<i class="fa fa-heart-o"></i>',
            'dtitle' => sprintf(esc_html__('Love %d', 'findgo'), $count),
        );
    } else {
        $return = array(
            'icon' => '<i class="fa fa-heart"></i>',
            'dtitle' => sprintf(esc_html__('Love %d', 'findgo'), $count),
        );
    }
    echo json_encode($return);
    die();
}
add_action( 'wp_ajax_findgo_comment_love', 'findgo_comment_love' );
add_action( 'wp_ajax_nopriv_findgo_comment_love', 'findgo_comment_love' );


function findgo_paginate_links( $args = array() ) {
    global $wp_rewrite;

    $defaults = array(
        'base' => add_query_arg( 'cpage', '%#%' ),
        'format' => '',
        'total' => 1,
        'current' => 1,
        'add_fragment' => '#comments',
        'prev_text' => '&larr;',
        'next_text' => '&rarr;',
        'type'      => 'list',
        'end_size'  => 3,
        'mid_size'  => 3
    );
    if ( $wp_rewrite->using_permalinks() )
        $defaults['base'] = user_trailingslashit(trailingslashit(get_permalink()) . $wp_rewrite->comments_pagination_base . '-%#%', 'commentpaged');

    $args = wp_parse_args( $args, $defaults );
    ?>
    <nav class="manager-pagination apus-pagination">
        <?php echo paginate_links( $args ); ?>
    </nav>
    <?php
}