<?php

if ( in_array( 'js_composer/js_composer.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {
	
	if ( !function_exists('findgo_listing_get_categories') ) {
	    function findgo_listing_get_categories( $tax = 'job_listing_category', $text_default = ' --- Choose a Category --- ' ) {
	        $return = array( $text_default );

	        $args = array(
	            'type' => 'post',
	            'child_of' => 0,
	            'orderby' => 'name',
	            'order' => 'ASC',
	            'hide_empty' => false,
	            'hierarchical' => 1,
	            'taxonomy' => $tax
	        );

	        $categories = get_categories( $args );
	        findgo_listing_get_category_childs( $categories, 0, 0, $return );

	        return $return;
	    }
	}

	if ( !function_exists('findgo_listing_get_category_childs') ) {
	    function findgo_listing_get_category_childs( $categories, $id_parent, $level, &$dropdown ) {
	        foreach ( $categories as $key => $category ) {
	            if ( $category->category_parent == $id_parent ) {
	                $dropdown = array_merge( $dropdown, array( str_repeat( "- ", $level ) . $category->name => $category->slug ) );
	                unset($categories[$key]);
	                findgo_listing_get_category_childs( $categories, $category->term_id, $level + 1, $dropdown );
	            }
	        }
	    }
	}
	
    if ( !function_exists('findgo_vc_get_term_object')) {
		function findgo_vc_get_term_object($term) {
			$vc_taxonomies_types = vc_taxonomies_types();

			return array(
				'label' => $term->name,
				'value' => $term->slug,
				'group_id' => $term->taxonomy,
				'group' => isset( $vc_taxonomies_types[ $term->taxonomy ], $vc_taxonomies_types[ $term->taxonomy ]->labels, $vc_taxonomies_types[ $term->taxonomy ]->labels->name ) ? $vc_taxonomies_types[ $term->taxonomy ]->labels->name : esc_html__( 'Taxonomies', 'findgo' ),
			);
		}
	}

	// types
	if ( !function_exists('findgo_categories_field_search')) {
		function findgo_categories_field_search( $search_string ) {
			$data = array();
			$vc_taxonomies_types = array('job_listing_category');
			$vc_taxonomies = get_terms( $vc_taxonomies_types, array(
				'hide_empty' => false,
				'search' => $search_string
			) );
			if ( is_array( $vc_taxonomies ) && ! empty( $vc_taxonomies ) ) {
				foreach ( $vc_taxonomies as $t ) {
					if ( is_object( $t ) ) {
						$data[] = findgo_vc_get_term_object( $t );
					}
				}
			}
			return $data;
		}
	}
	if ( !function_exists('findgo_categories_render')) {
		function findgo_categories_render( $query ) {
			$category = get_term_by('slug', $query['value'], 'job_listing_category');
			if ( ! empty( $query ) && !empty($category)) {
				$data = array();
				$data['value'] = $category->slug;
				$data['label'] = $category->name;
				return ! empty( $data ) ? $data : false;
			}
			return false;
		}
	}

	// locations
	if ( !function_exists('findgo_regions_field_search')) {
		function findgo_regions_field_search( $search_string ) {
			$data = array();
			$vc_taxonomies_types = array('job_listing_region');
			$vc_taxonomies = get_terms( $vc_taxonomies_types, array(
				'hide_empty' => false,
				'search' => $search_string
			) );
			if ( is_array( $vc_taxonomies ) && ! empty( $vc_taxonomies ) ) {
				foreach ( $vc_taxonomies as $t ) {
					if ( is_object( $t ) ) {
						$data[] = findgo_vc_get_term_object( $t );
					}
				}
			}
			return $data;
		}
	}
	if ( !function_exists('findgo_regions_render')) {
		function findgo_regions_render( $query ) {
			$category = get_term_by('slug', $query['value'], 'job_listing_region');
			if ( ! empty( $query ) && !empty($category)) {
				$data = array();
				$data['value'] = $category->slug;
				$data['label'] = $category->name;
				return ! empty( $data ) ? $data : false;
			}
			return false;
		}
	}


	$tags = array(
		'apus_listings' => array( 'categories' => 'categories', 'regions' => 'regions' ),
		'apus_listings_map' => array( 'categories' => 'categories', 'regions' => 'regions' ),
	);
	foreach( $tags as $tag => $param_names ){
		if ( is_array($param_names) ) {
			foreach ($param_names as $param_name => $tax) {
				add_filter( 'vc_autocomplete_'.$tag .'_'.$param_name.'_callback', 'findgo_'.$tax.'_field_search', 10, 1 );
		 		add_filter( 'vc_autocomplete_'.$tag .'_'.$param_name.'_render', 'findgo_'.$tax.'_render', 10, 1 );
			}
		} else {
			add_filter( 'vc_autocomplete_'.$tag .'_'.$param_names.'_callback', 'findgo_'.$param_names.'_field_search', 10, 1 );
		 	add_filter( 'vc_autocomplete_'.$tag .'_'.$param_names.'_render', 'findgo_'.$param_names.'_render', 10, 1 );
		}
	}

}