<?php
if ( class_exists("WPBakeryShortCode") ) {
	
	if ( !function_exists('findgo_load_job_manager_element')) {
		function findgo_load_job_manager_element() {
			
			$custom_menus = array(esc_html__("Choose a menu", 'findgo') => '',);
			if ( is_admin() ) {
				$menus = get_terms( 'nav_menu', array( 'hide_empty' => false ) );
				if ( is_array( $menus ) && ! empty( $menus ) ) {
					foreach ( $menus as $single_menu ) {
						if ( is_object( $single_menu ) && isset( $single_menu->name, $single_menu->slug ) ) {
							$custom_menus[ $single_menu->name ] = $single_menu->slug;
						}
					}
				}
			}

			vc_map( array(
		        "name" => esc_html__("Apus Listings", 'findgo'),
		        "base" => "apus_listings",
		        "class" => "",
		    	"category" => esc_html__('Apus Listings', 'findgo'),
		    	'description'	=> esc_html__( 'Display Listings', 'findgo' ),
		        "params" => array(
		            array(
		                "type" => "textfield",
		                "class" => "",
		                "heading" => esc_html__('Title','findgo'),
		                "param_name" => "title",
		            ),
		            array(
		                "type" => "textarea",
		                "class" => "",
		                "heading" => esc_html__('Sub Title','findgo'),
		                "param_name" => "subtitle",
		            ),
		            array(
		                "type" => "textfield",
		                "heading" => esc_html__("Number items to show", 'findgo'),
		                "param_name" => "number",
		                'std' => '4'
		            ),
		            array(
		                "type" => "dropdown",
		                "heading" => esc_html__('Listings Type','findgo'),
		                "param_name" => 'types',
		                "value" => array(
		                	esc_html__('Recent Listing', 'findgo') => 'recent',
		                	esc_html__('Popular Listing', 'findgo') => 'popular',
		                	esc_html__('Featured Listing', 'findgo') => 'featured',
		                	esc_html__('Random', 'findgo') => 'rand',
	                	),
		            ),
		            array(
					    'type' => 'autocomplete',
					    'heading' => esc_html__( 'Listing Categories', 'findgo' ),
					    'param_name' => 'categories',
					    "admin_label" => true,
					    'description' => esc_html__( 'Choose categories if you want to show listings of them', 'findgo' ),
					    'settings' => array(
					     	'multiple' => true,
					     	'unique_values' => true
					    ),
				   	),
				   	array(
					    'type' => 'autocomplete',
					    'heading' => esc_html__( 'Listing Regions', 'findgo' ),
					    'param_name' => 'regions',
					    "admin_label" => true,
					    'description' => esc_html__( 'Choose regions if you want to show listings of them', 'findgo' ),
					    'settings' => array(
					     	'multiple' => true,
					     	'unique_values' => true
					    ),
				   	),
		            array(
		                "type" => "dropdown",
		                "heading" => esc_html__('Number Columns','findgo'),
		                "param_name" => "columns",
		                "value" => array(1,2,3,4,6)
		            ),
		            array(
		                "type" => "dropdown",
		                "heading" => esc_html__('Style Layout','findgo'),
		                "param_name" => "style",
		                "value" => array(
		                	esc_html__('Grid', 'findgo') => 'grid',
		                	esc_html__('Carousel', 'findgo') => 'carousel',
		                	esc_html__('List', 'findgo') => 'list',
	                	),
		                "admin_label" => true,
		                "description" => esc_html__("Select Style Layout.", 'findgo')
		            ),
		            array(
						"type" => "dropdown",
						"heading" => esc_html__("Item Style", 'findgo'),
						"param_name" => "item",
						'value' 	=> array(
							esc_html__('Grid 1', 'findgo') => 'grid', 
							esc_html__('Grid 2', 'findgo') => 'grid-v2',
						),
						'dependency' => array(
							'element' => 'style',
							'value' => array('carousel','grid'),
						),
					),
		            array(
		                "type" => "checkbox",
		                "heading" => esc_html__('Show Nav','findgo'),
		                "param_name" => "show_nav",
		                "value" => 0,
		                'dependency' => array(
							'element' => 'style',
							'value' => array('carousel'),
						),
		            ),
		            array(
		                "type" => "checkbox",
		                "heading" => esc_html__('Show Pagination','findgo'),
		                "param_name" => "show_pagination",
		                "value" => 0,
		                'dependency' => array(
							'element' => 'style',
							'value' => array('carousel'),
						),
		            ),
		            array(
		                "type" => "textfield",
		                "heading" => esc_html__("Extra class name", 'findgo'),
		                "param_name" => "el_class",
		                "description" => esc_html__("If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", 'findgo')
		            ),
		        )
		    ));

			vc_map( array(
		        "name" => esc_html__("Apus Listings Map", 'findgo'),
		        "base" => "apus_listings_map",
		        "class" => "",
		    	"category" => esc_html__('Apus Listings', 'findgo'),
		    	'description'	=> esc_html__( 'Display Listings', 'findgo' ),
		        "params" => array(
		            array(
		                "type" => "textfield",
		                "heading" => esc_html__("Number items to show", 'findgo'),
		                "param_name" => "number",
		                'std' => '4'
		            ),
		            array(
		                "type" => "dropdown",
		                "heading" => esc_html__('Listings Type','findgo'),
		                "param_name" => 'types',
		                "value" => array(
		                	esc_html__('Popular Listing', 'findgo') => 'popular',
		                	esc_html__('Featured Listing', 'findgo') => 'featured',
		                	esc_html__('Recent Listing', 'findgo') => 'recent',
		                	esc_html__('Random', 'findgo') => 'rand',
	                	),
		            ),
		            array(
					    'type' => 'autocomplete',
					    'heading' => esc_html__( 'Listing Categories', 'findgo' ),
					    'param_name' => 'categories',
					    "admin_label" => true,
					    'description' => esc_html__( 'Choose categories if you want to show listings of them', 'findgo' ),
					    'settings' => array(
					     	'multiple' => true,
					     	'unique_values' => true
					    ),
				   	),
				   	array(
					    'type' => 'autocomplete',
					    'heading' => esc_html__( 'Listing Regions', 'findgo' ),
					    'param_name' => 'regions',
					    "admin_label" => true,
					    'description' => esc_html__( 'Choose regions if you want to show listings of them', 'findgo' ),
					    'settings' => array(
					     	'multiple' => true,
					     	'unique_values' => true
					    ),
				   	),
		            array(
		                "type" => "textfield",
		                "heading" => esc_html__("Extra class name", 'findgo'),
		                "param_name" => "el_class",
		                "description" => esc_html__("If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", 'findgo')
		            ),
		        )
		    ));

			$categories = array();
			$columns = array(1,2,3,4,6);
			if ( is_admin() ) {
				$categories = findgo_listing_get_categories();
			}
			vc_map( array(
		        "name" => esc_html__("Apus Listing Categories Banner",'findgo'),
		        "base" => "apus_listing_categories_banner",
		    	"category" => esc_html__('Apus Listings', 'findgo'),
		    	'description'	=> esc_html__( 'Display Listing Type in frontend', 'findgo' ),
		        "params" => array(
	        		array(
						"type" => "attach_image",
						"param_name" => "image",
						'heading'	=> esc_html__('Image Banner', 'findgo' )
					),
		            array(
						"type" => "dropdown",
						"heading" => esc_html__('Category', 'findgo'),
						"param_name" => "category",
						"value" => $categories
					),
					array(
		                "type" => "textfield",
		                "heading" => esc_html__("Title", 'findgo'),
		                "param_name" => "title"
		            ),
		            array(
						"type"        => "textfield",
						"param_name"  => "icon_font",
						'heading'     => esc_html__('Icon Font', 'findgo' ),
						'description' => esc_html__( 'This support display icon from FontAwsome, Please click', 'findgo' )
											. '<a href="' . ( is_ssl()  ? 'https' : 'http') . '://fortawesome.github.io/Font-Awesome/" target="_blank">'
											. esc_html__( 'here to see the list', 'findgo' ) . '</a>'
					),
					array(
						"type" => "attach_image",
						"description" => esc_html__("If you upload an icon image, icon font will not show.", 'findgo'),
						"param_name" => "icon_image",
						'heading'	=> esc_html__('Icon Image', 'findgo' )
					),
					array(
		                "type" => "dropdown",
		                "heading" => esc_html__('Style','findgo'),
		                "param_name" => 'style',
		                "value" => array(
		                	esc_html__('Style 1', 'findgo') => '',
		                	esc_html__('Style 2', 'findgo') => 'style2',
	                	),
		            ),
		            array(
		                "type" => "textfield",
		                "heading" => esc_html__("Extra class name", 'findgo'),
		                "param_name" => "el_class",
		                "description" => esc_html__("If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", 'findgo')
		            ),
		        )
		    ));

			vc_map( array(
		        "name" => esc_html__("Apus Listing Categories",'findgo'),
		        "base" => "apus_listing_categories",
		    	"category" => esc_html__('Apus Listings', 'findgo'),
		    	'description'	=> esc_html__( 'Display Listing Type in frontend', 'findgo' ),
		        "params" => array(
	        		array(
						'type' => 'param_group',
						'heading' => esc_html__('Categories Settings', 'findgo' ),
						'param_name' => 'categories',
						'params' => array(
				            array(
								"type" => "dropdown",
								"heading" => esc_html__('Category', 'findgo'),
								"param_name" => "category",
								"value" => $categories
							),
							array(
				                "type" => "textfield",
				                "heading" => esc_html__("Title", 'findgo'),
				                "param_name" => "title"
				            ),
				            array(
								"type"        => "textfield",
								"param_name"  => "icon_font",
								'heading'     => esc_html__('Icon Font', 'findgo' ),
								'description' => esc_html__( 'This support display icon from FontAwsome, Please click', 'findgo' )
													. '<a href="' . ( is_ssl()  ? 'https' : 'http') . '://fortawesome.github.io/Font-Awesome/" target="_blank">'
													. esc_html__( 'here to see the list', 'findgo' ) . '</a>'
							),
							array(
								"type" => "attach_image",
								"description" => esc_html__("If you upload an icon image, icon font will not show.", 'findgo'),
								"param_name" => "icon_image",
								'heading'	=> esc_html__('Icon Image', 'findgo' )
							),
							array(
								"type" => "attach_image",
								"description" => esc_html__("Image for Background Box (only for style2, style3, style4)", 'findgo'),
								"param_name" => "bg_image",
								'heading'	=> esc_html__('Background Image Hover', 'findgo' )
							),
						),
					),
					array(
		                "type" => "dropdown",
		                "heading" => esc_html__('Style','findgo'),
		                "param_name" => 'style',
		                "value" => array(
		                	esc_html__('Style 1', 'findgo') => 'style1',
		                	esc_html__('Style 2', 'findgo') => 'style2',
		                	esc_html__('Style 3', 'findgo') => 'style3',
		                	esc_html__('Style 4', 'findgo') => 'style4',
		                	esc_html__('Style 5', 'findgo') => 'style5',
	                	),
		            ),
		            array(
		                "type" => "dropdown",
		                "heading" => esc_html__('Grid Columns','findgo'),
		                "param_name" => 'grid_columns',
		                "value" => $columns,
		                'dependency' => array(
							'element' => 'style',
							'value' => array('style2','style3','style4'),
						),
		            ),
		            array(
		                "type" => "textfield",
		                "heading" => esc_html__("Extra class name", 'findgo'),
		                "param_name" => "el_class",
		                "description" => esc_html__("If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", 'findgo')
		            ),
		        )
		    ));

			$cities = array();
			if ( is_admin() ) {
				$cities = findgo_listing_get_categories( 'job_listing_region', esc_html__( ' --- Choose a Category --- ', 'findgo' ) );
			}
			
			vc_map( array(
		        "name" => esc_html__("Apus Listing Cities",'findgo'),
		        "base" => "apus_listing_cities",
		    	"category" => esc_html__('Apus Listings', 'findgo'),
		    	'description'	=> esc_html__( 'Display Listing Type in frontend', 'findgo' ),
		        "params" => array(
		        	array(
						'type' => 'param_group',
						'heading' => esc_html__('Cities Settings', 'findgo' ),
						'param_name' => 'cities',
						'params' => array(
				            array(
								"type" => "dropdown",
								"heading" => esc_html__('City', 'findgo'),
								"param_name" => "city",
								"value" => $cities
							),
							array(
				                "type" => "textfield",
				                "heading" => esc_html__("Title", 'findgo'),
				                "param_name" => "title"
				            ),
							array(
								"type"        => "attach_image",
								"param_name"  => "image",
								'heading'     => esc_html__('City Image', 'findgo' )
							),
						),
					),
					array(
		                "type" => "checkbox",
		                "heading" => esc_html__('Show Listing Number', 'findgo'),
		                "param_name" => "show_nb",
		                "value" => 0,
		            ),
		            array(
						"type" => "dropdown",
						"heading" => esc_html__("Layout Type",'findgo'),
						"param_name" => "layout_type",
						"value" => array(
							esc_html__("Layout 1", 'findgo') => 'layout1',
							esc_html__("Layout 2", 'findgo') => 'layout2',
							esc_html__("Layout 3", 'findgo') => 'layout3',
							esc_html__("Layout 4", 'findgo') => 'layout4',
						)
					),
					array(
						"type" => "dropdown",
						"heading" => esc_html__("Columns",'findgo'),
						"param_name" => "columns",
						"value" => array(1,2,3,4,5,6),
						'dependency' => array(
							'element' => 'layout_type',
							'value' => array('layout1','layout4'),
						),
					),
		            array(
		                "type" => "textfield",
		                "heading" => esc_html__("Extra class name", 'findgo'),
		                "param_name" => "el_class",
		                "description" => esc_html__("If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", 'findgo')
		            ),
		        )
		    ));

			

		    vc_map( array(
		        "name" => esc_html__("Apus Listing Search", 'findgo'),
		        "base" => "apus_listing_search",
		        "class" => "",
		    	"category" => esc_html__('Apus Listings', 'findgo'),
		    	'description'	=> esc_html__( 'Display Listing Search Form in frontend', 'findgo' ),
		        "params" => array(
		        	array(
						'type' => 'checkbox',
						'heading' => esc_html__( 'Show Search Keyword Field?', 'findgo' ),
						'param_name' => 'search_keyword',
						'description' => esc_html__( 'Enable Search keyword.', 'findgo' ),
						'value' => array( esc_html__( 'Yes, to show Keyword field', 'findgo' ) => 'yes' )
					),
					array(
						'type' => 'checkbox',
						'heading' => esc_html__( 'Show Search Suggestions', 'findgo' ),
						'param_name' => 'show_search_suggestions',
						'description' => sprintf(__('Go to <a href="%s" target="_blank">Menu</a> o add menu for "Suggestions Search" location', 'findgo'), admin_url( 'nav-menus.php') )
					),
					array(
						"type" => "dropdown",
						"heading" => esc_html__('Show Popular Searchs', 'findgo'),
						"param_name" => "show_popular_search",
						"value" => $custom_menus
					),
					array(
						"type" => "dropdown",
						"heading" => esc_html__("Show Search Region/Location Field?",'findgo'),
						"param_name" => "search_region_location",
						"value" => array(
							esc_html__("Hidden", 'findgo') => '',
							esc_html__("Regions", 'findgo') => 'region',
							esc_html__("Location", 'findgo') => 'location',
						)
					),
					array(
						'type' => 'checkbox',
						'heading' => esc_html__( 'Show Search Category Field?', 'findgo' ),
						'param_name' => 'search_category',
						'description' => esc_html__( 'Enable Search category.', 'findgo' ),
						'value' => array( esc_html__( 'Yes, to show Category field', 'findgo' ) => 'yes' )
					),
		            array(
						"type" => "dropdown",
						"heading" => esc_html__("Style",'findgo'),
						"param_name" => "style",
						"value" => array(
							esc_html__("Style 1", 'findgo') => 'style1',
							esc_html__("Style 2", 'findgo') => 'style2',
							esc_html__("Style 3", 'findgo') => 'style3',
							esc_html__("Style 4", 'findgo') => 'style4',
						)
					),
		            array(
		                "type" => "textfield",
		                "heading" => esc_html__("Extra class name", 'findgo'),
		                "param_name" => "el_class",
		                "description" => esc_html__("If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", 'findgo')
		            ),
		        )
		    ));

		    vc_map( array(
		        "name" => esc_html__("Apus My Short Profile", 'findgo'),
		        "base" => "apus_my_short_profile",
		    	"category" => esc_html__('Apus Listings', 'findgo'),
		    	'description'	=> esc_html__( 'Display edit profile form in frontend', 'findgo' ),
		        "params" => array(
		        	array(
						"type" => "dropdown",
						"heading" => esc_html__('Menu', 'findgo'),
						"param_name" => "nav_menu",
						"value" => $custom_menus
					),
		            array(
		                "type" => "textfield",
		                "heading" => esc_html__("Extra class name", 'findgo'),
		                "param_name" => "el_class",
		                "description" => esc_html__("If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", 'findgo')
		            ),
		        )
		    ));

		    vc_map( array(
		        "name" => esc_html__("Apus My Dashboard", 'findgo'),
		        "base" => "apus_my_dashboard",
		    	"category" => esc_html__('Apus Listings', 'findgo'),
		    	'description'	=> esc_html__( 'Display edit profile form in frontend', 'findgo' ),
		        "params" => array(

		            array(
		                "type" => "textfield",
		                "heading" => esc_html__("Extra class name", 'findgo'),
		                "param_name" => "el_class",
		                "description" => esc_html__("If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", 'findgo')
		            ),
		        )
		    ));

		    vc_map( array(
		        "name" => esc_html__("Apus Edit Profile", 'findgo'),
		        "base" => "apus_edit_profile",
		    	"category" => esc_html__('Apus Listings', 'findgo'),
		    	'description'	=> esc_html__( 'Display edit profile form in frontend', 'findgo' ),
		        "params" => array(

		            array(
		                "type" => "textfield",
		                "heading" => esc_html__("Extra class name", 'findgo'),
		                "param_name" => "el_class",
		                "description" => esc_html__("If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", 'findgo')
		            ),
		        )
		    ));

		    vc_map( array(
		        "name" => esc_html__("Apus My Reviews", 'findgo'),
		        "base" => "apus_my_reviews",
		    	"category" => esc_html__('Apus Listings', 'findgo'),
		    	'description'	=> esc_html__( 'Display My Reviews in frontend', 'findgo' ),
		        "params" => array(
		            array(
		                "type" => "textfield",
		                "heading" => esc_html__("Extra class name", 'findgo'),
		                "param_name" => "el_class",
		                "description" => esc_html__("If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", 'findgo')
		            ),
		        )
		    ));

		    vc_map( array(
		        "name" => esc_html__("Apus My Follower/Following", 'findgo'),
		        "base" => "apus_my_follow",
		    	"category" => esc_html__('Apus Listings', 'findgo'),
		    	'description'	=> esc_html__( 'Display My Follower/Following in frontend', 'findgo' ),
		        "params" => array(
		        	array(
						"type" => "dropdown",
						"heading" => esc_html__("Display Type",'findgo'),
						"param_name" => "display_type",
						"value" => array(
							esc_html__("Followers", 'findgo') => 'followers',
							esc_html__("Following", 'findgo') => 'following',
						)
					),
		            array(
		                "type" => "textfield",
		                "heading" => esc_html__("Extra class name", 'findgo'),
		                "param_name" => "el_class",
		                "description" => esc_html__("If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", 'findgo')
		            ),
		        )
		    ));

		    vc_map( array(
		        "name" => esc_html__("Apus My Bookmark", 'findgo'),
		        "base" => "apus_my_bookmark",
		    	"category" => esc_html__('Apus Listings', 'findgo'),
		    	'description'	=> esc_html__( 'Display edit profile form in frontend', 'findgo' ),
		        "params" => array(
		            array(
		                "type" => "textfield",
		                "heading" => esc_html__("Extra class name", 'findgo'),
		                "param_name" => "el_class",
		                "description" => esc_html__("If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", 'findgo')
		            ),
		        )
		    ));
		}
		add_action( 'vc_after_set_mode', 'findgo_load_job_manager_element', 99 );

		class WPBakeryShortCode_Apus_listings extends WPBakeryShortCode {}
		class WPBakeryShortCode_Apus_listings_map extends WPBakeryShortCode {}
		class WPBakeryShortCode_Apus_listing_categories_banner extends WPBakeryShortCode {}
		class WPBakeryShortCode_Apus_listing_categories extends WPBakeryShortCode {}
		class WPBakeryShortCode_Apus_listing_cities extends WPBakeryShortCode {}
		class WPBakeryShortCode_Apus_listing_search extends WPBakeryShortCode {}
		class WPBakeryShortCode_Apus_edit_profile extends WPBakeryShortCode {}
		class WPBakeryShortCode_Apus_my_reviews extends WPBakeryShortCode {}
		class WPBakeryShortCode_Apus_my_follow extends WPBakeryShortCode {}
		class WPBakeryShortCode_Apus_my_bookmark extends WPBakeryShortCode {}
		class WPBakeryShortCode_Apus_my_short_profile extends WPBakeryShortCode {}
		class WPBakeryShortCode_Apus_my_dashboard extends WPBakeryShortCode {}
	}
}