<?php

class Findgo_Listings extends Apus_Widget {
    public function __construct() {
        parent::__construct(
            'apus_listings',
            esc_html__('Apus Listings Widget', 'findgo'),
            array( 'description' => esc_html__( 'Show listings form in sidebar', 'findgo' ), )
        );
        $this->widgetName = 'listings';
    }

    public function getTemplate() {
        $this->template = 'listings.php';
    }

    public function widget( $args, $instance ) {
        $this->display($args, $instance);
    }
    
    public function form( $instance ) {
        $defaults = array(
            'title' => 'Listings',
            'listing_type' => 'recent',
            'number_post' => '4',
        );
        $instance = wp_parse_args((array) $instance, $defaults);
        // Widget admin form
        $types = array(
            'recent' => esc_html__('Recent Listing', 'findgo'),
            'popular' => esc_html__('Popular Listing', 'findgo'),
            'featured' => esc_html__('Featured Listing', 'findgo'),
        );
        ?>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id( 'title' )); ?>"><?php esc_html_e( 'Title:', 'findgo' ); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'title' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'title' )); ?>" type="text" value="<?php echo esc_attr( $instance['title'] ); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('listing_type')); ?>">
                <?php echo esc_html__('Listing Type:', 'findgo' ); ?>
            </label>
            <br>
            <select id="<?php echo esc_attr($this->get_field_id('listing_type')); ?>" name="<?php echo esc_attr($this->get_field_name('listing_type')); ?>">
                <?php foreach ($types as $key => $value) { ?>
                    <option value="<?php echo esc_attr( $key ); ?>" <?php selected($instance['listing_type'],$key); ?> ><?php echo esc_html( $value ); ?></option>
                <?php } ?>
            </select>
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id( 'number_post' )); ?>"><?php esc_html_e( 'Number Listings:', 'findgo' ); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'number_post' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'number_post' )); ?>" type="text" value="<?php echo esc_attr($instance['number_post']); ?>" />
        </p>
<?php
    }

    public function update( $new_instance, $old_instance ) {
        $instance = array();
        $instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
        $instance['listing_type'] = ( ! empty( $new_instance['listing_type'] ) ) ? strip_tags( $new_instance['listing_type'] ) : '';
        $instance['number_post'] = ( ! empty( $new_instance['number_post'] ) ) ? strip_tags( $new_instance['number_post'] ) : '';
        return $instance;
    }
}

register_widget( 'Findgo_Listings' );