<?php

class Findgo_My_Short_Profile extends Apus_Widget {
    public $link_options;
    public function __construct() {
        parent::__construct(
            'apus_my_short_profile',
            esc_html__('Apus My Short Profile', 'findgo'),
            array( 'description' => esc_html__( 'Show my short profile', 'findgo' ), )
        );
        $this->widgetName = 'my_short_profile';

        $this->link_options = array(
            'show_user_profile_link' => esc_html__('Show my profile link', 'findgo'),
            'show_user_listings_link' => esc_html__('Show my listings link', 'findgo'),
            'show_user_bookmarks_link' => esc_html__('Show my bookmarks link', 'findgo'),
            'show_user_reviews_link' => esc_html__('Show my reviews link', 'findgo'),
            'show_user_following_link' => esc_html__('Show my following link', 'findgo'),
            'show_user_follower_link' => esc_html__('Show my follower link', 'findgo'),
        );
    }

    public function getTemplate() {
        $this->template = 'my-short-profile.php';
    }

    public function widget( $args, $instance ) {
        $this->display($args, $instance);
    }
    
    public function form( $instance ) {
        $defaults = array(
            'nav_menu' => ''
        );
        $instance = wp_parse_args((array) $instance, $defaults);
        // Widget admin form

        $custom_menus = array();
        $menus = get_terms( 'nav_menu', array( 'hide_empty' => false ) );
        if ( is_array( $menus ) && ! empty( $menus ) ) {
            foreach ( $menus as $single_menu ) {
                if ( is_object( $single_menu ) && isset( $single_menu->name, $single_menu->slug ) ) {
                    $custom_menus[ $single_menu->name ] = $single_menu->slug;
                }
            }
        }
        // Widget admin form
        ?>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('nav_menu')); ?>">
                <?php echo esc_html__('Menu:', 'findgo' ); ?>
            </label>
            <br>
            <select id="<?php echo esc_attr($this->get_field_id('nav_menu')); ?>" name="<?php echo esc_attr($this->get_field_name('nav_menu')); ?>">
                <?php foreach ( $custom_menus as $key => $value ) { ?>
                    <option value="<?php echo esc_attr( $value ); ?>" <?php selected($instance['nav_menu'],$value); ?> ><?php echo esc_html( $key ); ?></option>
                <?php } ?>
            </select>
        </p>
        <?php
    }

    public function update( $new_instance, $old_instance ) {
        $instance = array();
        $instance['nav_menu'] = ( ! empty( $new_instance['nav_menu'] ) ) ? strip_tags( $new_instance['nav_menu'] ) : '';
        return $instance;

    }
}

register_widget( 'Findgo_My_Short_Profile' );