<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

$field['default'] = empty( $field['default'] ) ? current( array_keys( $field['options'] ) ) : $field['default'];
$default          = ! empty( $field['value'] ) ? $field['value'] : $field['default'];
?>
<div class="radio-images">
<?php foreach ( $field['options'] as $option_key => $value ) : ?>
	<div class="radio-images-inner">
		<label>
			<input type="radio" name="<?php echo esc_attr( isset( $field['name'] ) ? $field['name'] : $key ); ?>" value="<?php echo esc_attr( $option_key ); ?>" <?php checked( $default, $option_key ); ?> />
			<img src="<?php echo esc_url( $value['img'] ); ?>">
		</label>
		<div class="layout-style-title"><?php echo esc_html( $value['title'] ); ?></div>
	</div>
<?php endforeach; ?>
</div>
<?php if ( ! empty( $field['description'] ) ) : ?><small class="description"><?php echo trim($field['description']); ?></small><?php endif; ?>