<?php
/**
 * Shows the `text` form field on job listing forms.
 *
 * This template can be overridden by copying it to yourtheme/job_manager/form-fields/text-field.php.
 *
 * @see         https://wpjobmanager.com/document/template-overrides/
 * @author      Automattic
 * @package     WP Job Manager
 * @category    Template
 * @version     1.27.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
global $post, $thepostid;
wp_enqueue_script( 'listing-location', get_template_directory_uri() . '/js/listing-location.js', array('jquery'), '20141010', true );

if ( $thepostid ) {
	$job_id = $thepostid;
} else {
	$job_id = !empty($_GET['job_id']) ? $_GET['job_id'] : '';
}

$geo_latitude = get_post_meta( $job_id, 'geolocation_lat', true );
$geo_longitude = get_post_meta( $job_id, 'geolocation_long', true );
?>
<div class="findgo-location-field">
	<div class="findgo-location-field-inner">
		<input type="text" class="input-text input-location-field" name="<?php echo esc_attr( isset( $field['name'] ) ? $field['name'] : $key ); ?>"<?php if ( isset( $field['autocomplete'] ) && false === $field['autocomplete'] ) { echo ' autocomplete="off"'; } ?> id="<?php echo esc_attr( $key ); ?>" placeholder="<?php echo esc_attr( $field['placeholder'] ); ?>" value="<?php echo isset( $field['value'] ) ? esc_attr( $field['value'] ) : ''; ?>" maxlength="<?php echo ! empty( $field['maxlength'] ) ? $field['maxlength'] : ''; ?>" <?php if ( ! empty( $field['required'] ) ) echo 'required'; ?> />
		<span class="find-me-location" title="<?php echo esc_attr__('Find Me', 'findgo'); ?>"><?php get_template_part( 'images/icon/location' ); ?></span>
	</div>
	<div class="findgo-location-field-map"></div>
	<div class="row hidden">
		<div class="col-sm-6">
			<fieldset>
				<label><?php esc_html_e( 'Latitude', 'findgo' ); ?></label>
				<div class="field">
					<input class="geo_latitude"  name="geo_latitude" value="<?php echo esc_attr( $geo_latitude); ?>" type="text">
				</div>
			</fieldset>
		</div>
		<div class="col-sm-6">
			<fieldset>
				<label><?php esc_html_e( 'Longitude', 'findgo' ); ?></label>
				<div class="field">
					<input class="geo_longitude"  name="geo_longitude" value="<?php echo esc_attr( $geo_longitude ); ?>" type="text">
				</div>
			</fieldset>
		</div>
	</div>
</div>
<?php if ( ! empty( $field['description'] ) ) : ?><small class="description"><?php echo trim($field['description']); ?></small><?php endif; ?>