<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
global $thepostid;
if ( $thepostid ) {
	$job_id = $thepostid;
} else {
	$job_id = !empty($_REQUEST['job_id']) ? $_REQUEST['job_id'] : '';
}

$items = ! empty( $field['value'] ) ? $field['value'] : array();

$items_data = get_post_meta( $job_id, '_job_menu_prices_data', true );

?>
<div class="menu-prices-field">
	<h3 class="title"><?php esc_html_e('Menu Prices', 'findgo'); ?></h3>
	<div class="menu-prices-field-wrapper">
		<?php if ( !empty($items_data) && is_array($items_data) ) {
			$i = 0; foreach ($items_data as $section) {
				?>
				<div class="menu-prices-section-item">
					<div class="job-manager-section-title">
						<h4><?php esc_html_e('Section Title', 'findgo'); ?></h4>
						<input type="text" class="input-text input-section-title" name="_job_menu_prices[<?php echo esc_attr($i); ?>][section_title]" value="<?php echo esc_attr(!empty($section['section_title']) ? $section['section_title'] : ''); ?>"/>
					</div>
					<h4><?php esc_html_e('Section Items', 'findgo'); ?></h4>
					<!-- loop here -->
					<div class="menu-prices-section-item-wrapper">
						<?php
						$titles_value = !empty($section['title']) ? $section['title'] : array();
						$items_prices = !empty($section['price']) ?  $section['price'] : array();
						$items_descriptions = !empty($section['description']) ? $section['description'] : array();

						foreach ($titles_value as $key => $title_value) {
							$price_value = !empty($items_prices[$key]) ? $items_prices[$key] : '';
							$description_value = !empty($items_descriptions[$key]) ? $items_descriptions[$key] : '';
						?>
							<div class="menu-prices-item">
								<div class="row">
									<div class="col-sm-6">
										<div class="job-manager-title">
											<label><?php esc_html_e('Title', 'findgo'); ?></label>
											<input type="text" class="input-text input-section-item-title" name="_job_menu_prices[<?php echo esc_attr($i); ?>][title][]" value="<?php echo esc_attr($title_value); ?>"/>
										</div>
										<div class="job-manager-price">
											<label><?php esc_html_e('Price', 'findgo'); ?></label>
											<input type="text" class="input-text input-section-item-price" name="_job_menu_prices[<?php echo esc_attr($i); ?>][price][]" value="<?php echo esc_attr($price_value); ?>"/>
										</div>
									</div>
									<div class="col-sm-6">
										<div class="job-manager-description">
											<label><?php esc_html_e('Description', 'findgo'); ?></label>
											<textarea cols="20" rows="3" class="input-text input-section-item-description" name="_job_menu_prices[<?php echo esc_attr($i); ?>][description][]"><?php echo trim($description_value); ?></textarea>
										</div>
									</div>
								</div>
							</div>
						<?php } ?>
					</div>
					<!-- end loop -->
					<a class="add-new-menu-price button button-primary" href="javascript:void(0);"><?php esc_html_e( 'Add New', 'findgo' ); ?></a>
					<a class="remove-menu-price button" href="javascript:void(0);"><?php esc_html_e( 'Remove', 'findgo' ); ?></a>
				</div>
				<?php
			$i++; }
		} else { ?>
			<div class="menu-prices-section-item">
				<div class="job-manager-section-title">
					<h4><?php esc_html_e('Section Title', 'findgo'); ?></h4>
					<input type="text" class="input-text input-section-title" name="_job_menu_prices[0][section_title]" value=""/>
				</div>
				<h4><?php esc_html_e('Section Items', 'findgo'); ?></h4>
				<div class="menu-prices-section-item-wrapper">
					<div class="menu-prices-item">
						<div class="row">
							<div class="col-sm-6">
								<div class="job-manager-title">
									<label><?php esc_html_e('Title', 'findgo'); ?></label>
									<input type="text" class="input-text input-section-item-title" name="_job_menu_prices[0][title][]" value=""/>
								</div>
								<div class="job-manager-price">
									<label><?php esc_html_e('Price', 'findgo'); ?></label>
									<input type="text" class="input-text input-section-item-price" name="_job_menu_prices[0][price][]" value=""/>
								</div>
							</div>
							<div class="col-sm-6">
								<div class="job-manager-description">
									<label><?php esc_html_e('Description', 'findgo'); ?></label>
									<textarea cols="20" rows="3" class="input-text input-section-item-description" name="_job_menu_prices[0][description][]"></textarea>
								</div>
							</div>
						</div>
					</div>
				</div>
				<a class="add-new-menu-price button button-primary" href="javascript:void(0);"><?php esc_html_e( 'Add New Menu', 'findgo' ); ?></a>
				<a class="remove-menu-price button" href="javascript:void(0);"><?php esc_html_e( 'Remove Menu', 'findgo' ); ?></a>
			</div>
		<?php } ?>
	</div>
	<a class="add-new-section-menu-price button button-primary" href="javascript:void(0);"><?php esc_html_e( 'Add New Section', 'findgo' ); ?></a>
	<a class="remove-section-menu-price button" href="javascript:void(0);"><?php esc_html_e( 'Remove Section', 'findgo' ); ?></a>
</div>