<?php
	$display_mode = findgo_get_listing_display_mode();
	$filter_order = isset($_COOKIE['findgo_order']) ? $_COOKIE['findgo_order'] : 'default';
?>
<div class="wrapper-filters clearfix">
<div class="col-xs-12">
<form class="job_filters job_filters-region">
	<input class="input_display_mode" type="hidden" name="display_mode" value="<?php echo trim($display_mode); ?>">
	<input class="input_filter_oder" type="hidden" name="filter_order" value="<?php echo trim($filter_order); ?>">
	<div class="filter-inner clearfix">
		<?php do_action( 'job_manager_job_filters_start', $atts ); ?>
		<div class="search_jobs">
			<?php do_action( 'job_manager_job_filters_search_jobs_start', $atts ); ?>

			<div class="row row-top">
				<div class="col-lg-4 col-md-6 col-sm-6 col-xs-12 <?php if ( !findgo_get_config('listing_filter_show_keyword', true) ) { ?> hidden <?php } ?>">
					<div class="search_keywords">
						<input type="text" name="search_keywords" id="search_keywords" placeholder="<?php esc_attr_e( 'Keywords', 'findgo' ); ?>" value="<?php echo esc_attr( $keywords ); ?>" />
					</div>
				</div>
				
				<?php if ( findgo_get_config('listing_filter_show_price', true) ) {
					$price_ranges = findgo_job_manager_price_range_icons();
					$price_range_default = isset( $_REQUEST['filter_price_range'] ) ? $_REQUEST['filter_price_range'] : array();
				?>
				<div class="col-lg-4 col-md-6 col-sm-6 col-xs-12">
					<div class="search_price_range clearfix">
						<div class="click-price clearfix">
							<span class="pull-left"><?php esc_html_e('Price', 'findgo'); ?></span>
							<span class="pull-right"><?php esc_html_e('$', 'findgo'); ?></span>
						</div>
						<ul class="list-price">
							<?php
								foreach ($price_ranges as $key => $label) {
									?>
									<li>
										<label for="filter_price_range_<?php echo esc_attr($key); ?>" data-placement="right" data-toggle="tooltip" title="<?php echo esc_attr($label['label']); ?>">
											<input id="filter_price_range_<?php echo esc_attr($key); ?>" type="checkbox" name="filter_price_range[]" value="<?php echo esc_attr($key); ?>" <?php echo trim(in_array($key, $price_range_default) ? 'checked="checked"' : ''); ?>> <?php echo esc_attr($label['icon']); ?>
										</label>
									</li>
									<br>
									<?php
								}
							?>
						</ul>
					</div>
				</div>
				<?php } ?>
				<?php if ( findgo_get_config('listing_filter_show_sortby', true) ) { ?>
					<?php
						$options = array(
							'default' => esc_html__( 'Default Order', 'findgo' ),
							'date-desc' => esc_html__( 'Newest First', 'findgo' ),
							'date-asc' => esc_html__( 'Oldest First', 'findgo' ),
							'rating-desc' => esc_html__( 'Highest Rating', 'findgo' ),
							'rating-asc' => esc_html__( 'Lowest Rating', 'findgo' ),
							'random' => esc_html__( 'Random', 'findgo' ),
						);
						$default = isset($_COOKIE['findgo_order']) ? $_COOKIE['findgo_order'] : findgo_get_config('listing_filter_sortby_default', 'default');
					?>
					<div class="col-lg-4 col-md-6 col-sm-6 col-xs-12">
						<div class="listing-orderby">
							<select name="filter_order" autocomplete="off">
								<?php foreach ( $options as $id => $option ) : ?>
									<option value="<?php echo esc_attr( $id ); ?>" <?php echo trim($id == $default ? 'selected="selected"' : ''); ?>><?php echo esc_html( $option ); ?></option>
								<?php endforeach; ?>
							</select>
						</div>
					</div>
				<?php } ?>
				<?php if ( findgo_get_config('listing_filter_show_regions', true) ) { ?>
					<?php
					$job_regions = get_terms( array( 'job_listing_region' ), array( 'hierarchical' => 1, 'hide_empty' => false  ) );
					if ( ! is_wp_error( $job_regions ) && ! empty ( $job_regions ) ) {

						$selected_region = '';
						//try to see if there is a search_categories (notice the plural form) GET param
						$search_regions = isset( $_REQUEST['job_region_select'] ) ? $_REQUEST['job_region_select'] : '';
						if ( ! empty( $search_regions ) && is_array( $search_regions ) ) {
							$search_regions = $search_regions[0];
						}
						$search_regions = sanitize_text_field( stripslashes( $search_regions ) );
						if ( ! empty( $search_regions ) ) {
							if ( is_numeric( $search_regions ) ) {
								$selected_region = intval( $search_regions );
							} else {
								$term = get_term_by( 'slug', $search_regions, 'job_listing_region' );
								$selected_region = $term->term_id;
							}
						} elseif (  ! empty( $atts['regions'] ) ) {
							$selected_region = intval( $atts['regions'] );
						}
						?>
						<div class="col-lg-4 col-md-6 col-sm-6 col-xs-12">
							<div class="select-regions">
								<select class="regions-select <?php echo ( is_rtl() ? 'chosen-rtl' : '' ); ?>" data-placeholder="<?php esc_attr_e( 'Filter by regions', 'findgo' ); ?>" name="job_region_select">
									<option value=""><?php esc_html_e( 'All regions', 'findgo' ); ?></option>
									<?php foreach ( $job_regions as $term ) : ?>
										<option value="<?php echo esc_attr($term->term_id); ?>" <?php echo ($term->term_id == $selected_region) ? 'selected="selected"' : ''; ?>><?php echo trim($term->name); ?></option>
									<?php endforeach; ?>
								</select>
							</div>
						</div>
					<?php } ?>
				<?php } ?>
				<?php if ( findgo_get_config('listing_filter_show_categories', true) ) { ?>
					<div class="col-lg-4 col-md-6 col-sm-6 col-xs-12">
						<div class="select-categories">
							<?php
							if ( $show_categories && get_terms( 'job_listing_category' ) ) :

								//select the current category
								$selected_category = '';
								if ( empty( $selected_category ) ) {
									//try to see if there is a search_categories (notice the plural form) GET param
									$search_categories = isset( $_REQUEST['search_categories'] ) ? $_REQUEST['search_categories'] : '';
									if ( ! empty( $search_categories ) && is_array( $search_categories ) ) {
										$search_categories = $search_categories[0];
									}
									$search_categories = sanitize_text_field( stripslashes( $search_categories ) );
									if ( ! empty( $search_categories ) ) {
										if ( is_numeric( $search_categories ) ) {
											$selected_category = intval( $search_categories );
										} else {
											$term = get_term_by( 'slug', $search_categories, 'job_listing_category' );
											$selected_category = $term->term_id;
										}
									} elseif (  ! empty( $categories ) ) {
										if ( is_array($categories) ) {
											$selected_category = intval( $categories[0] );
										} else {
											$selected_category = intval( $categories );
										}
									}
								} ?>

								<div class="search_categories">
									<?php job_manager_dropdown_categories( array(
										'taxonomy'        => 'job_listing_category',
			                            'hierarchical'    => 1,
			                            'show_option_all' => esc_html__( 'All categories', 'findgo' ),
			                            'placeholder' 	=> esc_html__( 'All Categories', 'findgo' ),
			                            'name'            => 'search_categories',
			                            'orderby'         => 'name',
			                            'selected'        => $selected_category,
			                            'multiple'        => false,
			                            'hide_empty' => false 
									) ); ?>
								</div>

							<?php endif; ?>
						</div><!-- .select-categories -->
					</div>
				<?php } ?>
			</div>
			<?php if ( findgo_get_config('listing_filter_show_tags', 'more-filter') ) { ?>
				<div class="search_tag_wrapper">
					<a href="javascript:void(0);" class="show-more-filter"><?php esc_html_e('More Filters', 'findgo'); ?>
						<?php if ( findgo_get_config('listing_filter_show_tags', 'more-filter') === 'more-filter' ) { ?>
							<i class="fa fa-plus"></i>
						<?php } else { ?>
							<i class="fa fa-minus"></i>
						<?php } ?>
					</a>
					<div class="tags-wrap <?php if ( findgo_get_config('listing_filter_show_tags', 'more-filter') !== 'more-filter' ) { ?>active<?php } ?>">
						<?php
							$job_tags = get_terms( array( 'job_listing_amenity' ), array( 'hierarchical' => 1, 'hide_empty' => false  ) );
							if ( !empty( $job_tags ) ) {
								$selected = '';
								if ( is_tax( 'job_listing_amenity' )  ) {
									global $wp_query;
									$term =	$wp_query->queried_object;
									$selected = $term->slug;
								} 
							?>
								<ul class="job_tags">
									<?php foreach ( $job_tags as $tag ) : ?>
										<li><label for="job_amenity_<?php echo esc_attr($tag->slug); ?>" class="<?php echo sanitize_title( $tag->name ); ?>"><input type="checkbox" name="filter_job_amenity[]" value="<?php echo trim($tag->slug); ?>" id="job_amenity_<?php echo esc_attr($tag->slug); ?>" <?php echo trim($selected == $tag->slug ? 'checked="checked"' : ''); ?> /> <?php echo trim($tag->name); ?></label></li>
									<?php endforeach; ?>
								</ul>
						<?php } ?>
					</div>
				</div>
			<?php } ?>

			<!-- tags -->
			<?php
				if ( is_tax( 'job_listing_tag' )  ) {
					global $wp_query;
					$term =	$wp_query->queried_object;
					?>
					<input type="hidden" name="filter_job_tag[]" value="<?php echo trim($term->slug); ?>" id="job_tag_<?php echo esc_attr($amenity->slug); ?>" />
			<?php } ?>
			<div class="listing-search-result-filter"></div>
			<?php do_action( 'job_manager_job_filters_search_jobs_end', $atts ); ?>
		</div>
		<div class="mobile-groups-button hidden-lg hidden-md">
			
			<button class="btn btn-show-filter btn-xs btn-theme" type="button"><i class="fa fa-sliders" aria-hidden="true"></i> <?php esc_html_e( 'Filter Listings', 'findgo' ); ?></button>
			<?php
			$layout = findgo_get_listing_archive_version();
			$layouts = findgo_get_listing_all_half_map_version();
			if( in_array($layout, $layouts)) { ?>
				<button class="pull-right btn btn-xs btn-second btn-view-map" type="button"><i class="fa fa-map-o" aria-hidden="true"></i> <?php esc_html_e( 'Map View', 'findgo' ); ?></button>
				<button class="pull-right btn btn-xs btn-second btn-view-listing hidden-sm hidden-xs" type="button"><i class="fa fa-list" aria-hidden="true"></i> <?php esc_html_e( 'Listing View', 'findgo' ); ?></button>
			<?php } ?>
		</div>
		<?php do_action( 'job_manager_job_filters_end', $atts ); ?>
	</div>
</form>
</div>
</div>
<?php do_action( 'job_manager_job_filters_after', $atts ); ?>

<noscript><?php esc_html_e( 'Your browser does not support JavaScript, or it is disabled. JavaScript must be enabled in order to view listings.', 'findgo' ); ?></noscript>