<?php
/**
 * The template for displaying the WP Job Manager frontend listing submission form
 *
 */

if ( ! defined( 'ABSPATH' ) ) exit;

global $job_manager;
?>
<div class="container">
		<form action="<?php echo esc_url( $action ); ?>" method="post" id="submit-job-form" class="job-manager-form" enctype="multipart/form-data">

			<?php do_action( 'submit_job_form_start' ); ?>
			
			<?php if ( apply_filters( 'submit_job_form_show_signin', true ) ) : ?>

				<?php get_job_manager_template( 'account-signin.php' ); ?>

			<?php endif; ?>

			<?php if ( job_manager_user_can_post_job() || job_manager_user_can_edit_job( $job_id ) ) : ?>

				<!-- Job Information Fields -->
				<?php do_action( 'submit_job_form_job_fields_start' );

				$all_fields = $job_fields;
				if ( $company_fields ) {
					$all_fields = $job_fields + $company_fields;
				}
				
				$all_sections = Findgo_Post_Type_Job_Listing::generate_sections($all_fields);
				

				if ( !empty($all_sections) ) {
					foreach ( $all_sections as $section_key => $section_fields ) {
						$all_fields = $section_fields;
						uasort( $all_fields, 'findgo_sort_array_by_priority' );
				?>
					<div class="section-wrapper box-user">
						<div class="content-inner">
							<?php
							$labels = Findgo_Post_Type_Job_Listing::section_labels();
							if ( !empty($labels[$section_key]) ) {
								?>
								<h3 class="section-title"><?php echo trim($labels[$section_key]); ?></h3>
								<?php
							}
							?>
							<div class="row">
							<?php $i = 0; foreach ( $all_fields as $key => $field ) :
								$add_class = 'col-xs-12';
								if ( $section_key == 'section-2' ) {
									$add_class = 'col-sm-6';
									if ( $i == 0 ) {
										?>
										<div class="clearfix">
										<div class="col-sm-6">
										<?php
									}
									if ( $i <= 3 ) {
										$add_class = '';
									}
								}
								if ( $section_key == 'section-7' ) {
									$add_class = 'col-sm-6';
								}
							?>
								<div class="<?php echo esc_attr($add_class); ?>">
									<fieldset class="fieldset-<?php echo esc_attr( $key ); ?>">
										<label for="<?php echo esc_attr( $key ); ?>">
											<?php
											if ( isset( $field['label'] ) ) {
												echo trim($field['label']);
											}
											echo apply_filters( 'submit_job_form_required_label', (isset($field['required'])&&$field['required']) ? ' <span class="text-red">*</span>' : ' ', $field );
											?>
										</label>
										<div class="field <?php echo ( isset($field['required']) && $field['required'] ) ? 'required-field' : ''; ?>">
											<?php
											if ( isset( $field['type'] ) ) {
												get_job_manager_template( 'form-fields/' . $field['type'] . '-field.php', array( 'key' => $key, 'field' => $field ) );
											} ?>
										</div>
									</fieldset>
								</div>
								<?php
								if ( $section_key == 'section-2' ) {
									if ( $i == 3 ) {
										?>
										</div>
										<div class="col-sm-6">
											<!-- image description here -->
											<?php $image = findgo_get_config('submit_listing_image');
											if ( !empty($image['url']) ) { ?>
												<div class="des-img">
										    		<img src="<?php echo esc_url($image['url']); ?>" />
										    	</div>
									    	<?php } ?>
										</div>
										</div>
										<?php
									}
								}

								$i++; endforeach; ?>
							</div>
						</div>
					</div>
				<?php }
				} ?>

				<?php do_action( 'submit_job_form_job_fields_end' ); ?>

				<!-- Company Information Fields -->
				<?php if ( $company_fields ) : ?>
					<?php do_action( 'submit_job_form_company_fields_start' ); ?>
					<?php do_action( 'submit_job_form_company_fields_end' ); ?>
				<?php endif; ?>

				<?php do_action( 'submit_job_form_end' ); ?>
				
				<p class="clearfix">
					<input type="hidden" name="job_manager_form" value="<?php echo trim($form); ?>" />
					<input type="hidden" name="job_id" value="<?php echo esc_attr( $job_id ); ?>" />
					<input type="hidden" name="step" value="<?php echo esc_attr( $step ); ?>" />
					<input type="submit" name="submit_job" class="button btn-submit pull-right" value="<?php echo esc_html__('Save & Preview','findgo'); ?>" />
				</p>

			<?php else : ?>

				<?php do_action( 'submit_job_form_disabled' ); ?>

			<?php endif; ?>
		</form>
</div>