<?php
global $post;
$total_rating = findgo_get_total_rating( $job->ID );
$comments = findgo_get_total_reviews( $job->ID );
$phone = get_post_meta( $job->ID, '_company_phone', true);
?>
<div class="my-listing-item-wrapper job-list-style job_listing ">
	<div class="wrapper-list">
		<?php $img_src = findgo_get_post_image_src($job->ID, 'findgo-card-image');
		if ($img_src) {
		?>
			<div class="listing-image">
				<div class="listing-image-inner">
					<?php findgo_display_listing_image('findgo-image-list', true, $job); ?>
				</div>
			</div>
		<?php } ?>
		<div class="bottom-grid">
			<div class="bottom-grid-inner">
				<div class="listing-content">
					<h3 class="listing-title">
						<?php if ( $job->post_status == 'publish' ) : ?>
							<a href="<?php echo get_permalink( $job->ID ); ?>"><?php echo trim($job->post_title); ?></a>
						<?php else : ?>
							<?php echo trim($job->post_title); ?> <small>(<?php the_job_status( $job ); ?>)</small>
						<?php endif; ?>
					</h3>
					<?php the_company_tagline( '<div class="listing-tagline">', '</div>', true, $job ); ?>
					<div class="listing-tags">
						<div class="quick-view">
							<a href="#preview-<?php echo esc_attr($job->ID); ?>" class="listing-preview" data-id="<?php echo esc_attr($job->ID); ?>"><i class="flaticon-visible"></i><span class="preview-text"><?php esc_html_e('Preview', 'findgo'); ?></span></a>
						</div>
					</div>
				</div>
				<div class="listing-content-bottom clearfix">
					<div class="pull-left">
						<?php findgo_display_city_country($job->ID); ?>
					</div>
					<?php if ( ! empty( $phone ) ) { ?>
						<div class="listing-phone pull-left">
							<i class="flaticon-phone-call"></i>
							<?php echo trim($phone); ?>
						</div>
					<?php } ?>
				</div>
			</div>
		</div>
	</div>			
</div>