<?php


if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
global $post;
$rating = intval( get_comment_meta( $comment->comment_ID, '_apus_rating', true ) );
$listing = get_post($comment->comment_post_ID);
?>
<li itemprop="review" class="review" itemscope itemtype="http://schema.org/Review" <?php comment_class(); ?>>

	<div class="the-comment">
		<div class="comment-box">
			<div class="comment-heading">
				<div class="clearfix">
				<h3 class="title-job"><span class="title-slogan"><?php esc_html_e('Your review on', 'findgo'); ?></span> <a href="<?php echo esc_url(get_permalink($listing)); ?>"><?php echo esc_attr($listing->post_title); ?></a></h3>
				<div itemprop="reviewRating" itemscope itemtype="http://schema.org/Rating" class="star-rating" title="<?php echo sprintf(esc_attr__( 'Rated %d out of 5', 'findgo' ), $rating ) ?>">
						<?php findgo_print_review($rating); ?>
					</div>
				</div>
				<div class="info-meta">
					<?php if ( $comment->comment_approved == '0' ) : ?>
						<span class="meta"><em><?php esc_html_e( 'Your comment is awaiting approval', 'findgo' ); ?></em></span>
					<?php else : ?>
						<span class="meta">
							<time itemprop="datePublished" datetime="<?php echo get_comment_date( 'c' ); ?>"><?php echo get_comment_date( 'd M, Y' ); ?></time>
						</span>
					<?php endif; ?>
				</div>
			</div>
			<div class="description"><?php echo findgo_substring( get_comment_text(), 35, '...' ); ?></div>
		</div>
	</div>
</li>