<?php
$user = (isset($_GET['author_name'])) ? get_user_by('slug', $author_name) : get_userdata(intval($author));
$data = get_userdata( $user->ID );

$birthday = get_the_author_meta( 'apus_birthday', $user->ID );
$sex = get_the_author_meta( 'apus_sex', $user->ID );
$marital_status = get_the_author_meta( 'apus_marital_status', $user->ID );
$phone = !empty($data->phone) ? $data->phone : '';
$email = !empty($data->user_email) ? $data->user_email : '';
$address = get_the_author_meta( 'apus_address', $user->ID );
$url = !empty($data->url) ? $data->url : '';
?>
<div class="user-profile">
	<?php if ( !empty($data->description) ) { ?>
		<div class="box-inner">
			<h3 class="box-title"><?php esc_html_e( 'About me', 'findgo' ); ?></h3>
			<div class="box-content"><?php echo esc_html($data->description); ?></div>
		</div>
	<?php } ?>
	<div class="box-inner">
		<h3 class="box-title"><?php esc_html_e( 'Basic Info', 'findgo' ); ?></h3>
		<div class="box-content">
			<ul class="list-information">
				<li><label><?php esc_html_e( 'Name', 'findgo' ); ?></label> <span><?php echo trim($data->display_name); ?></span></li>
				<?php if ( !empty($birthday) ) { ?>
					<li><label><?php esc_html_e( 'Birthday', 'findgo' ); ?></label> <span><?php echo esc_attr($birthday); ?></span></li>
				<?php } ?>
				<?php
				$sexs = findgo_sex_defaults();
				if ( !empty($sex) && !empty($sexs[$sex])) { ?>
					<li><label><?php esc_html_e( 'Sex', 'findgo' ); ?></label> <span><?php echo esc_attr($sexs[$sex]); ?></span></li>
				<?php } ?>
				<?php
				$maritals = findgo_marital_status_defaults();
				if ( !empty($marital_status) && !empty($maritals[$marital_status]) ) { ?>
					<li><label><?php esc_html_e( 'Marital status', 'findgo' ); ?></label> <span><?php echo esc_attr($maritals[$marital_status]); ?></span></li>
				<?php } ?>
			</ul>
		</div>
	</div>
	<div class="box-inner">
		<?php if ( !empty($phone) || !empty($email) || !empty($address) || !empty($url) ) { ?>
			<h3 class="box-title"><?php esc_html_e( 'Contact', 'findgo' ); ?></h3>
			<div class="box-content">
				<ul class="list-information">
					<?php if ( !empty($phone) ) { ?>
						<li><label><?php esc_html_e( 'Phone', 'findgo' ); ?></label> <span><?php echo esc_attr($phone); ?></span></li>
					<?php } ?>
					<?php if ( !empty($email) ) { ?>
						<li><label><?php esc_html_e( 'Email', 'findgo' ); ?></label> <span><?php echo esc_attr($email); ?></span></li>
					<?php } ?>
					<?php if ( !empty($address) ) { ?>
						<li><label><?php esc_html_e( 'Address', 'findgo' ); ?></label> <span><?php echo esc_attr($address); ?></span></li>
					<?php } ?>
					<?php if ( !empty($url) ) { ?>
						<li><label><?php esc_html_e( 'Website', 'findgo' ); ?></label> <span><?php echo esc_attr($url); ?></span></li>
					<?php } ?>
				</ul>
			</div>
		<?php } ?>
		<ul class="spcials">
		<?php
			$options = findgo_user_social_defaults();
			$socials = get_user_meta( $user->ID, 'apus_socials', true );
			foreach ($options as $key => $label) {
				$value = isset($socials[$key]) ? $socials[$key] : '';
				if ( $value ) {
					?>
					<li><a href="<?php echo esc_url($value); ?>" class="<?php echo esc_attr($key); ?>" title="<?php echo esc_attr($label); ?>"><i class="fa fa-<?php echo esc_attr($key); ?>"></i></a></li>
					<?php
				}
			}
		?>
		</ul>
	</div>
</div>