<?php
global $post;

$data_output = '';
$terms = get_the_terms(get_the_ID(), 'job_listing_category');
$termString = '';
if ( ! empty( $terms ) && ! is_wp_error( $terms ) ) {
	$firstTerm = $terms[0];
	if ( ! $firstTerm == NULL ) {
		$term_id = $firstTerm->term_id;

		$data_output .= 'data-icon="' . findgo_get_term_icon_url($term_id) .'"';
		$count = 1;
		foreach ( $terms as $term ) {
			$termString .= $term->name;
			if ( $count != count($terms) ) {
				$termString .= ', ';
			}
			$count++;
		}
	}
}
$lat = get_post_meta($post->ID, 'geolocation_lat', true);
$lng = get_post_meta($post->ID, 'geolocation_long', true);
?>
<div class="apus-single-listing" 
	data-latitude="<?php echo esc_attr($lat); ?>"
	data-longitude="<?php echo esc_attr($lng); ?>"
	data-categories="<?php echo esc_attr($termString); ?>"
	<?php echo trim($data_output); ?>>
	<meta itemprop="title" content="<?php echo esc_attr( $post->post_title ); ?>" />
	<?php if (has_post_thumbnail()) { ?>
        <meta property="og:image" content="<?php echo esc_url(get_the_post_thumbnail_url($post)); ?>"/>
    <?php } ?>
	<?php findgo_display_hidden_category_icon($terms); ?>
	
	<?php if ( get_option( 'job_manager_hide_expired_content', 1 ) && 'expired' === $post->post_status ) : ?>
		<div class="job-manager-info"><?php esc_html_e( 'This listing has expired.', 'findgo' ); ?></div>
	<?php else : ?>
		<div class="row">
			<?php
			$listing_sidebar = findgo_get_config('listing_single_layout');
			$class = '';
			$sidebar_class = 'sidebar-right';
			if ( $listing_sidebar == 'right-main' ) {
				$class = '';
				$sidebar_class = 'sidebar-right';
			} elseif ( $listing_sidebar == 'left-main' ) {
				$class = 'pull-right';
				$sidebar_class = 'sidebar-left';
			}
			?>
			<div class="col-md-8 column-content entry-content <?php echo esc_attr($class); ?>">
				<div class="listing-main-content">
					<?php
					if ( !empty($block_contents) ) {
						foreach ($block_contents as $key => $content) {
							echo trim($content);
						}
					}
					?>
				</div>
			</div>
			<div class="col-md-4">
				<div class="sidebar sidebar-detail-job <?php echo esc_attr($sidebar_class); ?>">
					<div class="close-sidebar-btn hidden-lg hidden-md"> <i class="fa fa-close"></i> <span><?php esc_html_e('Close', 'findgo'); ?></span></div>
					<?php
					$contents = findgo_get_sidebar_content_sort();
					foreach ($contents as $content => $title) {
						echo trim(findgo_listing_display_part($content));
					}
					?>
					<?php $sidebar = findgo_get_config('listing_single_sidebar');
					if ( !empty($sidebar) && is_active_sidebar( $sidebar ) ) : ?>
						<div class="widget-area" role="complementary">
							<?php dynamic_sidebar( $sidebar ); ?>
						</div><!-- .widget-area -->
					<?php endif; ?>
				</div>
			</div>
		</div>
	<?php endif; ?>
</div>