<?php
$terms = get_the_terms(get_the_ID(), 'job_listing_amenity');

if ( ! is_wp_error( $terms ) && ( is_array( $terms ) || is_object( $terms ) ) ):
?>
	<div id="listing-amenities" class="listing-amenities widget">
		<h3 class="widget-title"><span><?php esc_html_e( 'Amenities', 'findgo' ); ?></span></h3>
		<div class="box-inner">
			<ul class="listing-amenity-list">
				<?php foreach ( $terms as $term ) {
					$icon_image = $icon_font = '';
					if ( class_exists('Taxonomy_MetaData_CMB2') ) {
						$icon_image = Taxonomy_MetaData_CMB2::get( 'job_listing_amenity', $term->term_id, 'icon_image' );
						$icon_font = Taxonomy_MetaData_CMB2::get( 'job_listing_amenity', $term->term_id, 'icon_font' );
					}
				?>
					<li>
						<a href="<?php echo esc_url(get_term_link($term->term_id, 'job_listing_amenity')); ?>">
							<span class="amenity-icon">
								<?php if (!empty($icon_image)) { ?>
									<img src="<?php echo esc_url_raw($icon_image); ?>">
								<?php } elseif(!empty($icon_font)) { ?>
									<i class="<?php echo esc_attr($icon_font); ?>"></i>
								<?php } ?>
							</span>
							<span class="amenity-title"><?php echo trim($term->name); ?></span>
						</a>
					</li>
				<?php } ?>
			</ul>
		</div>
	</div>
<?php endif; ?>