<?php

$hours = get_post_meta( get_the_ID(), '_job_hours', true );
$days = findgo_get_day_hours($hours);
if ( ! empty ( $days ) ) :
	$current = findgo_get_current_time();
?>
	<div id="listing-hours" class="listing-hours widget">
		<h3 class="widget-title">
			<?php esc_html_e( 'Opening Hours', 'findgo' ); ?>
			<?php foreach ($days as $day => $time) { ?>
				<?php if ( strtolower($current['day']) === strtolower($day) ) { ?>
					<div class="pull-right">
						<?php findgo_display_time_status(); ?>
					</div>
				<?php } ?>
			<?php } ?>
		</h3>
		<div class="listing-hours-inner box-inner">
			<?php foreach ($days as $day => $time) { ?>
				<div class="listing-day <?php if ( strtolower($current['day']) === strtolower($day) ) { ?>current<?php } ?>">
					<span class="day"><?php echo trim($day); ?></span>
					<div class="bottom-inner">
						<span class="start"><?php echo trim($time[0]); ?></span>
						<?php if ($time[1]) { ?>
							<span class="end"><?php echo trim($time[1]); ?></span>
						<?php } ?>
					</div>
				</div>
			<?php } ?>
		</div>
	</div>
<?php endif; ?>