<?php
global $post;
?>
<div id="listing-maps" class="listing-map">
	<h3 class="widget-title"><span><?php esc_html_e('Location', 'findgo'); ?></span></h3>
	<div class="box-inner p-relative">
		<div class="top-nav">
			<a href="#maps" class="direction-map top-nav-map active"><i class="fa fa-map-o"></i> <?php esc_html_e('Map', 'findgo'); ?></a>
			<a href="#maps-street" class="direction-map top-nav-street-view"><i class="fa fa-street-view"></i> <?php esc_html_e('Street View', 'findgo'); ?></a>
			<?php
				$location = get_the_job_location( $post );
				if ( $location ) {
					?>
					<a class="map-direction direction-map" href="<?php echo esc_url( 'http://maps.google.com/maps?q=' . urlencode( strip_tags( $location ) ) . '&zoom=14&size=512x512&maptype=roadmap&sensor=false' ) ; ?>" target="_blank">
						<i class="fa fa-hand-o-right"></i>
						<?php esc_html_e('Get Directions', 'findgo'); ?>
					</a>
					<?php
				}
			?>
		</div>
		<div id="apus-listing-map" class="apus-single-listing-map"></div>
		<div id="apus-listing-map-street-view" class="apus-single-listing-map-street-view"></div>
	</div>
</div>