<?php
	global $post;
	$terms = get_the_terms( get_the_ID(), 'job_listing_category' );
    $term = '';
    if ( ! empty( $terms ) && ! is_wp_error( $terms ) ){
    	$term = $terms[0];
    }
    
	if ( !empty($term)) :

		$lat = get_post_meta(get_the_ID(), 'geolocation_lat', true);
		$lng = get_post_meta(get_the_ID(), 'geolocation_long', true);
		$location = get_the_job_location( $post );
		$link = findgo_get_listings_page_url();
		
		$link = add_query_arg( 'search_lat', $lat, remove_query_arg( 'search_lat', $link ) );
		$link = add_query_arg( 'search_lng', $lng, remove_query_arg( 'search_lng', $link ) );
		$link = add_query_arg( 'search_distance', 50, remove_query_arg( 'search_distance', $link ) );
		$link = add_query_arg( 'use_search_distance', 'on', remove_query_arg( 'use_search_distance', $link ) );
		$link = add_query_arg( 'search_categories[]', $term->term_id, remove_query_arg( 'search_categories[]', $link ) );
		$link = add_query_arg( 'search_location', strip_tags($location), remove_query_arg( 'search_location', $link ) );

		?>
		<div class="widget nearby">
			<h3 class="widget-title"><?php echo sprintf(__('Other %s nearby', 'findgo'), $term->name); ?></h3>
			<div class="box-inner">
				<span><?php echo sprintf(__('Find more %s near', 'findgo'), $term->name); ?></span>
				<a href="<?php echo esc_url($link); ?>"><strong><?php the_title(); ?></strong></a>
			</div>
		</div>
	<?php
	endif;
?>