<?php

global $post;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

if ( ! comments_open() ) {
	return;
}
$total_rating = findgo_get_total_rating( get_the_ID() );
$comment_ratings = findgo_get_detail_ratings( get_the_ID() );
$total = findgo_get_total_reviews( get_the_ID() );
?>
<div id="reviews">
	<div class="course-rating clearfix hidden">
		<h3 class="widget-title"><span><?php esc_html_e( 'Reviews', 'findgo' ); ?></span></h3>
		<div class="box-inner">
			<div class="average-rating pull-left">
				<div class="rating-box">
					<div class="average-value"><?php echo number_format((float)$total_rating, 1, '.', ''); ?></div>
					<div class="review-star">
						<?php findgo_print_review( $total_rating ); ?>
					</div>
					<div class="review-amount">
						<?php $total ? printf( _n( '%1$s rating', '%1$s ratings', $total, 'findgo' ), number_format_i18n( $total ) ) : esc_html_e( '0 rating', 'findgo' ); ?>
					</div>
				</div>
			</div>
			<div class="detailed-rating">
				<div class="rating-box">
					<div class="detailed-rating-inner">
						<?php for ( $i = 5; $i >= 1; $i -- ) : ?>
							<div class="skill">
								<div class="key"><?php printf( esc_html__( '%s stars', 'findgo' ), $i ); ?></div>
								<div class="progress">
									<div class="progress-bar progress-bar-success" style="<?php echo ( $total && !empty( $comment_ratings[$i]->quantity ) ) ? esc_attr( 'width: ' . ( $comment_ratings[$i]->quantity / $total * 100 ) . '%' ) : 'width: 0%'; ?>">
									</div>
								</div>
								<div class="value"><?php echo empty( $comment_ratings[$i]->quantity ) ? '0' : esc_html( $comment_ratings[$i]->quantity ); ?></div>
							</div>
						<?php endfor; ?>
					</div>
				</div>
			</div>
		</div>
	</div>

	<div id="comments">
		<?php if ( have_comments() ) : ?>
			<?php if ( is_user_logged_in() ) { ?>
				<div class="report-comment-form-hidden hidden">
					<form method="post" action="" class="apus-report-comment-form">
						<input class="report_comment_id" required type="hidden" name="comment_id" value="">
					    <div class="title"><?php esc_html_e('Please briefly explain why you feel this comment should be removed.', 'findgo'); ?></div>
					    <div class="msg"></div>
					    <?php wp_nonce_field('ajax-report-comment-nonce', 'report-comment-security'); ?>
					    <div class="form-group">
					        <textarea required class="report_msg" name="report_msg" cols="60" rows="5"></textarea>
					    </div>
					    <div class="description"><?php esc_html_e('We will NOT remove negative comments unless they are abusive or offensive. Once a comment has been reported it cannot be retracted and will be sent to moderators for review.', 'findgo'); ?></div>

					    <button class="button btn btn-default cancel-report btn-xs radius-3x" type="button" name="cancel-report"><?php echo esc_html__( 'Cancel', 'findgo' ); ?></button>
					    <button class="button btn btn-theme submit-report btn-xs radius-3x" type="submit" name="submit-report"><?php echo esc_html__( 'Report', 'findgo' ); ?></button>
					</form>
				</div>
			<?php } ?>
			<ol class="comment-list">
				<?php wp_list_comments( array( 'callback' => 'findgo_listing_comments' ) ); ?>
			</ol>

			<?php if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) :
				echo '<nav class="apus-pagination">';
				paginate_comments_links( apply_filters( 'apus_comment_pagination_args', array(
					'prev_text' => '&larr;',
					'next_text' => '&rarr;',
					'type'      => 'list',
				) ) );
				echo '</nav>';
			endif; ?>

		<?php else : ?>

			<p class="apus-noreviews text-danger"><?php esc_html_e( 'There are no reviews yet.', 'findgo' ); ?></p>

		<?php endif; ?>
	</div>
	<?php $commenter = wp_get_current_commenter(); ?>
	<div id="review_form_wrapper" class="commentform">
		<div class="reply_comment_form hidden">
			<?php
				$comment_form = array(
					'title_reply'          => esc_html__( 'Reply comment', 'findgo' ),
					'title_reply_to'       => esc_html__( 'Leave a Reply to %s', 'findgo' ),
					'comment_notes_before' => '',
					'comment_notes_after'  => '',
					'fields'               => array(
						'author' => '<div class="row"><div class="col-xs-12 col-sm-12"><div class="form-group"><label>'.esc_html__( 'Name', 'findgo' ).'</label>'.
						            '<input id="author" class="form-control" placeholder="'.esc_attr__( 'Your Name', 'findgo' ).'" name="author" type="text" value="' . esc_attr( $commenter['comment_author'] ) . '" size="30" aria-required="true" /></div></div>',
						'email'  => '<div class="col-xs-12 col-sm-12"><div class="form-group"><label>'.esc_html__( 'Email', 'findgo' ).'</label>' .
						            '<input id="email" placeholder="'.esc_attr__( 'your@mail.com', 'findgo' ).'" class="form-control" name="email" type="text" value="' . esc_attr(  $commenter['comment_author_email'] ) . '" size="30" aria-required="true" /></div></div>',
						            'url' => '<div class="col-xs-12 col-sm-12"><div class="form-group"><label>'.esc_html__( 'Website', 'findgo' ).'</label>
                                            <input id="url" name="url" placeholder="'.esc_attr__( 'Your Website', 'findgo' ).'" class="form-control" type="text" value="' . esc_attr( $commenter['comment_author_url'] ) . '"  />
                                       	</div></div></div>',
					),
					'label_submit'  => esc_html__( 'Submit', 'findgo' ),
					'logged_in_as'  => '',
					'comment_field' => ''
				);

				$comment_form['comment_field'] .= '<div class="form-group"><textarea placeholder="'.esc_attr__( 'Write Comment', 'findgo' ).'" id="comment" class="form-control" name="comment" cols="45" rows="5" aria-required="true" placeholder="'.esc_attr__( 'Write Comment', 'findgo' ).'"></textarea></div>';
				
				$comment_form['must_log_in'] = '<p class="must-log-in">' .  __( 'You must be <a href="">logged in</a> to post a review.', 'findgo' ) . '</p>';
				
				findgo_comment_form($comment_form);
			?>
		</div>
		<div id="review_form">
			<?php
				$comment_form = array(
					'title_reply'          => have_comments() ? esc_html__( 'Add a review', 'findgo' ) : sprintf( esc_html__( 'Be the first to review &ldquo;%s&rdquo;', 'findgo' ), get_the_title() ),
					'title_reply_to'       => esc_html__( 'Leave a Reply to %s', 'findgo' ),
					'comment_notes_before' => '',
					'comment_notes_after'  => '',
					'fields'               => array(
						'author' => '<div class="row"><div class="col-xs-12 col-sm-12"><div class="form-group"><label>'.esc_html__( 'Name', 'findgo' ).'</label>'.
						            '<input id="author" placeholder="'.esc_attr__( 'Your Name', 'findgo' ).'" class="form-control" name="author" type="text" value="' . esc_attr( $commenter['comment_author'] ) . '" size="30" aria-required="true" /></div></div>',
						'email'  => '<div class="col-xs-12 col-sm-12"><div class="form-group"><label>'.esc_html__( 'Email', 'findgo' ).'</label>' .
						            '<input id="email" placeholder="'.esc_attr__( 'your@mail.com', 'findgo' ).'" class="form-control" name="email" type="text" value="' . esc_attr(  $commenter['comment_author_email'] ) . '" size="30" aria-required="true" /></div></div>',
						            'url' => '<div class="col-xs-12 col-sm-12"><div class="form-group"><label>'.esc_html__( 'Website', 'findgo' ).'</label>
                                            <input id="url" placeholder="'.esc_attr__( 'Your Website', 'findgo' ).'" name="url" class="form-control" type="text" value="' . esc_attr( $commenter['comment_author_url'] ) . '"  />
                                       	</div></div></div>',
					),
					'label_submit'  => esc_html__( 'Submit Review', 'findgo' ),
					'logged_in_as'  => '',
					'comment_field' => ''
				);

				
				$comment_form['must_log_in'] = '<div class="must-log-in">' .  __( 'You must be <a href="">logged in</a> to post a review.', 'findgo' ) . '</div>';
				

				$comment_form['comment_field'] = '<div class="choose-rating clearfix"><div class="choose-rating-inner row">'.
					(findgo_get_config('listing_review_enable_upload_photos', true) ? '
						<div class="col-sm-6 col-xs-12"><div class="form-group group-upload">
		                	<input class="hidden" id="field_attachments" name="attachments[]" type="file" multiple="multiple" accept="image/jpg,image/png,image/jpeg,image/gif" />
							<button type="button" id="field_attachments_cover"><span class="title-upload">'.esc_html__('Upload Photos', 'findgo').'</span>
							<img src="'.get_template_directory_uri().'/images/upload.png'.'"> </button>
		                </div></div>' : '').'

					<div class="col-sm-6 col-xs-12"><div class="form-group yourview"><div class="your-rating">' . esc_html__( 'Your Rating for this listing', 'findgo' ) . '</div><div class="comment-form-rating"><label for="rating">' . esc_html__( 'Your Rating', 'findgo' ) .'</label>
						<ul class="review-stars">
							<li><span class="fa fa-star-o"></span></li>
							<li><span class="fa fa-star-o"></span></li>
							<li><span class="fa fa-star-o"></span></li>
							<li><span class="fa fa-star-o"></span></li>
							<li><span class="fa fa-star-o"></span></li>
						</ul>
						<ul class="review-stars filled">
							<li data-title="'.esc_attr__('Terrible', 'findgo').'"><span class="fa fa-star"></span></li>
							<li data-title="'.esc_attr__('Poor', 'findgo').'"><span class="fa fa-star"></span></li>
							<li data-title="'.esc_attr__('Average', 'findgo').'"><span class="fa fa-star"></span></li>
							<li data-title="'.esc_attr__('Very Good', 'findgo').'"><span class="fa fa-star"></span></li>
							<li data-title="'.esc_attr__('Excellent', 'findgo').'"><span class="fa fa-star"></span></li>
						</ul>
						<span class="review-label">'.esc_html__('Choose to rate', 'findgo').'</span>
						<input type="hidden" value="5" name="rating" id="apus_input_rating"></div></div></div></div></div><div class="group-upload-preview clearfix"></div>
						' ;
				

				$comment_form['comment_field'] .= '<div class="form-group"><label>'.esc_html__( 'Review', 'findgo' ).'</label><textarea id="comment" class="form-control" placeholder="'.esc_attr__( 'Write Comment', 'findgo' ).'" name="comment" cols="45" rows="5" aria-required="true"></textarea></div>';
				
				findgo_comment_form($comment_form);
			?>
		</div>
	</div>
</div>