(function ($) {
    "use strict";

	var findgo_upload;
	var findgo_selector;

	function findgo_add_file(event, selector) {

		var upload = $(".uploaded-file"), frame;
		var $el = $(this);
		findgo_selector = selector;

		event.preventDefault();

		// If the media frame already exists, reopen it.
		if ( findgo_upload ) {
			findgo_upload.open();
		} else {
			// Create the media frame.
			findgo_upload = wp.media.frames.findgo_upload =  wp.media({
				// Set the title of the modal.
				title: "Select Image",

				// Customize the submit button.
				button: {
					// Set the text of the button.
					text: "Selected",
					// Tell the button not to close the modal, since we're
					// going to refresh the page when the image is selected.
					close: false
				}
			});

			// When an image is selected, run a callback.
			findgo_upload.on( 'select', function() {
				// Grab the selected attachment.
				var attachment = findgo_upload.state().get('selection').first();
				findgo_upload.close();
				findgo_selector.find('.upload_image').val(attachment.attributes.id).change();
				if ( attachment.attributes.type == 'image' ) {
					findgo_selector.find('.screenshot-user').empty().hide().prepend('<img src="' + attachment.attributes.url + '">').slideDown('fast');
				}
			});

		}
		// Finally, open the modal.
		findgo_upload.open();
	}

	function findgo_remove_file(selector) {
		selector.find('.screenshot-user').slideUp('fast').next().val('').trigger('change');
	}
	
	$('.upload_image_action .user-remove-image').on( 'click', function(event) {
		findgo_remove_file( $(this).parent().parent() );
	});

	$('.upload_image_action .user-add-image').on('click', function(event) {

		findgo_add_file(event, $(this).parent().parent());
	});

})(jQuery);