<?php
$thumbsize = !isset($thumbsize) ? findgo_get_blog_thumbsize() : $thumbsize;
$categories = get_the_category();
$thumb = findgo_display_post_thumb($thumbsize);
?>
<article <?php post_class('post grid-carousel2'); ?>>
    <div class="top-info <?php echo !empty($thumb) ? 'has-thumb' : 'no-thumb'; ?>">
        <?php
            echo trim($thumb);
        ?>
        <div class="categories">
            <?php 
                if ( ! empty( $categories ) ) {
                    echo esc_html( $categories[0]->name );   
                }
            ?>
        </div>
    </div>
    <div class="entry-content <?php echo !empty($thumb) ? 'has-thumb' : 'no-thumb'; ?>">
        <div class="date"><?php the_time( get_option('date_format', 'd M, Y') ); ?></div>
        <?php if (get_the_title()) { ?>
            <h4 class="entry-title">
                <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
            </h4>
        <?php } ?>
    </div>
</article>