<?php
$thumbsize = !isset($thumbsize) ? findgo_get_blog_thumbsize() : $thumbsize;
$categories = get_the_category();
$thumb = findgo_display_post_thumb($thumbsize);
$post_format = get_post_format();
?>
<article <?php post_class('post grid-carousel2 post-grid'); ?>>
    <div class="top-info <?php echo (!empty($thumb) && $post_format != 'audio' && $post_format != 'video' ) ? 'has-thumb' : 'no-thumb'; ?>">
        <?php
            echo trim($thumb);
        ?>
        <?php if ( ! empty( $categories ) ) { ?>
            <div class="categories">
                <?php echo esc_html( $categories[0]->name ); ?>
            </div>
        <?php } ?>
    </div>
    <div class="entry-content <?php echo !empty($thumb) ? 'has-thumb' : 'no-thumb'; ?>">
        <div class="date"><?php the_time( get_option('date_format', 'd M, Y') ); ?></div>
        <?php if (get_the_title()) { ?>
            <h3 class="entry-title">
                <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
            </h3>
        <?php } ?>
        <?php if ( has_excerpt() ) { ?>
            <div class="description"><?php echo findgo_substring( get_the_excerpt(), 25, '...' ); ?></div>
            <div class="clear-read"> <a class="readmore" href="<?php the_permalink(); ?>"><?php esc_html_e('Read More', 'findgo'); ?></a></div>
        <?php } else { ?>
            <div class="description"><?php echo findgo_substring( get_the_content(), 25, '...' ); ?></div>
            <div class="clear-read"><a class="readmore" href="<?php the_permalink(); ?>"><?php esc_html_e('Read More', 'findgo'); ?></a></div>
        <?php } ?>
    </div>
</article>