<?php
$post_format = get_post_format();
global $post;
?>
<article id="post-<?php the_ID(); ?>" <?php post_class('post-detail'); ?>>
    <div class="entry-content-detail <?php echo  (!has_post_thumbnail() ? '' : 'has-thumb'); ?>">
        <div class="info-top clearfix">
            <div class="right-top pull-right">
                <div class="categories">
                    <?php the_category(',  ') ?>
                </div>
            </div>
            <div class="lef-top">
                <div class="date"><?php the_time( get_option('date_format', 'd M, Y') ); ?></div>
                <?php if (get_the_title()) { ?>
                    <h1 class="entry-title">
                        <?php the_title(); ?>
                    </h1>
                <?php } ?>
            </div>
        </div>
        <?php if ( $post_format == 'gallery' ) {
            $gallery = findgo_post_gallery( get_the_content(), array( 'size' => 'full' ) );
        ?>
            <div class="entry-thumb <?php echo  (empty($gallery) ? 'no-thumb' : ''); ?>">
                <?php echo trim($gallery); ?>
            </div>
        <?php } elseif( $post_format == 'link' ) {
                $format = findgo_post_format_link_helper( get_the_content(), get_the_title() );
                $title = $format['title'];
                $link = findgo_get_link_attributes( $title );
                $thumb = findgo_post_thumbnail('', $link);
                echo trim($thumb);
            } else { ?>
            <div class="entry-thumb">
                <?php
                    $thumb = findgo_post_thumbnail();
                    echo trim($thumb);
                ?>
            </div>
        <?php } ?>
    </div>
    <div class="wrapper-small">
        <div class="entry-description">
            <?php
                if ( $post_format == 'gallery' ) {
                    $gallery_filter = findgo_gallery_from_content( get_the_content() );
                    echo trim($gallery_filter['filtered_content']);
                } else {
                    the_content();
                }
            ?>
        </div><!-- /entry-content -->
        <?php
        wp_link_pages( array(
            'before'      => '<div class="page-links"><span class="page-links-title">' . esc_html__( 'Pages:', 'findgo' ) . '</span>',
            'after'       => '</div>',
            'link_before' => '<span>',
            'link_after'  => '</span>',
            'pagelink'    => '<span class="screen-reader-text">' . esc_html__( 'Page', 'findgo' ) . ' </span>%',
            'separator'   => '',
        ) );
        ?>
        <div class="tag-social clearfix">
            <?php findgo_post_tags(); ?>
            <?php if( findgo_get_config('show_blog_social_share', false) ) {
                get_template_part( 'template-parts/sharebox' );
            } ?>
        </div>
        <?php
            //Previous/next post navigation.
            the_post_navigation( array(
                'next_text' => '<span class="meta-nav" aria-hidden="true">' . esc_html__( 'Next', 'findgo' ) . '</span> ' .
                    '<span class="pull-right navi">' . esc_html__( 'Next post', 'findgo' ) . '<i class="fa fa-angle-right"></i> </span> ' .
                    '<span class="post-title">%title</span>',
                'prev_text' => '<span class="meta-nav" aria-hidden="true">' . esc_html__( 'Previous', 'findgo' ) . '</span> ' .
                    '<span class="pull-left navi"> <i class="fa fa-angle-left"></i>' . esc_html__( 'Previous post', 'findgo' ) . '</span> ' .
                    '<span class="post-title">%title</span>',
            ) );

            if ( findgo_get_config('show_blog_releated', true) ): ?>
                <div class="related-posts">
                    <?php get_template_part( 'template-parts/posts-releated' ); ?>
                </div>
            <?php

            endif;
            // If comments are open or we have at least one comment, load up the comment template.
            if ( comments_open() || get_comments_number() ) :
                comments_template();
            endif;
        ?>
    </div>
</article>