<?php

$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts );
wp_enqueue_script( 'counterup', get_template_directory_uri().'/js/jquery.counterup.min.js', array( 'jquery' ) );
wp_enqueue_script( 'waypoints', get_template_directory_uri().'/js/waypoints.min.js', array( 'jquery' ) );
$items = (array) vc_param_group_parse_atts( $items );
if ( !empty($items) ):
?>
<div class="counters <?php echo esc_attr($el_class); ?>">
	<div class="row">
	<?php foreach ($items as $item): ?>
		<div class="col-xs-6 col-sm-<?php echo 12/count($items) ?>">
			<div class="counter-wrap" >
				<?php if ( isset($item['image']) && $item['image'] ): ?>
					<?php $img = wp_get_attachment_image_src($item['image'],'full'); ?>
					<?php if (isset($img[0]) && $img[0]) { ?>
				    	<div class="icon-box">
				    		<?php echo findgo_display_image($img); ?>
				    	</div>
					<?php } ?>
				<?php endif; ?>
				<?php if (isset($item['icon']) && $item['icon']) { ?>
				 	<i class="<?php echo esc_attr($item['icon']); ?>"></i>
				<?php } ?>
			</div> 
			<div class="counter counterUp"><?php echo (int)$item['number'] ?></div>
		    <h5 class="title"><?php echo trim($item['title']); ?></h5>
        </div>
	<?php endforeach; ?>
	</div>
</div>
<?php endif; ?>