<?php
$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts );
?>
<div class="widget-listing-categories-banner <?php echo esc_attr($el_class); ?>">
    
    <?php
    $term = get_term_by( 'slug', $category, 'job_listing_category' );
    if ($term) {
        $image_banner = '';
        if ( !empty( $image ) ) {
            $image_banner = wp_get_attachment_image_src( $image,'full' );
        }
        $icon_cat = '';
        if ( !empty( $icon_image ) ) {
            $icon_cat = wp_get_attachment_image_src( $icon_image );
        }
    ?>
        <a href="<?php echo esc_url(get_term_link( $term, 'job_listing_category' )); ?>">
            <div class="categories-banner-inner <?php echo esc_attr($style); ?>">
                <?php if ( isset($image_banner) && isset($image_banner[0]) ) { ?>
                    <div class="category-image">
                        <?php echo findgo_display_image($image_banner); ?>
                    </div>
                <?php } ?>
                <div class="content-inner">
                    <h4 class="category-info-title">
                        <?php if ( !empty($title) ) { ?>
                            <?php echo trim($title); ?>
                        <?php } else { ?>
                            <?php echo trim($term->name); ?>
                        <?php } ?>
                    </h4>
                    <span class="category-number"><?php echo sprintf(_n('%d Listing', '%d Listings', $term->count, 'findgo'), $term->count); ?></span>
                </div>
                <?php if ( isset($icon_cat) && isset($icon_cat[0]) ) { ?>
                    <div class="category-icon">
                        <?php echo findgo_display_image($icon_cat); ?>
                    </div>
                <?php } elseif ( !empty($icon_font) ) { ?>
                    <div class="category-icon">
                        <i class="<?php echo esc_attr($icon_font); ?>"></i>
                    </div>
                <?php } ?>
            </div>
        </a>
    <?php } ?>
    
</div>