<?php
$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts );
?>
<div class="widget-cities <?php echo esc_attr($el_class.' '.$layout_type); ?>">
    <?php
    $cities = (array) vc_param_group_parse_atts( $cities );
    if ( !empty($cities) ) {
        if ( $layout_type == 'layout1' || $layout_type == 'layout4' ) {
            ?>
            <div class="slick-carousel gutter-1" data-carousel="slick" data-items="<?php echo esc_attr($columns); ?>" data-smallmedium="3" data-extrasmall="1" data-pagination="false" data-nav="true" data-loop="true">
                <?php
                foreach ($cities as $city) {
                    $term = get_term_by( 'slug', $city['city'], 'job_listing_region' );
                    if ($term) {
                        if ( !empty( $city['image'] ) ) {
                            $image_cat = wp_get_attachment_image_src( $city['image'], 'postthumb-grid' );
                        }
                    ?>  
                        <div class="item">
                            <div class="city-info <?php echo esc_attr($layout_type); ?>">
                                <a href="<?php echo esc_url(get_term_link( $term )); ?>">
                                    <?php if ( isset($image_cat) && isset($image_cat[0]) ) { ?>
                                        <div class="category-image">
                                            <?php echo findgo_display_image($image_cat); ?>
                                        </div>
                                    <?php } ?>
                                    <div class="content">
                                        <div class="content-inner">
                                            <h4 class="category-info-title">
                                                <?php if ( !empty($city['title']) ) { ?>
                                                    <?php echo trim($city['title']); ?>
                                                <?php } else { ?>
                                                    <?php echo trim($term->name); ?>
                                                <?php } ?>
                                            </h4>
                                            <?php if ( !empty($show_nb) && $show_nb ) { ?>
                                                <span class="category-number"><?php echo sprintf(_n('%d Listing', '%d Listings', $term->count, 'findgo'), $term->count); ?></span>
                                            <?php } ?>
                                        </div>
                                    </div>
                                </a>
                            </div>
                        </div>
                    <?php }
                }
                ?>
            </div>
            <?php
        } elseif ( $layout_type == 'layout2' ) {
            ?>
            <div class="row">
                <?php
                $i = 0;
                foreach ($cities as $city) {
                    $term = get_term_by( 'slug', $city['city'], 'job_listing_region' );
                    if ($term) {
                        if ( !empty( $city['image'] ) ) {
                            $image_cat = wp_get_attachment_image_src( $city['image'], 'postthumb-grid' );
                        }
                    ?>
                        <?php if ( $i%6 == 0 || $i%6 == 5 ) { ?>
                            <div class="col-md-6 col-sm-12">
                        <?php } else { ?>
                            <div class="col-md-3 col-sm-6 <?php echo ($i%3 == 0)?' md-clearfix':'';  ?>">
                        <?php } ?>
                            <div class="city-layout2">
                                <a href="<?php echo esc_url(get_term_link( $term )); ?>">
                                    <?php if ( isset($image_cat) && isset($image_cat[0]) ) { ?>
                                        <div class="category-image">
                                            <?php echo findgo_display_image($image_cat); ?>
                                        </div>
                                    <?php } ?>
                                    <div class="content">
                                        <div class="content-inner">
                                            <h4 class="category-info-title">
                                                <?php if ( !empty($city['title']) ) { ?>
                                                    <?php echo trim($city['title']); ?>
                                                <?php } else { ?>
                                                    <?php echo trim($term->name); ?>
                                                <?php } ?>
                                            </h4>
                                            <?php if ( !empty($show_nb) && $show_nb ) { ?>
                                                <span class="category-number"><?php echo sprintf(_n('%d Listing', '%d Listings', $term->count, 'findgo'), $term->count); ?></span>
                                            <?php } ?>
                                        </div>
                                    </div>
                                </a>
                            </div>
                        </div>
                    <?php $i++; }
                }
                ?>
            </div>
            <?php
        } elseif ( $layout_type == 'layout3' ) {
            ?>
            <div class="row">
                <?php
                foreach ($cities as $city) {
                    $term = get_term_by( 'slug', $city['city'], 'job_listing_region' );
                    if ($term) {
                        if ( !empty( $city['image'] ) ) {
                            $image_cat = wp_get_attachment_image_src( $city['image'], 'postthumb-grid' );
                        }
                    ?>
                        <div class="col-md-6">
                            <div class="city-layout3">
                                <a href="<?php echo esc_url(get_term_link( $term )); ?>">
                                    <div class="content">
                                        <div class="content-inner">
                                            <h4 class="category-info-title">
                                                <?php if ( !empty($city['title']) ) { ?>
                                                    <?php echo trim($city['title']); ?>
                                                <?php } else { ?>
                                                    <?php echo trim($term->name); ?>
                                                <?php } ?>
                                            </h4>
                                            <?php if ( !empty($show_nb) && $show_nb ) { ?>
                                                <span class="category-number"><?php echo sprintf(_n('%d Listing', '%d Listings', $term->count, 'findgo'), $term->count); ?></span>
                                            <?php } ?>
                                        </div>
                                    </div>
                                    <?php if ( isset($image_cat) && isset($image_cat[0]) ) { ?>
                                        <div class="category-image">
                                            <?php echo findgo_display_image($image_cat); ?>
                                        </div>
                                    <?php } ?>
                                </a>
                            </div>
                        </div>
                    <?php }
                }
                ?>
            </div>
            <?php
        }
    }
    ?>
</div>