<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts );

?>
<div class="widget widget-my-dashboard <?php echo esc_attr($el_class); ?>">
<?php
if ( ! is_user_logged_in() ) {
	?>
	<div class="text-warning"><?php  esc_html_e( 'Please sign in before accessing this page.', 'findgo' ); ?></div>
	<?php
} else {
	$args = array(
	  	'author'        =>  get_current_user_id(), 
	  	'orderby'       =>  'post_date',
	  	'order'         =>  'ASC',
	  	'posts_per_page' => -1,
	  	'post_type' => 'job_listing'
	);

	$posts = get_posts( $args );
	$total = 0;
	$total_views = 0;
	$total_reviews = 0;
	if ( !empty($posts) ) {
		$total = count($posts);
		foreach ($posts as $post) {
			$total_views += intval(get_post_meta($post->ID, '_views_count', true));
			$comment_count = wp_count_comments( $post->ID );
			$total_reviews += !empty($comment_count->approved) ? $comment_count->approved : 0;
		}
	}
?>
	<h3 class="title"><?php esc_html_e('Dashboard', 'findgo'); ?></h3>
	<div class="content-inner">
		<div class="row">
			<div class="col-sm-4">
				<div class="item bg-theme">
					<div class="listings-count"><?php echo trim($total); ?></div>
					<div class="listings-text"><?php esc_html_e('All Listings', 'findgo'); ?></div>
				</div>
			</div>
			<div class="col-sm-4">
				<div class="item bg-dark">
					<div class="listings-count"><?php echo trim($total_views); ?></div>
					<div class="listings-text"><?php esc_html_e('Total Views', 'findgo'); ?></div>
				</div>
			</div>
			<div class="col-sm-4">
				<div class="item bg-red">
					<div class="listings-count"><?php echo trim($total_reviews); ?></div>
					<div class="listings-text"><?php esc_html_e('Total Reviews', 'findgo'); ?></div>
				</div>
			</div>
		</div>
		<div class="row small-row">
			<?php
				$args = array(
					'post_type'           => 'job_listing',
					'post_status'         => array( 'publish', 'expired', 'pending', 'pending_payment' ),
					'ignore_sticky_posts' => 1,
					'posts_per_page'      => -1,
					'orderby'             => 'date',
					'order'               => 'desc',
					'author'              => get_current_user_id()
				);
				$query = new WP_Query;
				$jobs = $query->query( $args );

				$jobs_status = array();
				if ( !empty($jobs) ) {
					foreach ($jobs as $job) {
						$jobs_status[$job->post_status][] = $job;
					}
				}
			?>
			<div class="col-sm-3">
				<div class="item bg-white">
					<div class="listings-count"><?php echo trim(!empty($jobs_status['publish']) ? count($jobs_status['publish']) : 0); ?></div>
					<div class="listings-text"><?php esc_html_e('Published', 'findgo'); ?></div>
				</div>
			</div>
			<div class="col-sm-3">
				<div class="item bg-white">
					<div class="listings-count"><?php echo trim(!empty($jobs_status['pending']) ? count($jobs_status['pending']) : 0); ?></div>
					<div class="listings-text"><?php esc_html_e('Pending', 'findgo'); ?></div>
				</div>
			</div>
			<div class="col-sm-3">
				<div class="item bg-white">
					<div class="listings-count"><?php echo trim(!empty($jobs_status['pending_payment']) ? count($jobs_status['pending_payment']) : 0); ?></div>
					<div class="listings-text"><?php esc_html_e('UnPaid', 'findgo'); ?></div>
				</div>
			</div>
			<div class="col-sm-3">
				<div class="item bg-white">
					<div class="listings-count"><?php echo trim(!empty($jobs_status['expired']) ? count($jobs_status['expired']) : 0); ?></div>
					<div class="listings-text"><?php esc_html_e('Expired', 'findgo'); ?></div>
				</div>
			</div>
		</div>
	</div>
<?php } ?>
</div>