<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts );

?>
<div class="widget widget-my-follow box-user <?php echo esc_attr($el_class); ?>">
	<h2 class="title">
		<?php if ( $display_type == 'followers' ) { ?>
			<?php esc_html_e( 'Follower', 'findgo' ); ?>
		<?php }else{ ?>
			<?php esc_html_e( 'Following', 'findgo' ); ?>
		<?php } ?>
	</h2>
	<div class="content-inner">
		<?php
		if ( ! is_user_logged_in() ) {
			?>
			<div class="text-warning"><?php  esc_html_e( 'Please sign in before accessing this page.', 'findgo' ); ?></div>
			<?php
		} else {
			$current_user_id = get_current_user_id();
			if ( $display_type == 'followers' ) {
				$user_ids = get_user_meta( $current_user_id, '_apus_followers', true );
			} else {
				$user_ids = get_user_meta( $current_user_id, '_apus_following', true );
			}
			get_job_manager_template( 'job_manager/profile/users.php', array('user_ids' => $user_ids) );
		}
		?>
	</div>
</div>