<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts );

?>
<div class="widget box-user widget-my-reviews <?php echo esc_attr($el_class); ?>">
<h3 class="title"><?php esc_html_e( 'My Reviews', 'findgo' ); ?></h3>
<div class="content-inner">
<?php
if ( ! is_user_logged_in() ) {
	?>
	<div class="text-warning"><?php  esc_html_e( 'Please sign in before accessing this page.', 'findgo' ); ?></div>
	<?php
} else {
	$user = wp_get_current_user();
	$args = array(
		'user_id' => $user->ID,
		'post_type' => 'job_listing',
		'status' => 'approve',
		'meta_query' => array(
	        array(
	           'key' => '_apus_rating',
	           'value' => 0,
	           'compare' => '>',
	        )
	    )
	);
	$comments = get_comments( $args );
	$number = findgo_get_config('user_profile_reviews_number', 25);
	$max_page = ceil(count($comments)/$number);
	$page = !empty($_GET['cpage']) ? $_GET['cpage'] : 1;
	echo '<ul class="list-reviews">';
		wp_list_comments(array(
			'per_page' => $number,
			'page' => $page,
			'reverse_top_level' => false,
			'callback' => 'findgo_my_review'
		), $comments);
	echo '</ul>';
	$pargs = array(
		'base' => add_query_arg( 'cpage', '%#%' ),
		'format' => '',
		'total' => $max_page,
		'current' => $page,
		'echo' => true,
		'add_fragment' => ''
	);
	if ( $max_page <= 1 ) {
		return;
	}
	findgo_paginate_links( $pargs );
} ?>
</div>