<?php


if ( !is_user_logged_in() ) {
	return;
}

$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts );

$current_user_id = get_current_user_id();
$data = get_userdata( $current_user_id );

$url = findgo_get_user_url($current_user_id, $data->user_nicename);
?>

<div class="widget-my-short-profile <?php echo esc_attr($el_class); ?>">
	<div class="user-heading">
		<div class="user-avatar">
			<a href="<?php echo esc_url($url); ?>">
				<?php echo get_avatar($current_user_id,120); ?>
			</a>
		</div>
	</div>
	<div class="right-inner">
		<div class="user-title-wrapper">
			<h3 class="author"><a href="<?php echo esc_url($url); ?>"><?php echo esc_html($data->display_name); ?></a></h3>
		</div>
		<?php
		if ( !empty($nav_menu) ) {
	        $args = array(
	            'menu' => $nav_menu,
	            'container_class' => 'no-padding',
	            'menu_class' => ' navbar-nav my-profile',
	            'menu_id' => 'my-profile',
	            'walker' => new Findgo_Nav_Menu()
	        );
	        wp_nav_menu($args);
	    }
	    ?>
    </div>
</div>