<?php
$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts );

$args = array(
	'post_type' => 'apus_testimonial',
	'posts_per_page' => $number,
	'post_status' => 'publish',
);
$loop = new WP_Query($args);
?>

<div class="widget widget-testimonials <?php echo esc_attr($el_class.' '.$style); ?>">
    <?php if ($title!=''): ?>
        <h2 class="widget-title">
            <?php echo esc_attr( $title ); ?>
        </h2>
    <?php endif; ?>
    <?php if ( $loop->have_posts() ): ?>
        <div class="slick-carousel testimonial-main" data-carousel="slick" data-items="1" data-smallmedium="1" data-extrasmall="1" data-pagination="false" data-nav="false" data-asnavfor=".testimonial-thumbnail" data-slickparent="true">
            <?php while ( $loop->have_posts() ): $loop->the_post(); ?>
                <?php get_template_part( 'template-parts/testimonial/testimonial', 'v1' ); ?>
            <?php endwhile; ?>
        </div>
    
        <div class="slick-carousel testimonial-thumbnail" data-carousel="slick" data-items="3" data-smallmedium="3" data-extrasmall="3" data-pagination="false" data-nav="false" data-asnavfor=".testimonial-main" data-slidestoscroll="1" data-focusonselect="true">
            <?php while ( $loop->have_posts() ): $loop->the_post(); ?>
                <div class="item">
                    <?php
                    if ( has_post_thumbnail() ) {
                        echo trim(findgo_get_attachment_thumbnail(get_post_thumbnail_id(),'80x80'));
                    }
                    ?>
                </div>
            <?php endwhile; ?>
        </div>
    <?php endif; ?>
    
</div>
<?php wp_reset_postdata(); ?>