<?php
extract( $args );
extract( $instance );
global $apus_author;
$user = $apus_author;
$data = get_userdata( $user->ID );
$url = findgo_get_user_url($user->ID, $data->user_nicename);
$url_listings = findgo_get_user_url($user->ID, $data->user_nicename, array('action' => 'listings'));
$url_bookmarks = findgo_get_user_url($user->ID, $data->user_nicename, array('action' => 'bookmarks'));
$url_reviews = findgo_get_user_url($user->ID, $data->user_nicename, array('action' => 'reviews'));
$url_following = findgo_get_user_url($user->ID, $data->user_nicename, array('action' => 'following'));
$url_follower = findgo_get_user_url($user->ID, $data->user_nicename, array('action' => 'follower'));

$action = !empty($_GET['action']) ? $_GET['action'] : '';
?>
<div class="widget-view-user-profile">
	<div class="user-heading">
		<div class="user-avatar">
			<a href="<?php echo esc_url($url); ?>">
				<?php echo get_avatar($user->ID,260); ?>
			</a>
		</div>
		<div class="wrapper-title text-center">
			<h3 class="author"><a href="<?php echo esc_url($url); ?>"><?php echo esc_html($data->display_name); ?></a></h3>
			<?php if ( is_user_logged_in() && get_current_user_id() != $user->ID ) {
				$check = findgo_check_follow_user($user->ID);
			?>
				<div class="fllow">
					<a href="#follow-btn" class="btn btn-theme btn-block btn-follow-following <?php echo esc_attr($check ? 'btn-following-user' : 'btn-follow-user'); ?>" data-id="<?php echo esc_attr($user->ID); ?>">
						<?php if ( $check ) { ?>
							<span class="text-following"><?php esc_html_e('Following', 'findgo'); ?></span>
							<span class="text-following-hover"><?php esc_html_e('Unfollow', 'findgo'); ?></span>
						<?php } else { ?>
							<?php esc_html_e('Follow', 'findgo'); ?>
						<?php } ?>
					</a>
				</div>
			<?php } ?>
		</div>
	</div>
	<ul class="user-menu navbar-nav ">
		<?php if ( $show_user_profile_link ) { ?>
			<li <?php echo ($action == '')? 'class="active"' : '' ?>><a href="<?php echo esc_url($url); ?>"><i class="flaticon-avatar"></i> <?php esc_html_e('Profile', 'findgo'); ?></a></li>
		<?php } ?>
		<?php if ( $show_user_listings_link ) { ?>
			<li <?php echo ($action == "listings")? 'class="active"' : '' ?>><a href="<?php echo esc_url($url_listings); ?>"><i class="fa flaticon-four-grid-layout-design-interface-symbol"></i> <?php esc_html_e('Listing', 'findgo'); ?>
				<?php
					$args = array(
						'post_type'           => 'job_listing',
						'post_status'         => array( 'publish' ),
						'ignore_sticky_posts' => 1,
						'posts_per_page'      => 1,
						'orderby'             => 'date',
						'order'               => 'desc',
						'author'              => $user->ID
					);

					$jobs_query = new WP_Query;
					$jobs = $jobs_query->query( $args );
					$count = $jobs_query->max_num_pages;
				?>
				(<?php echo intval($count); ?>)
				</a></li>
		<?php } ?>
		<?php if ( $show_user_bookmarks_link ) { ?>
			<li <?php echo ($action == "bookmarks")? 'class="active"' : '' ?>><a href="<?php echo esc_url($url_bookmarks); ?>"><i class="flaticon-like"></i> <?php esc_html_e('Bookmark', 'findgo'); ?>
				<?php
				$ids = get_user_meta($apus_author->ID, '_bookmark', true);
				$count = 0;
				if ( !empty($ids) ) {
					$args = array(
						'post_type'           => 'job_listing',
						'post_status'         => array( 'publish' ),
						'ignore_sticky_posts' => 1,
						'posts_per_page'      => 1,
						'post__in' => $ids
					);

					$jobs_query = new WP_Query;
					$jobs = $jobs_query->query( $args );
					$count = $jobs_query->max_num_pages;
				}
				?>
				(<?php echo intval($count); ?>)
			</a></li>
		<?php } ?>
		<?php if ( $show_user_reviews_link ) { ?>
			<li <?php echo ($action == "reviews")? 'class="active"' : '' ?>><a href="<?php echo esc_url($url_reviews); ?>"><i class="flaticon-consulting-message"></i> <?php esc_html_e('Reviews', 'findgo'); ?>
				<?php
				$args = array( 'user_id' => $apus_author->ID );
				$comments = findgo_get_review_comments( $args );
				?>
				(<?php echo count($comments); ?>)
			</a></li>
		<?php } ?>
		<?php if ( $show_user_following_link ) { ?>
			<li <?php echo ($action == "following")? 'class="active"' : '' ?>><a href="<?php echo esc_url($url_following); ?>"><i class="flaticon-user-1"></i><?php esc_html_e('Following', 'findgo'); ?>
				<?php
				$count = 0;
				$user_ids = get_user_meta( $apus_author->ID, '_apus_following', true );
				if ( !empty($user_ids) && is_array($user_ids) ) {
					$count = count($user_ids);
				}
				?>
				(<?php echo intval($count); ?>)
			</a></li>
		<?php } ?>
		<?php if ( $show_user_follower_link ) { ?>
			<li <?php echo ($action == "follower")? 'class="active"' : '' ?> ><a href="<?php echo esc_url($url_follower); ?>"><i class="flaticon-user"></i> <?php esc_html_e('Follower', 'findgo'); ?>
				<?php
				$count = 0;
				$user_ids = get_user_meta( $apus_author->ID, '_apus_followers', true );
				if ( !empty($user_ids) && is_array($user_ids) ) {
					$count = count($user_ids);
				}
				?>
				(<?php echo intval($count); ?>)
			</a></li>
		<?php } ?>
	</ul>
	<div class="user-contact-form">
		<?php get_template_part( 'job_manager/profile/contact-form' ); ?>
	</div>
</div>