<?php

namespace EA11y\Modules\Scanner\Components;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Top_Bar_Link {

	public function get_name(): string {
		return 'top-bar-link';
	}

	public function add_bar_link() {
		if ( is_admin() ) {
			return;
		}
		add_action( 'admin_bar_menu', function ( \WP_Admin_Bar $wp_admin_bar ) {
			if ( ! current_user_can( 'manage_options' ) ) {
				return;
			}
			// Define the SVG icon
			$svg_icon = '
				<svg xmlns="http://www.w3.org/2000/svg" class="ea11y-scanner-wizard-icon" role="presentation" width="16" height="16" viewBox="0 0 14 14" fill="none">
				  <path d="M10.334 1.22529C11.3395 1.80586 12.1759 2.63898 12.7605 3.64216C13.3451 4.64534 13.6576 5.78381 13.6669 6.94485C13.6763 8.1059 13.3823 9.24926 12.814 10.2618C12.2457 11.2743 11.4228 12.1208 10.4268 12.7175C9.43081 13.3142 8.29623 13.6405 7.13538 13.664C5.97454 13.6875 4.82768 13.4074 3.80835 12.8515C2.78902 12.2955 1.93257 11.483 1.32376 10.4943C0.714959 9.50563 0.374924 8.3751 0.337318 7.21463L0.333984 6.99863L0.337318 6.78263C0.374653 5.63129 0.709683 4.50927 1.30974 3.52595C1.90981 2.54264 2.75442 1.73159 3.76125 1.17188C4.76807 0.612168 5.90275 0.322891 7.05466 0.332251C8.20656 0.341612 9.33639 0.649291 10.334 1.22529ZM9.63332 5.78796C9.58168 5.63299 9.47495 5.50238 9.33338 5.4209C9.19181 5.33942 9.02525 5.31276 8.86532 5.34596L8.78998 5.36596L7.00065 5.96263L5.21132 5.36596L5.13598 5.34596C4.9762 5.31307 4.80991 5.33992 4.66858 5.4214C4.52726 5.50289 4.42072 5.63336 4.36914 5.78812C4.31755 5.94288 4.3245 6.11119 4.38866 6.26117C4.45283 6.41115 4.56976 6.5324 4.71732 6.60196L4.78998 6.63129L6.33398 7.14529V7.79596L5.11265 9.62929L5.07265 9.69596C5.00506 9.82874 4.98389 9.98033 5.01253 10.1265C5.04117 10.2728 5.11796 10.4052 5.23065 10.5026L5.29732 10.5533L5.36465 10.5933C5.49743 10.6609 5.64902 10.682 5.79523 10.6534C5.94145 10.6248 6.07385 10.548 6.17132 10.4353L6.22198 10.3686L7.00065 9.20063L7.77932 10.3686L7.82598 10.4306C7.93176 10.5553 8.07966 10.6368 8.24157 10.6595C8.40348 10.6823 8.5681 10.6447 8.70414 10.554C8.84018 10.4633 8.93815 10.3258 8.97942 10.1676C9.02069 10.0094 9.00239 9.84155 8.92798 9.69596L8.88865 9.62929L7.66732 7.79596V7.14463L9.21132 6.63063L9.28399 6.60129C9.43179 6.53193 9.549 6.41074 9.61339 6.2607C9.67778 6.11066 9.68487 5.94221 9.63332 5.78729V5.78796ZM7.00065 2.99863C6.73543 2.99863 6.48108 3.10398 6.29354 3.29152C6.10601 3.47906 6.00065 3.73341 6.00065 3.99863C6.00065 4.26384 6.10601 4.5182 6.29354 4.70573C6.48108 4.89327 6.73543 4.99863 7.00065 4.99863C7.26587 4.99863 7.52022 4.89327 7.70776 4.70573C7.89529 4.5182 8.00065 4.26384 8.00065 3.99863C8.00065 3.73341 7.89529 3.47906 7.70776 3.29152C7.52022 3.10398 7.26587 2.99863 7.00065 2.99863Z" fill="#9DA1A7"/>
				</svg>';

			$wp_admin_bar->add_node( [
				'id' => 'ea11y-scanner-wizard',
				'title' => $svg_icon . esc_html__( 'Accessibility Assistant', 'pojo-accessibility' ),
				'href' => '#', // Click event is handled by JS.
			] );
		}, 200 );
	}

	/**
	 * Component constructor.
	 */
	public function __construct() {
		$this->add_bar_link();
	}
}
