<?php
/**
 * Theme Customizer - Header
 *
 * @package finwave
 */

namespace RT\Finwave\Api\Customizer\Sections;

use RT\Finwave\Api\Customizer;
use RT\Finwave\Helpers\Fns;
use RTFramework\Customize;

/**
 * Customizer class
 */
class Footer extends Customizer {
	protected $section_footer = 'rt_footer_section';

	/**
	 * Register controls
	 * @return void
	 */
	public function register() {
		Customize::add_section( [
			'id'          => $this->section_footer,
			'title'       => __( 'Footer', 'finwave' ),
			'description' => __( 'Footer Section', 'finwave' ),
			'priority'    => 38
		] );

		Customize::add_controls( $this->section_footer, $this->get_controls() );
	}

	/**
	 * Get controls
	 * @return array
	 */
	public function get_controls() {

		return apply_filters( 'rt_footer_controls', [

			'rt_footer_display' => [
				'type'        => 'switch',
				'label'       => __( 'Footer Display', 'finwave' ),
				'description' => __( 'Show footer display', 'finwave' ),
				'default' => 1,
			],

			'rt_footer_style' => [
				'type'    => 'image_select',
				'label'   => __( 'Choose Layout', 'finwave' ),
				'default' => '1',
				'choices' => Fns::image_placeholder( 'footer', 2 )
			],

			'rt_footer_width' => [
				'type'    => 'select',
				'label'   => __( 'Footer Width', 'finwave' ),
				'default' => '',
				'choices' => [
					''       => __( 'Box Width', 'finwave' ),
					'-fluid' => __( 'Full Width', 'finwave' ),
				]
			],

			'rt_footer_max_width' => [
				'type'        => 'number',
				'label'       => __( 'Footer Max Width (PX)', 'finwave' ),
				'description' => __( 'Enter a number greater than 992.', 'finwave' ),
				'condition'   => [ 'rt_footer_width', '==', '-fluid' ]
			],

			'rt_sticky_footer' => [
				'type'        => 'switch',
				'label'       => __( 'Sticky Footer', 'finwave' ),
				'description' => __( 'Show footer at the top when scrolling down', 'finwave' ),
			],

			'rt_social_footer' => [
				'type'        => 'switch',
				'label'       => __( 'Social Icon', 'finwave' ),
				'description' => __( 'Show footer at the social icon, This options available for only Footer layout.', 'finwave' ),
			],

			'rt_footer_copyright' => [
				'type'        => 'tinymce',
				'label'       => __( 'Footer Copyright Text', 'finwave' ),
				'default'     => __( 'Copyright© [y] Finwave by RadiusTheme', 'finwave' ),
				'description' => __( 'Add [y] flag anywhere for dynamic year.', 'finwave' ),
			],

		] );

	}

}
