<?php
/**
 * Theme Customizer - Team
 *
 * @package finwave
 */

namespace RT\Finwave\Api\Customizer\Sections;

use RT\Finwave\Api\Customizer;
use RT\Finwave\Helpers\Fns;
use RTFramework\Customize;

/**
 * Customizer class
 */
class Team extends Customizer {

	protected $section_team = 'rt_team_section';


	/**
	 * Register controls
	 * @return void
	 */
	public function register() {
		Customize::add_section( [
			'id'          => $this->section_team,
			'title'       => __( 'Team Option', 'finwave' ),
			'description' => __( 'Team Section', 'finwave' ),
			'priority'    => 35
		] );

		Customize::add_controls( $this->section_team, $this->get_controls() );
	}

	/**
	 * Get controls
	 * @return array
	 */
	public function get_controls() {
		return apply_filters( 'rt_team_controls', [

			'rt_team_archive_heading' => [
				'type'  => 'heading',
				'label' => __( 'Team Archive Option', 'finwave' ),
			],

			'rt_team_style' => [
				'type'        => 'select',
				'label'       => __( 'Team Layout', 'finwave' ),
				'description' => __( 'This option works only for team layout', 'finwave' ),
				'default'     => 'default',
				'choices'     => [
					'default' => __( 'Team 01', 'finwave' ),
					'2'    => __( 'Team 02', 'finwave' ),
					'3'    => __( 'Team 03', 'finwave' ),
					'4'    => __( 'Team 04', 'finwave' ),
				]
			],

			'rt_team_item_number' => [
				'type'    => 'number',
				'label'   => __( 'Team Archive Item Limit', 'finwave' ),
				'default' => '8',
			],

			'rt_team_ar_designation' => [
				'type'    => 'switch',
				'label'   => __( 'Designation Visibility', 'finwave' ),
				'default' => 1
			],

			'rt_team_ar_social' => [
				'type'    => 'switch',
				'label'   => __( 'Social Visibility', 'finwave' ),
				'default' => 1
			],

			'rt_team_ar_excerpt' => [
				'type'    => 'switch',
				'label'   => __( 'Excerpt Visibility', 'finwave' ),
				'default' => 0
			],

			'rt_team_excerpt_limit' => [
				'type'    => 'number',
				'label'   => __( 'Content Limit', 'finwave' ),
				'default' => '12',
				'condition' => [ 'rt_team_ar_excerpt' ]
			],

			'rt_team_banner_archive_title' => [
				'type'    => 'text',
				'label'   => __( 'Archive Banner Title', 'finwave' ),
				'default' => __( 'Our Teams', 'finwave' ),
			],

			'rt_team_slug' => [
				'type'    => 'text',
				'label'   => __( 'Archive Slug', 'finwave' ),
				'default' => __( 'team', 'finwave' ),
			],

			'rt_team_cat_slug' => [
				'type'    => 'text',
				'label'   => __( 'Category Slug', 'finwave' ),
				'default' => 'team-category',
			],

			'rt_team_single_heading' => [
				'type'  => 'heading',
				'label' => __( 'Team Single Option', 'finwave' ),
			],

			'rt_team_single_author' => [
				'type'        => 'select',
				'label'       => __( 'Team Author Layout', 'finwave' ),
				'default'     => 'team-thumb-square',
				'choices'     => [
					'team-thumb-square'    => __( 'Thumb Square', 'finwave' ),
					'team-thumb-round'    => __( 'Thumb Round', 'finwave' ),
				]
			],

			'rt_team_single_author_order' => [
				'type'        => 'select',
				'label'       => __( 'Team Author Order', 'finwave' ),
				'default'     => 'thumb-left',
				'choices'     => [
					'thumb-left'    => __( 'Thumb Left', 'finwave' ),
					'thumb-right'    => __( 'Thumb Right', 'finwave' ),
				]
			],

			'rt_team_single_info' => [
				'type'    => 'switch',
				'label'   => __( 'Info Visibility', 'finwave' ),
				'default' => 1
			],

			'rt_team_single_social' => [
				'type'    => 'switch',
				'label'   => __( 'Social Visibility', 'finwave' ),
				'default' => 1
			],

			'rt_team_single_skill' => [
				'type'    => 'switch',
				'label'   => __( 'Skill Visibility', 'finwave' ),
				'default' => 1
			],

			'rt_team_single_contact' => [
				'type'    => 'switch',
				'label'   => __( 'Contact Visibility', 'finwave' ),
				'default' => 0
			],

			'rt_team_contact_title' => [
				'type'    => 'text',
				'label'   => __( 'Team Contact Title', 'finwave' ),
				'default' => __( 'Team Contact', 'finwave' ),
				'condition' => [ 'rt_team_single_contact' ]
			],

			'rt_team_single_related_heading' => [
				'type'  => 'heading',
				'label' => __( 'Team Single Related Option', 'finwave' ),
			],

			'rt_team_related' => [
				'type'    => 'switch',
				'label'   => __( 'Related Visibility', 'finwave' ),
				'default' => 0
			],

			'rt_team_related_title' => [
				'type'    => 'text',
				'label'   => __( 'Team Related Title', 'finwave' ),
				'default' => __( 'Related Team', 'finwave' ),
				'condition' => [ 'rt_team_related' ]
			],

			'rt_team_related_limit' => [
				'type'    => 'number',
				'label'   => __( 'Related Item Limit', 'finwave' ),
				'default' => 4,
				'condition' => [ 'rt_team_related' ]
			],

			'rt_team_related_query' => [
				'type'        => 'select',
				'label'       => __( 'Query Type', 'finwave' ),
				'description' => __( 'Team Query Type', 'finwave' ),
				'default'     => 'cat',
				'choices'     => [
					'cat' => esc_html__( 'Posts in the same Categories', 'finwave' ),
					'tag' => esc_html__( 'Posts in the same Tags', 'finwave' ),
					'author' => esc_html__( 'Posts by the same Author', 'finwave' ),
				],
				'condition' => [ 'rt_team_related' ]
			],

			'rt_team_related_sort' => [
				'type'        => 'select',
				'label'       => __( 'Sort Order', 'finwave' ),
				'description' => __( 'Display Team Order', 'finwave' ),
				'default'     => 'recent',
				'choices'     => [
					'recent' => esc_html__( 'Recent Posts', 'finwave' ),
					'rand' => esc_html__( 'Random Posts', 'finwave' ),
					'modified' => esc_html__( 'Last Modified Posts', 'finwave' ),
					'popular' => esc_html__( 'Most Commented posts', 'finwave' ),
					'views' => esc_html__( 'Most Viewed posts', 'finwave' ),
				],
				'condition' => [ 'rt_team_related' ]
			],

		] );
	}


}
