<?php
/**
 * The home template file
 *
 * This is the most generic template file in a WordPress theme and one
 * of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query,
 * e.g., it puts together the home page when no home.php file exists.
 *
 * Template Name: Home
 *
 */
 
 
 
?>
<?php get_header();?>

<?php if ( have_posts() ) while ( have_posts() ) : the_post(); ?>

    <?php 
    // Check if this page is built with Elementor
    // Проверка, создана ли эта страница с помощью Elementor
    $fixar_is_elementor_page = false;
    
    // Method 1: Check using post meta
    // Метод 1: Проверка через мета-данные поста
    $elementor_meta = get_post_meta( get_the_ID(), '_elementor_edit_mode', true );
    $fixar_is_elementor_page = ($elementor_meta === 'builder');
    
    // Force elementor check for debugging
    // Принудительная проверка Elementor для отладки
    if ( isset($_GET['fixar_debug_elementor']) ) {
        $fixar_is_elementor_page = true;
    }
    
    if ( $fixar_is_elementor_page ) : 
        // If this is an Elementor page, just output the content directly
        // Если это страница Elementor, просто выводим контент напрямую
    ?>
        <div class="tmpl-home home-template">
            <?php the_content(); ?>
        </div>
    <?php else : 
        // If this is NOT an Elementor page, wrap content in container
        // Если это НЕ страница Elementor, оборачиваем контент в контейнер
    ?>
        <div class="tmpl-home home-template">
            <div class="container">
                <?php the_content(); ?>
            </div>
        </div>
    <?php endif; ?>
      
<?php endwhile; ?>	

<?php get_footer(); ?>