<?php
/**
 * Flex @package SP Page Builder
 * Template Name - Flex
 * @author Aplikko http://www.aplikko.com
 * @copyright Copyright (c) 2024 Aplikko
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/
// no direct access
defined('_JEXEC') or die;

use Joomla\CMS\Language\Text;

//Include Pixeden Icons
require_once dirname(dirname( __DIR__ )) . '/fields/pixeden-icons.php';

SpAddonsConfig::addonConfig([
    'type'       => 'general',
    'addon_name' => 'button_group',
    'title'      => Text::_('COM_SPPAGEBUILDER_ADDON_BUTTON_GROUP'),
    'desc'       => Text::_('COM_SPPAGEBUILDER_ADDON_BUTTON_GROUP_DESC'),
    'category'   => 'Content',
    'settings' => [
        'buttons' => [
            'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTONS'),
            'fields' => [
                'sp_button_group_item' => [
                    'type' => 'repeatable',
                    'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTONS'),
					'std'   => [
                            [
                                'title' => 'Button-1',
								'type' => 'primary',
								'appearance' => '3d',
                            ],
                            [
                                'title' => 'Button-2',
								'link' => '#',
								'type' => 'default',
								'icon' => 'fa-angellist',
								'shape' => 'round',
                            ],
							[
                                'title' => 'Button-3',
								'type' => 'dark',
								'peicon_name' => 'pe-7s-coffee',
								'icon_position' => 'right',
                            ],
                        ],
                    'attr'  => [
                        'button' => [
                            'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON'),
                            'fields' => [
                                'title' => [
                                    'type'  => 'text',
                                    'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_TEXT'),
                                    'desc'  => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_TEXT_DESC'),
                                    'std'   => 'Button'
                                ],

                                'url' => [
                                    'type'         => 'link',
                                    'title'        => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_URL'),
                                    'desc'         => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_URL_DESC'),
                                ],

                                'typography' => [
                                    'type'     => 'typography',
                                    'title'    => Text::_('COM_SPPAGEBUILDER_GLOBAL_TYPOGRAPHY'),
                                    'fallbacks' => [
                                        'font' => 'font_family',
                                        'size' => 'fontsize',
                                        'letter_spacing' => 'letterspace',
                                        'weight' => 'font_style.weight',
                                        'italic' => 'font_style.italic',
                                        'underline' => 'font_style.underline',
                                        'uppercase' => 'font_style.uppercase',
                                    ],
                                ],

                                'type' => [
                                    'type'   => 'select',
                                    'title'  => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_STYLE'),
                                    'desc'   => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_STYLE_DESC'),
                                    'values' => [
                                        'default'   => Text::_('COM_SPPAGEBUILDER_GLOBAL_DEFAULT'),
										'flex'      => Text::_('COM_SPPAGEBUILDER_GLOBAL_FLEX'),
										'dark'		=> Text::_('COM_SPPAGEBUILDER_GLOBAL_DARK'),
										'light'		=> Text::_('COM_SPPAGEBUILDER_GLOBAL_LIGHT'),
                                        'primary'   => Text::_('COM_SPPAGEBUILDER_GLOBAL_PRIMARY'),
                                        'secondary' => Text::_('COM_SPPAGEBUILDER_GLOBAL_SECONDARY'),
                                        'success'   => Text::_('COM_SPPAGEBUILDER_GLOBAL_SUCCESS'),
                                        'info'      => Text::_('COM_SPPAGEBUILDER_GLOBAL_INFO'),
                                        'warning'   => Text::_('COM_SPPAGEBUILDER_GLOBAL_WARNING'),
                                        'danger'    => Text::_('COM_SPPAGEBUILDER_GLOBAL_DANGER'),
                                        'link'      => Text::_('COM_SPPAGEBUILDER_GLOBAL_LINK'),
                                        'custom'    => Text::_('COM_SPPAGEBUILDER_GLOBAL_CUSTOM'),
                                    ],
                                    //'inline' => true,
                                    'std' => 'default'
                                ],

                                'link_button_padding_bottom' => [
                                    'type'    => 'slider',
                                    'title'   => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_PADDING_BOTTOM'),
                                    'max'     => 100,
                                    'depends' => [['type', '=', 'link']],
                                ],

                                'appearance' => [
                                    'type'   => 'select',
                                    'title'  => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_APPEARANCE'),
                                    'desc'   => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_APPEARANCE_DESC'),
                                    'values' => [
                                        ''         => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_APPEARANCE_FLAT'),
                                        'outline'  => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_APPEARANCE_OUTLINE'),
										'3d'	   => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_APPEARANCE_3D'),
                                        'gradient' => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_APPEARANCE_GRADIENT'),
                                    ],
                                    'inline' => true,
                                    'std'     => 'flat',
                                    'depends' => [['type', '!=', 'link']]
                                ],

                                'shape' => [
                                    'type'   => 'radio',
                                    'title'  => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_SHAPE'),
                                    'desc'   => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_SHAPE_DESC'),
                                    'values' => [
                                        'rounded' => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_SHAPE_ROUNDED'),
                                        'square'  => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_SHAPE_SQUARE'),
                                        'round'   => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_SHAPE_ROUND'),
                                    ],
                                    'std'     => 'rounded',
                                ],

                                'size' => [
                                    'type'   => 'select',
                                    'title'  => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_SIZE'),
                                    'desc'   => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_SIZE_DESC'),
                                    'values' => [
                                        ''    => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_SIZE_DEFAULT'),
                                        'lg'  => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_SIZE_LARGE'),
                                        'xlg' => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_SIZE_XLARGE'),
                                        'sm'  => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_SIZE_SMALL'),
                                        'xs'  => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_SIZE_EXTRA_SAMLL'),
                                        'custom' => Text::_('COM_SPPAGEBUILDER_GLOBAL_CUSTOM'),
                                    ],
                                ],

                                'button_padding' => [
                                    'type'    => 'padding',
                                    'title'   => Text::_('COM_SPPAGEBUILDER_GLOBAL_PADDING'),
                                    'desc'    => Text::_('COM_SPPAGEBUILDER_GLOBAL_PADDING_DESC'),
                                    'responsive' => true,
                                    'depends' => [['size', '=', 'custom']]
                                ],

                                'block' => [
                                    'type'   => 'select',
                                    'title'  => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_BLOCK'),
                                    'desc'   => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_BLOCK_DESC'),
                                    'values' => [
                                        ''               => Text::_('JNO'),
                                        'sppb-btn-block' => Text::_('JYES'),
                                    ],
                                ],
                            ],
                        ],

                        // Icon
                        'icon' => [
                            'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_ICON'),
                            'fields' => [
								
								// Pixeden Icons
                                'peicon_name' => [
                                    'type'  => 'select',
									'title'=>Text::_('COM_SPPAGEBUILDER_ADDON_GLOBAL_PE_ICON_NAME'),
									'desc'=>Text::_('COM_SPPAGEBUILDER_ADDON_GLOBAL_PE_ICON_NAME_DESC'),
									'values'=> $peicon_list
                                ],
								
								'icon' => [
                                    'type'  => 'icon',
                                    'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_ICON'),
                                    'desc'  => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_ICON_DESC'),
                                ],

                                'icon_position' => [
                                    'type'   => 'radio',
                                    'title'  => Text::_('COM_SPPAGEBUILDER_GLOBAL_POSITION'),
                                    'values' => [
                                        'left'  => Text::_('COM_SPPAGEBUILDER_GLOBAL_LEFT'),
                                        'right' => Text::_('COM_SPPAGEBUILDER_GLOBAL_RIGHT'),
                                    ],
                                    'std' => 'left'
                                ],
                            ],
                        ],

                        // Custom Style
                        'style' => [
                            'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_STYLE'),
                            'depends' => [['type', '=', 'custom']],
                            'fields' => [
                                'style_tab' => [
                                    'type'   => 'buttons',
                                    'values' => [
                                        ['label' => Text::_('COM_SPPAGEBUILDER_GLOBAL_NORMAL'), 'value' => 'normal'],
                                        ['label' => Text::_('COM_SPPAGEBUILDER_GLOBAL_HOVER'), 'value' => 'hover'],
                                    ],
                                    'std'    => 'normal',
                                    'tabs'    => true,
                                ],

                                'color' => [
                                    'type'    => 'color',
                                    'title'   => Text::_('COM_SPPAGEBUILDER_GLOBAL_COLOR'),
                                    'desc'    => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_COLOR_DESC'),
                                    'std'     => '#fff',
                                    'depends' => [['style_tab', '!=', 'hover']],
                                ],

                                'color_hover' => [
                                    'type'    => 'color',
                                    'title'   => Text::_('COM_SPPAGEBUILDER_GLOBAL_COLOR'),
                                    'std'     => '#fff',
                                    'depends' => [['style_tab', '=', 'hover']],
                                ],

                                'background_color' => [
                                    'type'    => 'color',
                                    'title'   => Text::_('COM_SPPAGEBUILDER_GLOBAL_BACKGROUND'),
                                    'std'     => '#444444',
                                    'depends' => [
                                        ['appearance', '!=', 'gradient'],
                                        ['style_tab', '!=', 'hover'],
                                    ],
                                ],

                                'background_color_hover' => [
                                    'type'    => 'color',
                                    'title'   => Text::_('COM_SPPAGEBUILDER_GLOBAL_BACKGROUND_COLOR'),
                                    'std'     => '#222',
                                    'depends' => [
                                        ['appearance', '!=', 'gradient'],
                                        ['style_tab', '=', 'hover'],
                                    ],
                                ],

                                'background_gradient' => [
                                    'type'  => 'gradient',
                                    'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_BACKGROUND'),
                                    'std'   => [
										"color"  => "#BDA967",
										"color2" => "#867029",
                                        "deg"    => "45",
                                        "type"   => "linear"
                                    ],
                                    'depends' => [
                                        ['appearance', '=', 'gradient'],
                                        ['style_tab', '!=', 'hover'],
                                    ],
                                ],

                                'background_gradient_hover' => [
                                    'type'  => 'gradient',
                                    'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_BACKGROUND'),
                                    'std'   => [
										"color"  => "#AC9A5C",
										"color2" => "#877128",
                                        "deg"    => "45",
                                        "type"   => "linear"
                                    ],
                                    'depends' => [
                                        ['appearance', '=', 'gradient'],
                                        ['style_tab', '=', 'hover'],
                                    ],
                                ],
                            ],
                        ],

                        // Link Style
                        'link_style' => [
                            'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_STYLE'),
                            'depends' => [['type', '=', 'link']],
                            'fields' => [
                                'link_style_tab' => [
                                    'type'   => 'buttons',
                                    'values' => [
                                        ['label' => Text::_('COM_SPPAGEBUILDER_GLOBAL_NORMAL'), 'value' => 'normal'],
                                        ['label' => Text::_('COM_SPPAGEBUILDER_GLOBAL_HOVER'), 'value' => 'hover'],
                                    ],
                                    'std'    => 'normal',
                                    'tabs'    => true,
                                ],

                                'link_button_color' => [
                                    'type'    => 'color',
                                    'title'   => Text::_('COM_SPPAGEBUILDER_GLOBAL_COLOR'),
                                    'depends' => [['link_style_tab', '!=', 'hover']],
                                ],

                                'link_button_border_width' => [
                                    'type'    => 'slider',
                                    'title'   => Text::_('COM_SPPAGEBUILDER_GLOBAL_BORDER_WIDTH'),
                                    'max'     => 30,
                                    'depends' => [['link_style_tab', '!=', 'hover']],
                                ],

                                'link_border_color' => [
                                    'type'    => 'color',
                                    'title'   => Text::_('COM_SPPAGEBUILDER_GLOBAL_BORDER_COLOR'),
                                    'depends' => [['link_style_tab', '!=', 'hover']],
                                ],

                                //Link Hover
                                'link_button_hover_color' => [
                                    'type'    => 'color',
                                    'title'   => Text::_('COM_SPPAGEBUILDER_GLOBAL_COLOR'),
                                    'depends' => [['link_style_tab', '=', 'hover']],
                                ],

                                'link_button_border_hover_color' => [
                                    'type'    => 'color',
                                    'title'   => Text::_('COM_SPPAGEBUILDER_GLOBAL_BORDER_COLOR'),
                                    'depends' => [['link_style_tab', '=', 'hover']],
                                ],
                            ],
                        ],
                    ],
                ],

                'margin_separator' => [
                    'type'       => 'separator',
                ],

                'margin' => [
                    'type'       => 'slider',
                    'title'      => Text::_('COM_SPPAGEBUILDER_GLOBAL_GAP'),
                    'responsive' => true,
                    'max'        => 100,
                    'std'        => ['xl' => 5],
                ],

                'alignment_separator' => [
                    'type'       => 'separator',
                ],

                'alignment' => [
                    'type'              => 'alignment',
                    'title'             => Text::_('COM_SPPAGEBUILDER_GLOBAL_ALIGNMENT'),
                    'responsive'        => true,
                    'available_options' => ['left', 'center', 'right'],
                    'std'               => [
                        'xl' => 'center', 'lg' => '', 'md' => '', 'sm' => '',  'xs' => ''
                    ],
                ],
            ],
        ],
    ],
]);
