<?php
/**
 * Flex @package SP Page Builder
 * Template Name - Flex
 * @author Aplikko http://www.aplikko.com
 * @copyright Copyright (c) 2024 Aplikko
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/
// no direct access
defined('_JEXEC') or die;

class SppagebuilderAddonCall_to_action extends SppagebuilderAddons {

	public function render() {
		
		$settings = $this->addon->settings;
		
		$class = (isset($settings->class) && $settings->class) ? $settings->class : '';
		$style = (isset($settings->style) && $settings->style) ? $settings->style : 'panel-default';
		$title = (isset($settings->title) && $settings->title) ? $settings->title : '';
		$heading_selector = (isset($settings->heading_selector) && $settings->heading_selector) ? $settings->heading_selector : 'h3';

		//Addon Options
		$subtitle = (isset($settings->subtitle) && $settings->subtitle) ? $settings->subtitle : '';
		$text = (isset($settings->text) && $settings->text) ? $settings->text : '';
		$button_text = (isset($settings->button_text) && $settings->button_text) ? $settings->button_text : '';
		$button_url = (isset($settings->button_url) && $settings->button_url) ? $settings->button_url : '';
		$button_classes = (isset($settings->button_size) && $settings->button_size) ? ' sppb-btn-' . $settings->button_size : '';
		$button_classes .= (isset($settings->button_type) && $settings->button_type) ? ' sppb-btn-' . $settings->button_type : '';
		$button_classes .= (isset($settings->button_shape) && $settings->button_shape) ? ' sppb-btn-' . $settings->button_shape: ' sppb-btn-rounded';
		$button_classes .= (isset($settings->button_appearance) && $settings->button_appearance) ? ' sppb-btn-' . $settings->button_appearance : '';
		$button_classes .= (isset($settings->button_block) && $settings->button_block) ? ' ' . $settings->button_block : '';
		//Pixeden Icons
		$peicon_name = (isset($settings->peicon_name) && $settings->peicon_name) ? $settings->peicon_name: '';
		$button_icon = (isset($settings->button_icon) && $settings->button_icon) ? $settings->button_icon : '';
		$button_icon_position = (isset($settings->button_icon_position) && $settings->button_icon_position) ? $settings->button_icon_position : 'left';

		$button_position = (isset($settings->button_position) && $settings->button_position) ? $settings->button_position : '';
		$button_attribs = (isset($settings->button_target) && $settings->button_target) ? ' target="' . $settings->button_target . '"' : '';
		$button_attribs .= (isset($settings->button_url) && $settings->button_url) ? ' href="' . $settings->button_url . '"' : '';

		// Generate Button
		if($button_icon_position == 'left') {
			
			if ($peicon_name) {
				$button_text = ($peicon_name) ? '<i class="pe ' . $peicon_name . ' me-1 ms-n1"></i> ' . $button_text : $button_text;
			}else{
				$button_text = ($button_icon) ? '<i class="fa ' . $button_icon . ' me-1 ms-n1"></i> ' . $button_text : $button_text;
			}
		
		} else {
			
			if ($peicon_name) {
				$button_text = ($peicon_name) ? $button_text . ' <i class="pe ' . $peicon_name . ' ms-1 me-n1"></i>' : $button_text;
			}else{
				$button_text = ($button_icon) ? $button_text . ' <i class="fa ' . $button_icon . ' ms-1 me-n1"></i>' : $button_text;
			}
		}
		
		$button_output = '<a' . $button_attribs . ' id="btn-'. $this->addon->id .'" class="sppb-btn' . $button_classes . '">' . $button_text . '</a>';
		

		// Addon Output
		$output  = '<div class="sppb-addon sppb-addon-cta ' . $class . '">';

		if($button_position=='right') {
			//$output .= '<div class="sppb-container">';
			$output .= '<div class="sppb-row">';
			$output .= '<div class="col-sm-8">';
			$output .= ($title) ? '<'.$heading_selector.' class="sppb-addon-title sppb-cta-title">' . $title . '</'.$heading_selector.'>' : '';
			$output .= ($subtitle) ? '<p class="sppb-lead sppb-cta-subtitle">' . $subtitle . '</p>' : '';
			$output .= ($text) ? '<p class="sppb-cta-text">' . $text . '</p>' : '';
			$output .= '</div>';
			$output .= '<div class="col-sm-4 sppb-text-right">';
			$output .= $button_output;
			$output .= '</div>';
			$output .= '</div>';
		} else {
			$output .= '<div class="text-center">';
			$output .= ($title) ? '<'.$heading_selector.' class="sppb-addon-title sppb-cta-title">' . $title . '</'.$heading_selector.'>' : '';
			$output .= ($subtitle) ? '<p class="sppb-lead sppb-cta-subtitle">' . $subtitle . '</p>' : '';
			$output .= ($text) ? '<p class="sppb-cta-text">' . $text . '</p>' : '';
			$output .= '<div>';
			$output .= $button_output;
			$output .= '</div>';
			$output .= '</div>';
			//$output .= '</div>';
		}

		$output .= '</div>';

		return $output;
	}

	public function css() {
		
		$settings = $this->addon->settings;
		$addon_id = '#sppb-addon-' . $this->addon->id;
		$layout_path = JPATH_ROOT . '/components/com_sppagebuilder/layouts';
		$css_path = new JLayoutFile('addon.css.button', $layout_path);
		$number_style = '';
		$text_style = '';

		$style = (isset($settings->background) && $settings->background) ? "background-color: " . $settings->background  . ";" : '';
		$style .= (isset($settings->color) && $settings->color) ? "color: " . $settings->color  . ";" : '';
		$style .= (isset($settings->padding) && $settings->padding) ? "padding: " . $settings->padding  . ";" : "padding: 40px 20px;";

		// Sub title
		$subtitle_style = (isset($settings->subtitle_text_color) && $settings->subtitle_text_color) ? 'color:' . $settings->subtitle_text_color  . ';' : '';
		$subtitle_style .= (isset($settings->subtitle_fontsize) && $settings->subtitle_fontsize) ? 'font-size: ' . $settings->subtitle_fontsize . 'px; line-height: ' . $settings->subtitle_fontsize . 'px;' : '';

		$css = '';
		if($style) {
			$css .= $addon_id . ' .sppb-addon-cta {';
			$css .= $style;
			$css .= '}';
		}

		if($subtitle_style) {
			$css .= $addon_id . ' .sppb-cta-subtitle {';
			$css .= $subtitle_style;
			$css .= '}';
		}

		// Button options
		$css .= $css_path->render(array('addon_id' => $addon_id, 'options' => $this->addon->settings, 'id' => 'btn-' . $this->addon->id));;

		return $css;
	}

}
