<?php
/**
 * Flex @package SP Page Builder
 * Template Name - Flex
 * @author Aplikko http://www.aplikko.com
 * @copyright Copyright (c) 2024 Aplikko
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/
// no direct access
defined('_JEXEC') or die;

use Joomla\CMS\Language\Text;

SpAddonsConfig::addonConfig([
	'type'       => 'repeatable',
	'addon_name' => 'carousel',
	'category'   => 'Slider',
	'title'      => Text::_('COM_SPPAGEBUILDER_ADDON_CAROUSEL'),
	'desc'       => Text::_('COM_SPPAGEBUILDER_ADDON_CAROUSEL_DESC'),
	'settings' => [
		'carousel_items' => [
			'title' => Text::_('COM_SPPAGEBUILDER_ADDON_CAROUSEL_ITEMS'),
			'fields' => [
				'sp_carousel_item' => [
					'type' => 'repeatable',
					'title' => Text::_('COM_SPPAGEBUILDER_ADDON_CAROUSEL_ITEMS'),
					'attr'  => [
						'title' => [
							'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_TITLE'),
							'fields' => [
								'title' => [
									'type'  => 'text',
									'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_TITLE'),
									'std'   => 'Where Art and Technology Collide',
								],

								'title_padding' => [
									'type'       => 'padding',
									'title'      => Text::_('COM_SPPAGEBUILDER_ADDON_CAROUSEL_ITEM_TITLE_PADDING'),
									'std'        => ['xl' => '0px 0px 0px 0px', 'lg' => '', 'md' => '', 'sm' => '', 'xs' => ''],
									'responsive' => true
								],

								'title_margin' => [
									'type'       => 'margin',
									'title'      => Text::_('COM_SPPAGEBUILDER_ADDON_CAROUSEL_ITEM_TITLE_MARGIN'),
									'std'        => ['xl' => '0px 0px 0px 0px', 'lg' => '', 'md' => '', 'sm' => '', 'xs' => ''],
									'responsive' => true
								],
							],
						],

						'content' => [
							'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_CONTENT'),
							'fields' => [
								'content' => [
									'type'  => 'editor',
									'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_CONTENT'),
									'desc'  => Text::_('COM_SPPAGEBUILDER_ADDON_CAROUSEL_ITEM_CONTENT_DESC'),
									'std'   => 'You might remember the Dell computer commercials in which a youth reports this exciting news to his friends.<br />That they are about to get their new computer.'
								],

								'content_padding' => [
									'type'       => 'padding',
									'title'      => Text::_('COM_SPPAGEBUILDER_ADDON_CAROUSEL_ITEM_CONTENT_PADDING'),
									'std'        => ['xl' => '20px 0px 30px 0px', 'lg' => '', 'md' => '', 'sm' => '', 'xs' => ''],
									'responsive' => true
								],

								'content_margin' => [
									'type'       => 'margin',
									'title'      => Text::_('COM_SPPAGEBUILDER_ADDON_CONTENT_MARGIN'),
									'std'        => ['xl' => '0px 0px 0px 0px', 'lg' => '', 'md' => '', 'sm' => '', 'xs' => ''],
									'responsive' => true
								],

								'bg' => [
									'type'   => 'media',
									'title'  => Text::_('COM_SPPAGEBUILDER_GLOBAL_IMAGE'),
									'desc'   => Text::_('COM_SPPAGEBUILDER_ADDON_CAROUSEL_ITEM_IMAGE_DESC'),
									'format' => 'image',
									'std'    => ['src' => 'https://sppagebuilder.com/addons/carousel/carousel-bg.jpg']
								],
							],
						],

						'button' => [
							'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON'),
							'fields' => [
								'button_text' => [
									'type'  => 'text',
									'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_TEXT'),
									'desc'  => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_TEXT_DESC'),
									'std'   => 'Learn More',
								],

								'button_url' => [
									'type'         => 'link',
									'title'        => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_URL'),
									'desc'         => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_URL_DESC'),
								],

								'button_icon' => [
									'type'    => 'icon',
									'title'   => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_ICON'),
									'desc'    => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_ICON_DESC'),
								],

								'button_icon_position' => [
									'type'   => 'select',
									'title'  => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_ICON_POSITION'),
									'values' => [
										'left'  => Text::_('COM_SPPAGEBUILDER_GLOBAL_LEFT'),
										'right' => Text::_('COM_SPPAGEBUILDER_GLOBAL_RIGHT'),
									],
								],
							],
						],
					],
				],

				'alignment_separator' => [
					'type'   => 'separator',
				],

				'alignment' => [
					'type'   => 'alignment',
					'title'  => Text::_('COM_SPPAGEBUILDER_GLOBAL_ALIGNMENT'),
					'std' 	 => 'center',
				],
			],
		],

		'slider_options' => [
			'title' => Text::_('COM_SPPAGEBUILDER_ADDON_CAROUSEL_SLIDER_OPTIONS'),
			'fields' => [
				'autoplay' => [
					'type'   => 'checkbox',
					'title'  => Text::_('COM_SPPAGEBUILDER_ADDON_CAROUSEL_AUTOPLAY'),
					'desc'   => Text::_('COM_SPPAGEBUILDER_ADDON_CAROUSEL_AUTOPLAY_DESC'),
					'values' => [
						1 => Text::_('JYES'),
						0 => Text::_('JNO'),
					],
					'std' => 1,
				],

				'interval' => [
					'type'    => 'slider',
					'title'   => Text::_('COM_SPPAGEBUILDER_ADDON_CAROUSEL_INTERVAL'),
					'desc'    => Text::_('COM_SPPAGEBUILDER_ADDON_CAROUSEL_INTERVAL_DESC'),
					'std'     => 5,
					'depends' => [['autoplay', '=', 1]]
				],

				'speed' => [
					'type'  => 'slider',
					'title' => Text::_('COM_SPPAGEBUILDER_ADDON_CAROUSEL_SPEED'),
					'desc'  => Text::_('COM_SPPAGEBUILDER_ADDON_CAROUSEL_SPEED_DESC'),
					'std'   => 600,
				],

				'controllers' => [
					'type'   => 'checkbox',
					'title'  => Text::_('COM_SPPAGEBUILDER_ADDON_CAROUSEL_SHOW_CONTROLLERS'),
					'values' => [
						1 => Text::_('JYES'),
						0 => Text::_('JNO'),
					],
					'std' => 1,
				],

				'arrows' => [
					'type'   => 'checkbox',
					'title'  => Text::_('COM_SPPAGEBUILDER_ADDON_CAROUSEL_SHOW_ARROWS'),
					'values' => [
						1 => Text::_('JYES'),
						0 => Text::_('JNO'),
					],
					'std' => 1,
				],
			],
		],

		'options' => [
			'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_OPTIONS'),
			'fields' => [
				'options_tab' => [
					'type'   => 'buttons',
					'std'    => 'normal',
					'values' => [
						['label' => Text::_('COM_SPPAGEBUILDER_GLOBAL_TYPOGRAPHY'), 'value' => 'typography'],
						['label' => Text::_('COM_SPPAGEBUILDER_GLOBAL_COLOR'), 'value' => 'color'],
						['label' => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON'), 'value' => 'button'],
					],
					'std'   => 'typography',
					'tabs'    => true,
				],

				// typography
				'item_title_typography' => [
					'type' => 'typography',
					'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_TITLE'),
					'depends' => [['options_tab', '=', 'typography']],
				],

				'item_content_typography' => [
					'type' => 'typography',
					'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_CONTENT'),
					'depends' => [['options_tab', '=', 'typography']],
				],

				// color
				'item_title_color' => [
					'type'   => 'color',
					'title'	 => Text::_('COM_SPPAGEBUILDER_GLOBAL_TITLE'),
					'depends' => [['options_tab', '=', 'color']],
				],

				'item_content_color' => [
					'type'   => 'color',
					'title'	 => Text::_('COM_SPPAGEBUILDER_GLOBAL_CONTENT'),
					'depends' => [['options_tab', '=', 'color']],
				],

				// button
				'button_typography' => [
					'type' => 'typography',
					'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_TYPOGRAPHY'),
					'depends' => [['options_tab', '=', 'button']],
				],

				'button_type' => [
					'type'   => 'select',
					'title'  => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_STYLE'),
					'desc'   => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_STYLE_DESC'),
					'values' => [
						'default'   => Text::_('COM_SPPAGEBUILDER_GLOBAL_DEFAULT'),
						'primary'   => Text::_('COM_SPPAGEBUILDER_GLOBAL_PRIMARY'),
						'secondary' => Text::_('COM_SPPAGEBUILDER_GLOBAL_SECONDARY'),
						'success'   => Text::_('COM_SPPAGEBUILDER_GLOBAL_SUCCESS'),
						'info'      => Text::_('COM_SPPAGEBUILDER_GLOBAL_INFO'),
						'warning'   => Text::_('COM_SPPAGEBUILDER_GLOBAL_WARNING'),
						'danger'    => Text::_('COM_SPPAGEBUILDER_GLOBAL_DANGER'),
						'dark'      => Text::_('COM_SPPAGEBUILDER_GLOBAL_DARK'),
						'link'      => Text::_('COM_SPPAGEBUILDER_GLOBAL_LINK'),
						'custom'    => Text::_('COM_SPPAGEBUILDER_GLOBAL_CUSTOM'),
					],
					'std'   => 'custom',
					'depends' => [['options_tab', '=', 'button']],
				],

				'link_button_padding_bottom' => [
					'type'    => 'slider',
					'title'   => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_PADDING_BOTTOM'),
					'max'     => 100,
					'depends' => [
						['button_type', '=', 'link'],
						['options_tab', '=', 'button']
					],
				],

				'button_appearance' => [
					'type'   => 'select',
					'title'  => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_APPEARANCE'),
					'desc'   => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_APPEARANCE_DESC'),
					'values' => [
						''         => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_APPEARANCE_FLAT'),
						'gradient' => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_APPEARANCE_GRADIENT'),
						'outline'  => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_APPEARANCE_OUTLINE'),
					],
					'depends' => [
						['options_tab', '=', 'button'],
						['button_type', '!=', 'link'],
					],
				],

				'button_shape' => [
					'type'   => 'select',
					'title'  => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_SHAPE'),
					'desc'   => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_SHAPE_DESC'),
					'values' => [
						'rounded' => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_SHAPE_ROUNDED'),
						'square'  => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_SHAPE_SQUARE'),
						'round'   => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_SHAPE_ROUND'),
					],
					'std'   => 'rounded',
					'depends' => [
						['options_tab', '=', 'button'],
						['button_type', '!=', 'link'],
					],
				],

				'button_size' => [
					'type'   => 'select',
					'title'  => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_SIZE'),
					'desc'   => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_SIZE_DESC'),
					'values' => [
						''    => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_SIZE_DEFAULT'),
						'lg'  => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_SIZE_LARGE'),
						'xlg' => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_SIZE_XLARGE'),
						'sm'  => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_SIZE_SMALL'),
						'xs'  => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_SIZE_EXTRA_SAMLL'),
						'custom' => Text::_('COM_SPPAGEBUILDER_GLOBAL_CUSTOM'),
					],
					'depends' => [['options_tab', '=', 'button']],
				],

				'button_padding' => [
					'type'    => 'padding',
					'title'   => Text::_('COM_SPPAGEBUILDER_GLOBAL_PADDING'),
					'responsive' => true,
					'std' => ['xl' => '8px 22px 10px 22px', 'lg' => '', 'md' => '', 'sm' => '', 'xs' => ''],
					'depends' => [
						['button_size', '=', 'custom'],
						['options_tab', '=', 'button']
					],
				],

				'button_block' => [
					'type'   => 'select',
					'title'  => Text::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_BLOCK'),
					'values' => [
						''               => Text::_('JNO'),
						'sppb-btn-block' => Text::_('JYES'),
					],
					'depends' => [
						['options_tab', '=', 'button'],
						['button_type', '!=', 'link'],
					],
				],

				'button_colors_tab' => [
					'type'   => 'buttons',
					'std'    => 'normal',
					'values' => [
						['label' => Text::_('COM_SPPAGEBUILDER_GLOBAL_NORMAL'), 'value' => 'normal'],
						['label' => Text::_('COM_SPPAGEBUILDER_GLOBAL_HOVER'), 'value' => 'hover'],
					],
					'std'   => 'typography',
					'tabs'    => true,
					'depends' => [
						['options_tab', '=', 'button'],
						['button_type', '=', 'custom'],
					],
				],

				'button_color' => [
					'type' => 'color',
					'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_COLOR'),
					'std' => '#FFFFFF',
					'depends' => [
						['options_tab', '=', 'button'],
						['button_type', '=', 'custom'],
						['button_colors_tab', '!=', 'hover'],
					],
				],

				'button_color_hover' => [
					'type' => 'color',
					'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_COLOR'),
					'std' => '#FFFFFF',
					'depends' => [
						['options_tab', '=', 'button'],
						['button_type', '=', 'custom'],
						['button_colors_tab', '=', 'hover'],
					],
				],

				'button_background_color' => [
					'type'    => 'color',
					'title'   => Text::_('COM_SPPAGEBUILDER_GLOBAL_BACKGROUND'),
					'std'     => '#3366FF',
					'depends' => [
						['options_tab', '=', 'button'],
						['button_type', '=', 'custom'],
						['button_appearance', '!=', 'gradient'],
						['button_colors_tab', '!=', 'hover'],
					],
				],

				'button_background_color_hover' => [
					'type'    => 'color',
					'title'   => Text::_('COM_SPPAGEBUILDER_GLOBAL_BACKGROUND'),
					'std'     => '#0037DD',
					'depends' => [
						['options_tab', '=', 'button'],
						['button_type', '=', 'custom'],
						['button_appearance', '!=', 'gradient'],
						['button_colors_tab', '=', 'hover'],
					],
				],

				'button_background_gradient' => [
					'type' => 'gradient',
					'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_BACKGROUND'),
					'std' => [
						"color"  => "#3366FF",
						"color2" => "#0037DD",
						"deg" => "45",
						"type" => "linear"
					],
					'depends' => [
						['options_tab', '=', 'button'],
						['button_type', '=', 'custom'],
						['button_appearance', '=', 'gradient'],
						['button_colors_tab', '!=', 'hover'],
					],
				],

				'button_background_gradient_hover' => [
					'type' => 'gradient',
					'title' => Text::_('COM_SPPAGEBUILDER_GLOBAL_BACKGROUND'),
					'std' => [
						"color"  => "#0037DD",
						"color2" => "#3366FF",
						"deg" => "45",
						"type" => "linear"
					],
					'depends' => [
						['options_tab', '=', 'button'],
						['button_type', '=', 'custom'],
						['button_appearance', '=', 'gradient'],
						['button_colors_tab', '=', 'hover'],
					],
				],

				// Link style button
				'link_button_colors_tab' => [
					'type'   => 'buttons',
					'std'    => 'normal',
					'values' => [
						['label' => Text::_('COM_SPPAGEBUILDER_GLOBAL_NORMAL'), 'value' => 'normal'],
						['label' => Text::_('COM_SPPAGEBUILDER_GLOBAL_HOVER'), 'value' => 'hover'],
					],
					'std'   => 'typography',
					'tabs'    => true,
					'depends' => [
						['options_tab', '=', 'button'],
						['button_type', '=', 'link'],
					],
				],

				'link_button_color' => [
					'type'    => 'color',
					'title'   => Text::_('COM_SPPAGEBUILDER_GLOBAL_COLOR'),
					'depends' => [
						['options_tab', '=', 'button'],
						['button_type', '=', 'link'],
						['link_button_colors_tab', '!=', 'hover'],
					],
				],

				'link_button_border_width' => [
					'type'    => 'slider',
					'title'   => Text::_('COM_SPPAGEBUILDER_GLOBAL_BORDER_WIDTH'),
					'max'     => 30,
					'depends' => [
						['options_tab', '=', 'button'],
						['button_type', '=', 'link'],
						['link_button_colors_tab', '!=', 'hover'],
					],
				],

				'link_button_border_color' => [
					'type'    => 'color',
					'title'   => Text::_('COM_SPPAGEBUILDER_GLOBAL_BORDER_COLOR'),
					'std'     => '',
					'depends' => [
						['options_tab', '=', 'button'],
						['button_type', '=', 'link'],
						['link_button_colors_tab', '!=', 'hover'],
					],
				],

				//Link Hover
				'link_button_hover_color' => [
					'type'    => 'color',
					'title'   => Text::_('COM_SPPAGEBUILDER_GLOBAL_COLOR'),
					'std'     => '',
					'depends' => [
						['options_tab', '=', 'button'],
						['button_type', '=', 'link'],
						['link_button_colors_tab', '=', 'hover'],
					],
				],

				'link_button_border_hover_color' => [
					'type'    => 'color',
					'title'   => Text::_('COM_SPPAGEBUILDER_GLOBAL_BORDER_COLOR'),
					'std'     => '',
					'depends' => [
						['options_tab', '=', 'button'],
						['button_type', '=', 'link'],
						['link_button_colors_tab', '=', 'hover'],
					],
				],
			],
		],
	],
]);
